/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.SkyRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;

@Mixin(value={SkyRenderer.class})
public class SkyLevelRendererMixin {
    @Unique
    private boolean legacySkyShape = (Boolean)LegacyOptions.legacySkyShape.get();

    @ModifyVariable(method={"buildStars"}, at=@At(value="STORE"), ordinal=4)
    private float drawStars(float original) {
        return original - 0.05f;
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexBuffer;uploadStatic(Lcom/mojang/blaze3d/vertex/VertexFormat$Mode;Lcom/mojang/blaze3d/vertex/VertexFormat;Ljava/util/function/Consumer;)Lcom/mojang/blaze3d/vertex/VertexBuffer;", ordinal=1))
    private VertexFormat.Mode changeLightSkyMode(VertexFormat.Mode par1) {
        return (Boolean)LegacyOptions.legacySkyShape.get() != false ? VertexFormat.Mode.QUADS : par1;
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexBuffer;uploadStatic(Lcom/mojang/blaze3d/vertex/VertexFormat$Mode;Lcom/mojang/blaze3d/vertex/VertexFormat;Ljava/util/function/Consumer;)Lcom/mojang/blaze3d/vertex/VertexBuffer;", ordinal=2))
    private VertexFormat.Mode changeDarkSkyMode(VertexFormat.Mode par1) {
        return (Boolean)LegacyOptions.legacySkyShape.get() != false ? VertexFormat.Mode.QUADS : par1;
    }

    @Inject(method={"buildSkyDisc"}, at={@At(value="HEAD")}, cancellable=true)
    private void buildSkyDisc(VertexConsumer vertexConsumer, float f, CallbackInfo ci) {
        if (this.legacySkyShape) {
            Legacy4JClient.buildLegacySkyDisc(vertexConsumer, f);
            ci.cancel();
        }
    }
}

