/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.stonecutter;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={StonecutterScreen.class})
public abstract class StonecutterScreenMixin
extends AbstractContainerScreen<StonecutterMenu> {
    private LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    @Shadow
    private int startIndex;
    @Shadow
    private boolean displayRecipes;
    @Shadow
    private boolean scrolling;

    @Shadow
    protected abstract int getOffscreenRows();

    @Shadow
    protected abstract boolean isScrollBarActive();

    public StonecutterScreenMixin(StonecutterMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Redirect(method={"isScrollBarActive"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/StonecutterMenu;getNumberOfVisibleRecipes()I"))
    private int isScrollBarActive(StonecutterMenu instance) {
        return this.getNumRecipes() - 4;
    }

    @Inject(method={"getOffscreenRows"}, at={@At(value="HEAD")}, cancellable=true)
    private void getOffscreenRows(CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)Math.max(0, this.getNumRecipes() / 4 - 4));
    }

    @Unique
    private int getNumRecipes() {
        return ((StonecutterMenu)this.menu).getNumberOfVisibleRecipes();
    }

    @Unique
    private List<SelectableRecipe.SingleInputEntry<StonecutterRecipe>> getRecipes() {
        return ((StonecutterMenu)this.menu).getVisibleRecipes().entries();
    }

    @Unique
    private ItemStack getResultItem(SelectableRecipe.SingleInputEntry<StonecutterRecipe> recipe) {
        return recipe.recipe().optionDisplay().resolveForFirstStack(SlotDisplayContext.fromLevel((Level)this.minecraft.level));
    }

    public void init() {
        this.imageWidth = 215;
        this.imageHeight = 208;
        this.inventoryLabelX = 14;
        this.inventoryLabelY = 95;
        this.titleLabelX = 14;
        this.titleLabelY = 10;
        super.init();
        for (int i = 0; i < ((StonecutterMenu)this.menu).slots.size(); ++i) {
            Slot s = (Slot)((StonecutterMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 31, 45, new LegacySlotDisplay(this){

                    @Override
                    public int getWidth() {
                        return 23;
                    }
                });
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, 166, 41, new LegacySlotDisplay(this){

                    @Override
                    public int getWidth() {
                        return 32;
                    }
                });
                continue;
            }
            if (i < ((StonecutterMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 14 + (s.getContainerSlot() - 9) % 9 * 21, 108 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 14 + s.getContainerSlot() * 21, 178);
        }
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 70, this.topPos + 18, 75, 75);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)this.leftPos + 148.5, (double)(this.topPos + 18), 0.0);
        if (this.isScrollBarActive() && this.getOffscreenRows() > 0) {
            if (this.getOffscreenRows() != this.startIndex) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.DOWN, 0, 79);
            }
            if (this.startIndex > 0) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.UP, 0, -11);
            }
        } else {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 0.5f);
        }
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, 0, 0, 13, 75);
        guiGraphics.pose().translate(-2.0f, -1.0f + (this.isScrollBarActive() ? 61.5f * (float)this.startIndex / (float)this.getOffscreenRows() : 0.0f), 0.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL, 0, 0, 16, 16);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        FactoryScreenUtil.disableBlend();
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.leftPos + 71.5f, (float)this.topPos + 19.5f, 0.0f);
        if (this.displayRecipes) {
            int size = this.getRecipes().size();
            block0: for (int p = 0; p < 4; ++p) {
                for (int q = 0; q < 4; ++q) {
                    int r = p + this.startIndex;
                    int s = r * 4 + q;
                    if (s >= size) break block0;
                    int t = q * 18;
                    int u = p * 18;
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(s == ((StonecutterMenu)this.menu).getSelectedRecipeIndex() ? LegacySprites.BUTTON_SLOT_SELECTED : (ScreenUtil.isMouseOver(i, j, (float)this.leftPos + 73.5f + (float)t, (float)this.topPos + 19.5f + (float)u, 18, 18) ? LegacySprites.BUTTON_SLOT_HIGHLIGHTED : LegacySprites.BUTTON_SLOT), t, u, 18, 18);
                    guiGraphics.renderItem(this.getResultItem(this.getRecipes().get(s)), 1 + t, 1 + u);
                }
            }
        }
        guiGraphics.pose().popPose();
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseClicked(double d, double e, int i, CallbackInfoReturnable<Boolean> cir) {
        this.scrolling = false;
        if (this.displayRecipes) {
            double j = (double)this.leftPos + 71.5;
            double k = (double)this.topPos + 19.5;
            for (int m = this.startIndex; m < this.startIndex + 16; ++m) {
                int n = m - this.startIndex;
                double f = d - (j + (double)(n % 4 * 18));
                double g = e - (k + (double)(n / 4 * 18));
                if (!(f >= 0.0 && g >= 0.0 && f < 18.0 && g < 18.0 && ((StonecutterMenu)this.menu).clickMenuButton((Player)this.minecraft.player, m))) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((StonecutterMenu)this.menu).containerId, m);
                cir.setReturnValue((Object)true);
                return;
            }
            if (ScreenUtil.isMouseOver(d, e, (double)this.leftPos + 148.5, this.topPos + 18, 13, 75)) {
                this.scrolling = true;
            }
        }
        cir.setReturnValue((Object)super.mouseClicked(d, e, i));
    }

    @Inject(method={"renderTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderTooltip(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        ci.cancel();
        super.renderTooltip(guiGraphics, i, j);
        if (this.displayRecipes) {
            int size = this.getRecipes().size();
            block0: for (int p = 0; p < 4; ++p) {
                for (int q = 0; q < 4; ++q) {
                    int r = p + this.startIndex;
                    int s = r * 4 + q;
                    if (s >= size) break block0;
                    if (!ScreenUtil.isMouseOver(i, j, (float)this.leftPos + 73.5f + (float)(q * 18), (float)this.topPos + 19.5f + (float)(p * 18), 18, 18)) continue;
                    guiGraphics.renderTooltip(this.font, this.getResultItem(this.getRecipes().get(s)), i, j);
                }
            }
        }
    }

    @Inject(method={"mouseDragged"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseDragged(double d, double e, int i, double f, double g, CallbackInfoReturnable<Boolean> cir) {
        if (this.scrolling && this.displayRecipes && this.isScrollBarActive()) {
            int oldIndex = this.startIndex;
            this.startIndex = (int)Math.max(Math.round((double)this.getOffscreenRows() * Math.min(1.0, (e - (double)(this.topPos + 18)) / 75.0)), 0L) * 4;
            if (oldIndex != this.startIndex) {
                this.scrollRenderer.updateScroll(oldIndex - this.startIndex > 0 ? ScreenDirection.UP : ScreenDirection.DOWN);
            }
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)super.mouseDragged(d, e, i, f, g));
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/inventory/StonecutterScreen;startIndex:I"))
    private void mouseDragged(StonecutterScreen instance, int value) {
        if (this.startIndex != value) {
            this.scrollRenderer.updateScroll(this.startIndex - value > 0 ? ScreenDirection.UP : ScreenDirection.DOWN);
            this.startIndex = value;
        }
    }
}

