/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.GuiAccessor;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.ColorUtil;
import wily.factoryapi.util.FactoryGuiElement;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.BufferSourceWrapper;
import wily.legacy.client.ClientEntityAccessor;
import wily.legacy.client.CommonColor;
import wily.legacy.client.CommonValue;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScreen;
import wily.legacy.network.TopMessage;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.MCAccount;

public class ScreenUtil {
    public static final ResourceLocation GUI_ATLAS = FactoryAPI.createVanillaLocation((String)"textures/atlas/gui.png");
    private static final Minecraft mc = Minecraft.getInstance();
    public static long lastHotbarSelectionChange = -1L;
    public static long animatedCharacterTime;
    public static long remainingAnimatedCharacterTime;
    public static int lastHotbarSelection;
    public static long lastGui;
    protected static final LogoRenderer logoRenderer;
    public static final PanoramaRenderer panoramaRenderer;
    public static final LegacyIconHolder iconHolderRenderer;
    public static final ResourceLocation MINECRAFT;
    public static final ResourceLocation PANORAMA_DAY;
    public static final ResourceLocation PANORAMA_NIGHT;
    public static final ResourceLocation MENU_BACKGROUND;
    public static final ResourceLocation LOADING_BACKGROUND;
    public static final Bearer<Integer> actualPlayerTabWidth;
    public static final Bearer<Integer> actualPlayerTabHeight;

    public static void updateAnimatedCharacterTime(long remainingTime) {
        animatedCharacterTime = Util.getMillis();
        remainingAnimatedCharacterTime = remainingTime;
    }

    public static void renderPointerPanel(GuiGraphics graphics, int x, int y, int width, int height) {
        ScreenUtil.blitTranslucentOverlaySprite(graphics, LegacySprites.POINTER_PANEL, x, y, width, height);
    }

    public static void blitTranslucentOverlaySprite(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        FactoryGuiGraphics.of((GuiGraphics)graphics).disableDepthTest();
        ScreenUtil.blitTranslucentSprite(graphics, sprite, x, y, width, height);
        FactoryGuiGraphics.of((GuiGraphics)graphics).enableDepthTest();
    }

    public static void blitTranslucentSprite(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(sprite, x, y, width, height);
        FactoryScreenUtil.disableBlend();
    }

    public static void renderPanelTranslucentRecess(GuiGraphics graphics, int x, int y, int width, int height) {
        ScreenUtil.blitTranslucentSprite(graphics, LegacySprites.PANEL_TRANSLUCENT_RECESS, x, y, width, height);
    }

    public static void drawAutoSavingIcon(GuiGraphics graphics, int x, int y) {
        graphics.pose().pushPose();
        graphics.pose().scale(0.5f, 0.5f, 1.0f);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SAVE_CHEST, x * 2, y * 2, 48, 48);
        graphics.pose().popPose();
        graphics.pose().pushPose();
        double heightAnim = (double)Util.getMillis() / 50.0 % 11.0;
        graphics.pose().translate((double)x + 5.5, (double)(y - 8) - (heightAnim > 5.0 ? 10.0 - heightAnim : heightAnim), 0.0);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SAVE_ARROW, 0, 0, 13, 16);
        graphics.pose().popPose();
    }

    public static void renderDefaultBackground(UIAccessor accessor, GuiGraphics guiGraphics) {
        ScreenUtil.renderDefaultBackground(accessor, guiGraphics, true);
    }

    public static void renderDefaultBackground(UIAccessor accessor, GuiGraphics guiGraphics, boolean title) {
        ScreenUtil.renderDefaultBackground(accessor, guiGraphics, false, title, true);
    }

    public static boolean isVisualNight() {
        return ScreenUtil.mc.level != null && ScreenUtil.mc.level.isNight();
    }

    public static void renderDefaultBackground(UIAccessor accessor, GuiGraphics guiGraphics, boolean forcePanorama, boolean title, boolean username) {
        if (ScreenUtil.mc.level == null || accessor.getBoolean("forcePanorama", Boolean.valueOf(forcePanorama)).booleanValue()) {
            ScreenUtil.renderPanorama(guiGraphics, 1.0f, FactoryAPIClient.getPartialTick());
        } else {
            accessor.getScreen().renderTransparentBackground(guiGraphics);
        }
        if (accessor.getBoolean("hasTitle", Boolean.valueOf(title)).booleanValue()) {
            ScreenUtil.renderLogo(guiGraphics);
        }
        if (accessor.getBoolean("hasUsername", Boolean.valueOf(username)).booleanValue()) {
            ScreenUtil.renderUsername(guiGraphics);
        }
    }

    public static void renderLogo(GuiGraphics guiGraphics) {
        logoRenderer.renderLogo(guiGraphics, guiGraphics.guiWidth(), 1.0f);
    }

    public static void renderLegacyLogo(GuiGraphics guiGraphics) {
        FactoryScreenUtil.enableBlend();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(((float)guiGraphics.guiWidth() - 285.5f) / 2.0f, 30.0f, 0.0f);
        guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(mc.getResourceManager().getResource(MINECRAFT).isPresent() ? MINECRAFT : ControlType.getActiveType().getMinecraftLogo(), 0, 0, 0.0f, 0.0f, 571, 138, 571, 138);
        guiGraphics.pose().popPose();
        FactoryScreenUtil.disableBlend();
    }

    public static void renderTransparentBackground(GuiGraphics graphics) {
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)graphics).blit(MENU_BACKGROUND, 0, 0, 0.0f, 0.0f, graphics.guiWidth(), graphics.guiHeight(), graphics.guiWidth(), graphics.guiHeight());
        FactoryScreenUtil.disableBlend();
    }

    public static void renderUsername(GuiGraphics graphics) {
        if (ScreenUtil.mc.level != null) {
            return;
        }
        String username = MCAccount.isOfflineUser() ? I18n.get((String)"legacy.menu.offline_user", (Object[])new Object[]{mc.getUser().getName()}) : mc.getUser().getName();
        graphics.drawString(ScreenUtil.mc.font, username, graphics.guiWidth() - 33 - ScreenUtil.mc.font.width(username), graphics.guiHeight() - 27, 0xFFFFFF);
    }

    public static void renderPanorama(GuiGraphics guiGraphics, float speed, float partialTick) {
        panoramaRenderer.render(guiGraphics, guiGraphics.guiWidth(), guiGraphics.guiHeight(), speed, partialTick);
    }

    public static void renderLegacyPanorama(GuiGraphics guiGraphics) {
        ScreenUtil.renderLegacyPanorama(guiGraphics, ScreenUtil.isVisualNight());
    }

    public static void renderLegacyPanorama(GuiGraphics guiGraphics, boolean isNight) {
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).disableDepthTest();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(isNight ? PANORAMA_NIGHT : PANORAMA_DAY, 0, 0, ((Double)ScreenUtil.mc.options.panoramaSpeed().get()).floatValue() * (float)Util.getMillis() * (float)guiGraphics.guiHeight() / 360.0f / 66.32f, 1.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight() + 2, guiGraphics.guiHeight() * 820 / 144, guiGraphics.guiHeight() + 2);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).enableDepthTest();
    }

    public static void drawOutlinedString(GuiGraphics graphics, Font font, Component component, int x, int y, int color, int outlineColor, float outline) {
        ScreenUtil.drawOutlinedString(graphics, font, component.getVisualOrderText(), x, y, color, outlineColor, outline);
    }

    public static void drawOutlinedString(GuiGraphics graphics, Font font, FormattedCharSequence formattedCharSequence, int x, int y, int color, int outlineColor, float outline) {
        ScreenUtil.drawStringOutline(graphics, font, formattedCharSequence, x, y, outlineColor, outline);
        graphics.drawString(font, formattedCharSequence, x, y, color, false);
    }

    public static void drawStringOutline(GuiGraphics graphics, Font font, FormattedCharSequence formattedCharSequence, int x, int y, int outlineColor, float outline) {
        float[] translations;
        for (float t : translations = new float[]{0.0f, outline, -outline}) {
            for (float t1 : translations) {
                if (t == 0.0f && t1 == 0.0f) continue;
                graphics.pose().pushPose();
                graphics.pose().translate(t, t1, 0.0f);
                graphics.drawString(font, formattedCharSequence, x, y, outlineColor, false);
                graphics.pose().popPose();
            }
        }
    }

    public static boolean isMouseOver(double mouseX, double mouseY, double x, double y, int width, int height) {
        return mouseX >= x && mouseX < x + (double)width && mouseY >= y && mouseY < y + (double)height;
    }

    public static void applyHUDScale(GuiGraphics graphics) {
        graphics.pose().scale(3.0f / ScreenUtil.getHUDScale(), 3.0f / ScreenUtil.getHUDScale(), 3.0f / ScreenUtil.getHUDScale());
    }

    public static void prepareHUDRender(GuiGraphics graphics) {
        graphics.pose().pushPose();
        FactoryGuiGraphics.of((GuiGraphics)graphics).setColor(1.0f, 1.0f, 1.0f, ScreenUtil.getHUDOpacity());
        graphics.pose().translate(0.0, ScreenUtil.getHUDDistance(), 0.0);
        FactoryScreenUtil.enableBlend();
    }

    public static void finalizeHUDRender(GuiGraphics graphics) {
        graphics.pose().popPose();
        FactoryGuiGraphics.of((GuiGraphics)graphics).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        FactoryScreenUtil.disableBlend();
    }

    public static boolean hasClassicCrafting() {
        return (Boolean)LegacyOptions.classicCrafting.get();
    }

    public static boolean hasMixedCrafting() {
        return ((Boolean)LegacyOptions.forceMixedCrafting.get() != false || !Legacy4JClient.hasModOnServer()) && (Boolean)LegacyOptions.classicCrafting.get() == false;
    }

    public static float getHUDScale() {
        return Math.max(1.5f, (float)(4 - (Integer)LegacyOptions.hudScale.get()));
    }

    public static float getHUDSize() {
        return 6.0f + 3.0f / ScreenUtil.getHUDScale() * (float)(35 + (ScreenUtil.mc.gameMode.canHurtPlayer() ? Math.max(2, Mth.ceil((double)((Math.max(ScreenUtil.mc.player.getAttributeValue(Attributes.MAX_HEALTH), (double)Math.max((float)ScreenUtil.mc.gui.displayHealth, ScreenUtil.mc.player.getHealth())) + (double)ScreenUtil.mc.player.getAbsorptionAmount()) / 20.0)) + (ScreenUtil.mc.player.getArmorValue() > 0 ? 1 : 0)) * 10 : 0));
    }

    public static double getHUDDistance() {
        return -((Double)LegacyOptions.hudDistance.get()).doubleValue() * (22.5 + ((Boolean)LegacyOptions.inGameTooltips.get() != false ? 17.5 : 0.0));
    }

    public static float getHUDOpacity() {
        float f = (float)(Util.getMillis() - lastHotbarSelectionChange) / 1200.0f;
        return ScreenUtil.getInterfaceOpacity() <= 0.8f ? Math.min(0.8f, ScreenUtil.getInterfaceOpacity() + (1.0f - ScreenUtil.getInterfaceOpacity()) * (f >= 3.0f ? Math.max(4.0f - f, 0.0f) : 1.0f)) : ScreenUtil.getInterfaceOpacity();
    }

    public static boolean hasTooltipBoxes() {
        return (Boolean)LegacyOptions.tooltipBoxes.get();
    }

    public static boolean hasTooltipBoxes(UIAccessor accessor) {
        return ScreenUtil.hasTooltipBoxes() && accessor.getBoolean("hasTooltipBox", Boolean.valueOf(true)) != false;
    }

    public static float getInterfaceOpacity() {
        return ((Double)LegacyOptions.hudOpacity.get()).floatValue();
    }

    public static int getDefaultTextColor(boolean forceWhite) {
        return !forceWhite ? (Integer)CommonColor.HIGHLIGHTED_WIDGET_TEXT.get() : (Integer)CommonColor.WIDGET_TEXT.get();
    }

    public static int getDefaultTextColor() {
        return ScreenUtil.getDefaultTextColor(false);
    }

    public static boolean hasProgrammerArt() {
        return mc.getResourcePackRepository().getSelectedPacks().stream().anyMatch(p -> p.getId().equals("programmer_art"));
    }

    public static void playSimpleUISound(SoundEvent sound, float volume, float pitch, boolean randomPitch) {
        RandomSource source = SoundInstance.createUnseededRandom();
        mc.getSoundManager().play((SoundInstance)new SimpleSoundInstance(sound.location(), SoundSource.MASTER, volume, pitch + (randomPitch ? (source.nextFloat() - 0.5f) / 10.0f : 0.0f), source, false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
    }

    public static void playSimpleUISound(SoundEvent sound, float pitch, boolean randomPitch) {
        ScreenUtil.playSimpleUISound(sound, 1.0f, pitch, randomPitch);
    }

    public static void playSimpleUISound(SoundEvent sound, float pitch) {
        ScreenUtil.playSimpleUISound(sound, pitch, false);
    }

    public static void playSimpleUISound(SoundEvent sound, boolean randomPitch) {
        ScreenUtil.playSimpleUISound(sound, 1.0f, randomPitch);
    }

    public static void drawGenericLoading(GuiGraphics graphics, int x, int y) {
        ScreenUtil.drawGenericLoading(graphics, x, y, 21, 6);
    }

    public static void drawGenericLoading(GuiGraphics graphics, int x, int y, int blockSize, int blockDistance) {
        int blockD = blockSize + blockDistance;
        for (int i = 0; i < 8; ++i) {
            float alpha;
            int v = (i + 1) * 100;
            int n = (i + 3) * 100;
            float l = (float)Util.getMillis() / 4.0f % 1000.0f;
            float f = l >= (float)(v - 100) ? (l <= (float)v ? l / (float)v : ((float)n - l) / 200.0f) : (alpha = 0.0f);
            if (!(alpha > 0.0f)) continue;
            FactoryGuiGraphics.of((GuiGraphics)graphics).setColor(1.0f, 1.0f, 1.0f, alpha, true);
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.LOADING_BLOCK, x + (i <= 2 ? i : (i >= 4 ? (i == 7 ? 0 : 6 - i) : 2)) * blockD, y + (i <= 2 ? 0 : (i == 3 || i == 7 ? 1 : 2)) * blockD, blockSize, blockSize);
        }
        FactoryGuiGraphics.of((GuiGraphics)graphics).clearColor();
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component component, int j, int k, int l, int m, int n, boolean shadow) {
        ScreenUtil.renderScrollingString(guiGraphics, font, component.getVisualOrderText(), j, k, l, m, n, shadow);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, FormattedCharSequence charSequence, int j, int k, int l, int m, int n, boolean shadow) {
        ScreenUtil.renderScrollingString(guiGraphics, font, charSequence, j, k, l, m, n, shadow, font.width(charSequence));
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, FormattedCharSequence charSequence, int j, int k, int l, int m, int n, boolean shadow, int stringWidth) {
        Objects.requireNonNull(font);
        int p = (k + m - 9) / 2 + 1;
        int q = l - j;
        if (stringWidth > q) {
            int r = stringWidth - q;
            double d = (double)Util.getMillis() / 1000.0;
            double e = Math.max((double)r * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = Mth.lerp((double)f, (double)0.0, (double)r);
            guiGraphics.enableScissor(j, k, l, m);
            guiGraphics.drawString(font, charSequence, j - (int)g, p, n, shadow && (Boolean)CommonValue.WIDGET_TEXT_SHADOW.get() != false);
            guiGraphics.disableScissor();
        } else {
            guiGraphics.drawString(font, charSequence, j, p, n, shadow && (Boolean)CommonValue.WIDGET_TEXT_SHADOW.get() != false);
        }
    }

    public static void secureTranslucentRender(GuiGraphics graphics, boolean translucent, float alpha, Consumer<Boolean> render) {
        if (!translucent) {
            render.accept(false);
            return;
        }
        FactoryGuiGraphics.of((GuiGraphics)graphics).pushBufferSource((MultiBufferSource.BufferSource)BufferSourceWrapper.translucent(FactoryGuiGraphics.of((GuiGraphics)graphics).getBufferSource()));
        graphics.flush();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        FactoryScreenUtil.enableBlend();
        render.accept(true);
        FactoryScreenUtil.disableBlend();
        graphics.flush();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FactoryGuiGraphics.of((GuiGraphics)graphics).popBufferSource();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHovering(Slot slot, int leftPos, int topPos, double d, double e) {
        double d2;
        double d3;
        LegacyIconHolder holder = iconHolderRenderer.slotBounds(slot);
        int width = holder.getWidth();
        int height = holder.getHeight();
        double xCorner = (double)holder.getXCorner() + holder.offset.x();
        double yCorner = (double)holder.getYCorner() + holder.offset.y();
        d -= (double)leftPos;
        if (!(d3 >= xCorner)) return false;
        if (!(d < xCorner + (double)width)) return false;
        e -= (double)topPos;
        if (!(d2 >= yCorner)) return false;
        if (!(e < yCorner + (double)height)) return false;
        return true;
    }

    public static void renderEntity(GuiGraphics guiGraphics, float x, float y, int size, float partialTicks, Vector3f vector3f, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, Entity entity) {
        ScreenUtil.renderEntity(guiGraphics, x, y, size, partialTicks, vector3f, quaternionf, quaternionf2, entity, false);
    }

    public static void renderEntity(GuiGraphics guiGraphics, float x, float y, int size, float partialTicks, Vector3f vector3f, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, Entity entity, boolean forceSize) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)x, (double)y, 50.0);
        float h = forceSize ? Math.max(1.0f, Math.max(entity.getBbWidth(), entity.getBbHeight())) : 1.0f;
        guiGraphics.pose().mulPose(new Matrix4f().scaling((float)size / h, (float)size / h, (float)(-size) / h));
        guiGraphics.pose().translate(vector3f.x, vector3f.y, vector3f.z);
        guiGraphics.pose().mulPose(quaternionf);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        if (quaternionf2 != null) {
            quaternionf2.conjugate();
            entityRenderDispatcher.overrideCameraOrientation(quaternionf2);
        }
        entityRenderDispatcher.setRenderShadow(false);
        entityRenderDispatcher.render(entity, 0.0, 0.0, 0.0, partialTicks, guiGraphics.pose(), (MultiBufferSource)FactoryGuiGraphics.of((GuiGraphics)guiGraphics).getBufferSource(), 0xF000F0);
        guiGraphics.flush();
        entityRenderDispatcher.setRenderShadow(true);
        guiGraphics.pose().popPose();
        Lighting.setupFor3DItems();
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics guiGraphics, int i, int j, int k, int l, int m, float f, float g, float h, LivingEntity livingEntity) {
        float n = (float)(i + k) / 2.0f;
        float o = (float)(j + l) / 2.0f;
        guiGraphics.enableScissor(i, j, k, l);
        float p = (float)Math.atan((n - g) / 40.0f);
        float q = (float)Math.atan((o - h) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(q * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float r = livingEntity.yBodyRot;
        float s = livingEntity.getYRot();
        float t = livingEntity.getXRot();
        float u = livingEntity.yHeadRotO;
        float v = livingEntity.yHeadRot;
        livingEntity.yBodyRot = 180.0f + p * 20.0f;
        livingEntity.setYRot(180.0f + p * 40.0f);
        livingEntity.setXRot(-q * 20.0f);
        livingEntity.yHeadRot = livingEntity.getYRot();
        livingEntity.yHeadRotO = livingEntity.getYRot();
        Vector3f vector3f = new Vector3f(0.0f, livingEntity.getBbHeight() / 2.0f + f, 0.0f);
        ScreenUtil.renderEntity(guiGraphics, n, o, m, 1.0f, vector3f, quaternionf, quaternionf2, (Entity)livingEntity);
        livingEntity.yBodyRot = r;
        livingEntity.setYRot(s);
        livingEntity.setXRot(t);
        livingEntity.yHeadRotO = u;
        livingEntity.yHeadRot = v;
        guiGraphics.disableScissor();
    }

    public static void renderLocalPlayerHead(GuiGraphics guiGraphics, int x, int y, int size) {
        if (ScreenUtil.mc.player == null) {
            return;
        }
        PlayerFaceRenderer.draw((GuiGraphics)guiGraphics, (PlayerSkin)ScreenUtil.mc.player.getSkin(), (int)x, (int)y, (int)size);
    }

    public static double getInterfaceResolution() {
        return 1.5 - (Double)LegacyOptions.interfaceResolution.get();
    }

    public static double getGuiScale() {
        int h = (Boolean)LegacyOptions.autoResolution.get() != false ? ScreenUtil.getStandardHeight() : mc.getWindow().getHeight();
        return (double)h / 360.0 * ScreenUtil.getTweakedHeightScale(h) * (Double)CommonValue.SCALE_MULTIPLIER.get();
    }

    public static double getTweakedHeightScale(int height) {
        if (((Boolean)LegacyOptions.autoResolution.get()).booleanValue()) {
            if (height == 1080) {
                return 0.999623452;
            }
            if (height % 720 != 0) {
                return 1.001;
            }
            return 1.0;
        }
        return ScreenUtil.getInterfaceResolution();
    }

    public static int getStandardHeight() {
        return Math.round((float)mc.getWindow().getHeight() / 180.0f) * 180;
    }

    public static boolean is720p() {
        return ScreenUtil.getStandardHeight() <= 720;
    }

    public static float getTextScale() {
        return (Boolean)LegacyOptions.legacyItemTooltipScaling.get() != false ? Math.max(0.6666667f, Math.min(720.0f / (float)ScreenUtil.getStandardHeight(), 1.3333334f)) : 1.0f;
    }

    public static float getChatSafeZone() {
        return 29.0f * ((Double)LegacyOptions.hudDistance.get()).floatValue();
    }

    public static int getSelectedItemTooltipLines() {
        return (Integer)LegacyOptions.selectedItemTooltipLines.get() == 0 ? 0 : (Integer)LegacyOptions.selectedItemTooltipLines.get() + ((Boolean)LegacyOptions.itemTooltipEllipsis.get() != false ? 1 : 0);
    }

    public static boolean canDisplayHUD() {
        int hudDelay = (Integer)LegacyOptions.hudDelay.get();
        return (Boolean)LegacyOptions.displayHUD.get() != false && (hudDelay == 0 || Util.getMillis() - lastGui > (long)hudDelay);
    }

    public static void renderAnimatedCharacter(GuiGraphics guiGraphics) {
        block6: {
            LivingEntity character;
            block7: {
                block8: {
                    boolean hasRemainingTime;
                    Entity entity = mc.getCameraEntity();
                    if (!(entity instanceof LivingEntity)) break block6;
                    character = (LivingEntity)entity;
                    boolean bl = hasRemainingTime = character.isSprinting() || character.isCrouching() || character.isFallFlying() || character.isVisuallySwimming() || !(character instanceof Player);
                    if (!((Boolean)LegacyOptions.animatedCharacter.get()).booleanValue()) break block7;
                    if (hasRemainingTime) break block8;
                    if (!(character instanceof Player)) break block7;
                    Player p = (Player)character;
                    if (!p.getAbilities().flying) break block7;
                }
                if (!character.isSleeping()) {
                    ScreenUtil.updateAnimatedCharacterTime(450L);
                }
            }
            if (Util.getMillis() - animatedCharacterTime <= remainingAnimatedCharacterTime) {
                float xRot = character.getXRot();
                float xRotO = character.xRotO;
                if (!character.isFallFlying()) {
                    character.xRotO = -2.5f;
                    character.setXRot(-2.5f);
                }
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(32.0f, character.isFallFlying() ? 44.0f : 18.0f, -200.0f);
                ScreenUtil.applyHUDScale(guiGraphics);
                float f = (Boolean)LegacyOptions.smoothAnimatedCharacter.get() != false ? FactoryAPIClient.getPartialTick() : 0.0f;
                ClientEntityAccessor.of((Entity)character).setAllowDisplayFireAnimation(false);
                ScreenUtil.renderEntity(guiGraphics, 10.0f, character.isFallFlying() ? -character.getViewXRot(f) / 180.0f * 40.0f : 36.0f, 12, f, new Vector3f(), new Quaternionf().rotationXYZ(-0.08726647f, (165.0f - Mth.lerp((float)f, (float)character.yBodyRotO, (float)character.yBodyRot)) * (float)Math.PI / 180.0f, (float)Math.PI), null, (Entity)character);
                ClientEntityAccessor.of((Entity)character).setAllowDisplayFireAnimation(true);
                guiGraphics.pose().popPose();
                character.setXRot(xRot);
                character.xRotO = xRotO;
            }
        }
    }

    public static void renderContainerEffects(GuiGraphics guiGraphics, int leftPos, int topPos, int imageWidth, int imageHeight, int mouseX, int mouseY) {
        int x = leftPos + imageWidth + 3;
        int l = guiGraphics.guiWidth() - x;
        Collection collection = ScreenUtil.mc.player.getActiveEffects();
        if (collection.isEmpty() || l < 32) {
            return;
        }
        boolean bl = l >= 129;
        int m = 31;
        if (imageHeight < collection.size() * 28) {
            m = imageHeight / collection.size();
        }
        List iterable = Ordering.natural().sortedCopy((Iterable)collection);
        int y = topPos + imageHeight - 28;
        for (MobEffectInstance mobEffectInstance : iterable) {
            ScreenUtil.renderPointerPanel(guiGraphics, x, y, bl ? 129 : 28, 28);
            if (bl) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(x + 25), (float)(y + 7), 0.0f);
                Legacy4JClient.applyFontOverrideIf(ScreenUtil.is720p(), LegacyIconHolder.MOJANGLES_11_FONT, b -> {
                    Component effect = ScreenUtil.getEffectName(mobEffectInstance);
                    if (!b.booleanValue()) {
                        guiGraphics.pose().scale(0.6666667f, 0.6666667f, 0.6666667f);
                    }
                    guiGraphics.drawString(ScreenUtil.mc.font, effect, 0, 0, 0xFFFFFF);
                    guiGraphics.pose().translate(0.0f, 10.0f * (b != false ? 1.0f : 1.5f), 0.0f);
                    guiGraphics.drawString(ScreenUtil.mc.font, MobEffectUtil.formatDuration((MobEffectInstance)mobEffectInstance, (float)1.0f, (float)ScreenUtil.mc.level.tickRateManager().tickrate()), 0, 0, 0x7F7F7F);
                });
                guiGraphics.pose().popPose();
            }
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(x + (bl ? 3 : 5), y + 5, 0, 18, 18, mc.getMobEffectTextures().get(mobEffectInstance.getEffect()));
            y -= m;
        }
        if (!bl && mouseX >= x && mouseX <= x + 28) {
            MobEffectInstance mobEffectInstance;
            int n = topPos + imageHeight - 28;
            mobEffectInstance = null;
            for (MobEffectInstance mobEffectInstance2 : iterable) {
                if (mouseY >= n && mouseY <= n + m) {
                    mobEffectInstance = mobEffectInstance2;
                }
                n -= m;
            }
            if (mobEffectInstance != null) {
                List<Component> list = List.of(ScreenUtil.getEffectName(mobEffectInstance), MobEffectUtil.formatDuration((MobEffectInstance)mobEffectInstance, (float)1.0f, (float)ScreenUtil.mc.level.tickRateManager().tickrate()));
                guiGraphics.renderTooltip(ScreenUtil.mc.font, list, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    public static Component getEffectName(MobEffectInstance mobEffectInstance) {
        MutableComponent mutableComponent = ((MobEffect)mobEffectInstance.getEffect().value()).getDisplayName().copy();
        if (mobEffectInstance.getAmplifier() >= 1 && mobEffectInstance.getAmplifier() <= 9) {
            MutableComponent var10000 = mutableComponent.append(CommonComponents.SPACE);
            int var10001 = mobEffectInstance.getAmplifier();
            var10000.append((Component)Component.translatable((String)("enchantment.level." + (var10001 + 1))));
        }
        return mutableComponent;
    }

    public static List<Component> getTooltip(ItemStack stack) {
        return stack.getTooltipLines(Item.TooltipContext.of((Level)ScreenUtil.mc.level), (Player)ScreenUtil.mc.player, (TooltipFlag)((Boolean)LegacyOptions.advancedHeldItemTooltip.get() != false ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
    }

    public static void renderHUDTooltip(GuiGraphics guiGraphics, int shift) {
        if (!FactoryGuiElement.SELECTED_ITEM_NAME.isVisible(FactoryScreenUtil.getGuiAccessor()) || ScreenUtil.getSelectedItemTooltipLines() == 0) {
            return;
        }
        ScreenUtil.prepareHUDRender(guiGraphics);
        guiGraphics.pose().translate(0.0f, (float)guiGraphics.guiHeight() - Math.max((float)shift, ScreenUtil.getHUDSize()), 0.0f);
        FactoryAPIClient.getProfiler().push("selectedItemName");
        if (GuiAccessor.getInstance().getToolHighlightTimer() > 0 && !GuiAccessor.getInstance().getLastToolHighlight().isEmpty()) {
            Font font = Objects.requireNonNullElse(IClientItemExtensions.of((ItemStack)GuiAccessor.getInstance().getLastToolHighlight()).getFont(GuiAccessor.getInstance().getLastToolHighlight(), IClientItemExtensions.FontContext.SELECTED_ITEM_NAME), ScreenUtil.mc.font);
            List<Component> tooltip = ScreenUtil.getTooltip(GuiAccessor.getInstance().getLastToolHighlight());
            tooltip.removeIf(c -> c.getString().isBlank());
            Object2IntMap tooltipLines = (Object2IntMap)tooltip.stream().limit(ScreenUtil.getSelectedItemTooltipLines()).map(c -> tooltip.indexOf(c) == ScreenUtil.getSelectedItemTooltipLines() - 1 && (Boolean)LegacyOptions.itemTooltipEllipsis.get() != false ? ControlTooltip.MORE : c).collect(Collectors.toMap(Function.identity(), arg_0 -> ((Font)font).width(arg_0), (a, b) -> b, Object2IntLinkedOpenHashMap::new));
            int l = Math.min((int)((float)GuiAccessor.getInstance().getToolHighlightTimer() * 256.0f / 10.0f), 255);
            if (l > 0) {
                int height = (Integer)LegacyOptions.selectedItemTooltipSpacing.get() * (tooltipLines.size() - 1);
                guiGraphics.pose().translate(0.0f, (float)(-height), 0.0f);
                if (!((Boolean)ScreenUtil.mc.options.backgroundForChatOnly().get()).booleanValue()) {
                    int backgroundWidth = tooltipLines.values().intStream().max().orElse(0) + 4;
                    int backgroundX = (guiGraphics.guiWidth() - backgroundWidth) / 2;
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, (float)l / 255.0f);
                    ScreenUtil.renderPointerPanel(guiGraphics, backgroundX, -4, backgroundWidth, height + 15);
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearColor();
                }
                tooltipLines.forEach((mutableComponent, width) -> {
                    int x = (guiGraphics.guiWidth() - width) / 2;
                    guiGraphics.drawString(font, mutableComponent, x, 0, 0xFFFFFF + (l << 24));
                    guiGraphics.pose().translate(0.0f, (float)((Integer)LegacyOptions.selectedItemTooltipSpacing.get()).intValue(), 0.0f);
                });
            }
        }
        FactoryAPIClient.getProfiler().pop();
        ScreenUtil.finalizeHUDRender(guiGraphics);
    }

    public static void renderGuiEffects(GuiGraphics guiGraphics) {
        Collection collection = ScreenUtil.mc.player.getActiveEffects();
        if (!FactoryGuiElement.EFFECTS.isVisible(FactoryScreenUtil.getGuiAccessor()) || collection.isEmpty()) {
            return;
        }
        int i = 0;
        int j = 0;
        float backAlpha = ScreenUtil.getHUDOpacity();
        MobEffectTextureManager mobEffectTextureManager = mc.getMobEffectTextures();
        for (MobEffectInstance mobEffectInstance : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
            Holder mobEffect = mobEffectInstance.getEffect();
            if (!mobEffectInstance.showIcon()) continue;
            int k = guiGraphics.guiWidth() - 55;
            int l = 18;
            if (mc.isDemo()) {
                l += 15;
            }
            if (((MobEffect)mobEffect.value()).isBeneficial()) {
                k -= 24 * ++i;
            } else {
                k -= 24 * ++j;
                l += 24;
            }
            float f = 1.0f;
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, backAlpha);
            ScreenUtil.renderPointerPanel(guiGraphics, k, l, 24, 24);
            if (mobEffectInstance.endsWithin(200)) {
                int m = mobEffectInstance.getDuration();
                f = Mth.clamp((float)((float)m / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.cos((float)((float)m * (float)Math.PI / 5.0f)) * Mth.clamp((float)((float)(10 - m / 20) / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
            }
            FactoryScreenUtil.enableBlend();
            TextureAtlasSprite textureAtlasSprite = mobEffectTextureManager.get(mobEffect);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, f * backAlpha);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(k + 3, l + 3, 0, 18, 18, textureAtlasSprite);
            FactoryScreenUtil.disableBlend();
        }
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderTopText(GuiGraphics guiGraphics, TopMessage topMessage, int y, float scale, int ticks) {
        if (topMessage != null && ticks < topMessage.ticksOnScreen()) {
            FactoryScreenUtil.disableDepthTest();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)guiGraphics.guiWidth() / 2.0f, (float)y, 0.0f);
            guiGraphics.pose().scale(scale, scale, scale);
            if (topMessage.pulse()) {
                float pulse = (float)Util.getMillis() / 400.0f % 1.0f;
                pulse = 1.0f + (pulse > 0.5f ? 1.0f - pulse : pulse) / 10.0f;
                guiGraphics.pose().scale(pulse, pulse, pulse);
            }
            guiGraphics.pose().translate((float)(-ScreenUtil.mc.font.width((FormattedText)topMessage.message())) / 2.0f, 0.0f, 0.0f);
            float maxFade = Math.min(topMessage.ticksOnScreen(), 20);
            float fade = topMessage.fade() ? Math.min(1.0f, ((float)topMessage.ticksOnScreen() - ((float)ticks + FactoryAPIClient.getPartialTick())) / maxFade) : 1.0f;
            guiGraphics.drawString(ScreenUtil.mc.font, topMessage.message(), 0, 0, fade < 1.0f ? ColorUtil.withAlpha((int)topMessage.baseColor(), (float)fade) : topMessage.baseColor(), topMessage.shadow());
            guiGraphics.pose().popPose();
            FactoryScreenUtil.enableDepthTest();
        }
    }

    public static float getFlyingViewRollingRotation(float original) {
        if (((Boolean)LegacyOptions.flyingViewRolling.get()).booleanValue() && ScreenUtil.mc.player != null && ScreenUtil.mc.player.isFallFlying()) {
            float f = FactoryAPIClient.getGamePartialTick((boolean)false);
            Vec3 vec3 = ScreenUtil.mc.player.getViewVector(f);
            Vec3 vec32 = ScreenUtil.mc.player.getDeltaMovementLerped(f);
            double d = vec32.horizontalDistanceSqr();
            double e = vec3.horizontalDistanceSqr();
            if (d > 0.0 && e > 0.0) {
                int dir = (int)(-Math.signum(vec32.x * vec3.z - vec32.z * vec3.x));
                float z = (float)Math.min(0.39269908169872414, Math.acos((vec32.x * vec3.x + vec32.z * vec3.z) / Math.sqrt(d * e)) / 2.5);
                if (z > 0.0f) {
                    return (float)dir * z;
                }
            }
        }
        return original;
    }

    public static void renderGameOverlay(GuiGraphics graphics) {
        PostChain gammaEffect;
        if (!MinecraftAccessor.getInstance().hasGameLoaded()) {
            return;
        }
        float partialTick = FactoryAPIClient.getPartialTick();
        boolean canRenderElement = ScreenUtil.mc.screen != null || !ScreenUtil.mc.options.hideGui;
        LegacyTip tip = LegacyTipManager.getActualTip();
        if ((!LegacyTipManager.tips.isEmpty() || tip != null) && canRenderElement) {
            if (tip == null) {
                tip = LegacyTipManager.updateTip();
            }
            tip.setX(graphics.guiWidth() - tip.getWidth() - 30);
            tip.render(graphics, 0, 0, partialTick);
            if (tip.visibility == Toast.Visibility.HIDE) {
                LegacyTipManager.updateTip();
            }
        }
        if (((Boolean)ScreenUtil.mc.options.showAutosaveIndicator().get()).booleanValue() && canRenderElement && (ScreenUtil.mc.gui.autosaveIndicatorValue > 0.0f || ScreenUtil.mc.gui.lastAutosaveIndicatorValue > 0.0f) && (double)Mth.clamp((float)Mth.lerp((float)FactoryAPIClient.getPartialTick(), (float)ScreenUtil.mc.gui.lastAutosaveIndicatorValue, (float)ScreenUtil.mc.gui.autosaveIndicatorValue), (float)0.0f, (float)1.0f) > 0.02) {
            FactoryScreenUtil.disableDepthTest();
            ScreenUtil.drawAutoSavingIcon(graphics, graphics.guiWidth() - 66, 44);
            FactoryScreenUtil.enableDepthTest();
        }
        if (GLFW.glfwGetInputMode((long)mc.getWindow().getWindow(), (int)208897) == 212994 && !Legacy4JClient.controllerManager.isCursorDisabled && !LegacyOptions.hasSystemCursor()) {
            FactoryScreenUtil.disableDepthTest();
            FactoryScreenUtil.enableBlend();
            graphics.pose().pushPose();
            graphics.pose().translate(Legacy4JClient.controllerManager.getPointerX() + (double)LegacyTipManager.getTipXDiff(), Legacy4JClient.controllerManager.getPointerY(), 4000.0);
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(mc.getWindow().getScreenWidth() >= 1920 ? LegacySprites.POINTER : LegacySprites.SMALL_POINTER, -8, -8, 16, 16);
            graphics.pose().popPose();
            FactoryScreenUtil.disableBlend();
            FactoryScreenUtil.enableDepthTest();
        }
        if ((gammaEffect = Legacy4JClient.getGammaEffect()) != null && ((Boolean)LegacyOptions.displayLegacyGamma.get()).booleanValue()) {
            float gamma = ((Double)LegacyOptions.legacyGamma.get()).floatValue();
            graphics.flush();
            FactoryScreenUtil.enableBlend();
            FactoryScreenUtil.disableDepthTest();
            float tweakedGamma = gamma >= 0.5f ? (gamma - 0.5f) * 1.12f + 1.08f : gamma * 0.96f + 0.6f;
            gammaEffect.passes.forEach(p -> p.getShader().safeGetUniform("gamma").set(tweakedGamma));
            gammaEffect.process(mc.getMainRenderTarget(), (GraphicsResourceAllocator)ScreenUtil.mc.gameRenderer.resourcePool);
            FactoryScreenUtil.enableDepthTest();
            FactoryScreenUtil.disableBlend();
        }
    }

    public static Screen getInitialScreen() {
        TitleScreen titleScreen = new TitleScreen(((Boolean)LegacyOptions.titleScreenFade.get()).booleanValue());
        if (((Boolean)LegacyOptions.skipInitialSaveWarning.get()).booleanValue()) {
            return titleScreen;
        }
        return ConfirmationScreen.createSaveInfoScreen((Screen)titleScreen);
    }

    static {
        lastHotbarSelection = -1;
        lastGui = -1L;
        logoRenderer = new LogoRenderer(false);
        panoramaRenderer = LegacyScreen.PANORAMA_RENDERER;
        iconHolderRenderer = new LegacyIconHolder();
        MINECRAFT = Legacy4J.createModLocation("textures/gui/title/minecraft.png");
        PANORAMA_DAY = Legacy4J.createModLocation("textures/gui/title/panorama_day.png");
        PANORAMA_NIGHT = Legacy4J.createModLocation("textures/gui/title/panorama_night.png");
        MENU_BACKGROUND = Legacy4J.createModLocation("textures/gui/menu_background.png");
        LOADING_BACKGROUND = Legacy4J.createModLocation("textures/gui/loading_background.png");
        actualPlayerTabWidth = Bearer.of((Object)0);
        actualPlayerTabHeight = Bearer.of((Object)0);
    }
}

