/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import wily.factoryapi.FactoryAPIClient;
import wily.legacy.client.ClientEntityAccessor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.util.client.LegacyRenderUtil;

public class AnimatedCharacterRenderer {
    public static long time;
    public static long remainingTime;

    public static void render(GuiGraphics guiGraphics) {
        block7: {
            LivingEntity character;
            block9: {
                block8: {
                    boolean hasRemainingTime;
                    if (!((Boolean)LegacyOptions.animatedCharacter.get()).booleanValue()) {
                        return;
                    }
                    Entity entity = Minecraft.getInstance().getCameraEntity();
                    if (!(entity instanceof LivingEntity)) break block7;
                    character = (LivingEntity)entity;
                    boolean bl = hasRemainingTime = character.isSprinting() || character.isCrouching() || character.isFallFlying() || character.isVisuallySwimming() || !(character instanceof Player);
                    if (hasRemainingTime) break block8;
                    if (!(character instanceof Player)) break block9;
                    Player p = (Player)character;
                    if (!p.getAbilities().flying) break block9;
                }
                if (!character.isSleeping()) {
                    AnimatedCharacterRenderer.updateTime(450L);
                }
            }
            if (Util.getMillis() - time <= remainingTime) {
                float scale = LegacyRenderUtil.getTweakedHUDScale();
                float xRot = character.getXRot();
                float xRotO = character.xRotO;
                if (!character.isFallFlying()) {
                    character.xRotO = -2.5f;
                    character.setXRot(-2.5f);
                }
                guiGraphics.pose().pushMatrix();
                float hudDistance = Math.max(0.0f, ((Double)LegacyOptions.hudDistance.get()).floatValue() - 0.5f) * 2.0f;
                float hudDiff = 1.0f - hudDistance;
                guiGraphics.pose().translate(32.0f * hudDistance, character.isFallFlying() ? 44.0f - hudDiff * 34.0f : 18.0f - hudDiff * 8.0f);
                float f = (Boolean)LegacyOptions.smoothAnimatedCharacter.get() != false ? FactoryAPIClient.getPartialTick() : 0.0f;
                ClientEntityAccessor.of((Entity)character).setAllowDisplayFireAnimation(false);
                guiGraphics.pose().translate(10.0f * scale, (character.isFallFlying() ? -character.getViewXRot(f) / 180.0f * 40.0f : 36.0f) * scale);
                LegacyRenderUtil.renderEntity(guiGraphics, -guiGraphics.guiWidth(), -guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight(), Math.round(12.0f * scale), new Vector3f(), new Quaternionf().rotationXYZ(-0.08726647f, (165.0f - Mth.lerp((float)f, (float)character.yBodyRotO, (float)character.yBodyRot)) * (float)Math.PI / 180.0f, (float)Math.PI), null, (Entity)character);
                ClientEntityAccessor.of((Entity)character).setAllowDisplayFireAnimation(true);
                guiGraphics.pose().popMatrix();
                character.setXRot(xRot);
                character.xRotO = xRotO;
            }
        }
    }

    public static void updateTime(long remainingTime) {
        time = Util.getMillis();
        AnimatedCharacterRenderer.remainingTime = remainingTime;
    }
}

