/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.LegacyBiomeOverride;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.WorldMoreOptionsScreen;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;

public class LegacyBuffetWorldScreen
extends PanelVListScreen {
    private final Consumer<Holder<Biome>> applySettings;
    protected Holder<Biome> selectedBiome;

    public LegacyBuffetWorldScreen(CreateWorldScreen screen, HolderLookup.RegistryLookup<Biome> biomeGetter, Consumer<Holder<Biome>> consumer) {
        super((Screen)screen, (Screen s) -> Panel.centered(s, () -> 282, () -> Math.min(248, s.height)), (Component)Component.translatable((String)"createWorld.customize.buffet.title"));
        Object object;
        Screen screen2 = Minecraft.getInstance().screen;
        if (screen2 instanceof WorldMoreOptionsScreen) {
            WorldMoreOptionsScreen s2 = (WorldMoreOptionsScreen)screen2;
            object = s2;
        } else {
            object = screen;
        }
        this.parent = object;
        this.renderableVList.layoutSpacing(l -> 0);
        this.applySettings = consumer;
        biomeGetter.listElements().forEach(this::addBiome);
    }

    public void addBiome(final Holder.Reference<Biome> biome) {
        this.renderableVList.addRenderable((Renderable)new AbstractButton(0, 0, 260, 30, (Component)Component.translatable((String)("biome." + biome.key().location().toLanguageKey()))){

            public void onPress(InputWithModifiers input) {
                LegacyBuffetWorldScreen.this.selectedBiome = biome;
            }

            protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
                super.renderWidget(guiGraphics, i, j, f);
                ItemStack s = LegacyBiomeOverride.getOrDefault(biome.unwrapKey()).icon();
                if (!s.isEmpty()) {
                    guiGraphics.pose().pushMatrix();
                    guiGraphics.pose().translate((float)(this.getX() + 26), (float)(this.getY() + 5));
                    guiGraphics.pose().scale(1.25f, 1.25f);
                    guiGraphics.renderItem(s, 0, 0);
                    guiGraphics.pose().popMatrix();
                }
                FactoryScreenUtil.enableBlend();
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.isHoveredOrFocused() ? LegacySprites.TICKBOX_HOVERED : LegacySprites.TICKBOX, this.getX() + 6, this.getY() + (this.height - 12) / 2, 12, 12);
                if (LegacyBuffetWorldScreen.this.selectedBiome == biome) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.TICK, this.getX() + 6, this.getY() + (this.height - 12) / 2, 14, 12);
                }
                FactoryScreenUtil.disableBlend();
            }

            protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
                int k = this.getX() + 54;
                int l = this.getX() + this.getWidth();
                LegacyRenderUtil.renderScrollingString(guiGraphics, font, this.getMessage(), k, this.getY(), l, this.getY() + this.getHeight(), j, true);
            }

            protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                this.defaultButtonNarrationText(narrationElementOutput);
            }
        });
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.addRenderableOnly((guiGraphics, i, j, f) -> FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 7, this.panel.y + 7, this.panel.width - 14, this.panel.height - 14));
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 11, this.panel.y + 11, 260, this.panel.height - 25);
    }

    @Override
    public void onClose() {
        super.onClose();
        if (this.selectedBiome != null) {
            this.applySettings.accept(this.selectedBiome);
        }
    }
}

