/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public class LegacyIconHolder
extends SimpleLayoutRenderable
implements GuiEventListener,
NarratableEntry,
ControlTooltip.ActionHolder {
    public Vec2 offset = Vec2.ZERO;
    public ResourceLocation iconSprite = null;
    public ArbitrarySupplier<ResourceLocation> iconHolderOverride = null;
    @NotNull
    public ItemStack itemIcon = ItemStack.EMPTY;
    public boolean allowItemDecorations = true;
    public boolean allowFocusedItemTooltip = false;
    public boolean isHovered;
    private boolean isWarning = false;
    private boolean focused = false;

    public LegacyIconHolder() {
    }

    public LegacyIconHolder(int leftPos, int topPos, Slot slot) {
        this.slotBounds(leftPos, topPos, slot);
    }

    public LegacyIconHolder(int x, int y, int width, int height) {
        this(width, height);
        this.setPos(x, y);
    }

    public LegacyIconHolder(int width, int height) {
        this.setBounds(width, height);
    }

    public static LegacyIconHolder fromSlot(final Slot slot) {
        return new LegacyIconHolder(){

            @Override
            public void render(GuiGraphics graphics, int i, int j, float f) {
                this.slotBoundsWithItem(0, 0, slot);
                super.render(graphics, i, j, f);
            }
        };
    }

    public static LegacyIconHolder entityHolder(int x, int y, int width, int height, final EntityType<?> entityType) {
        return new LegacyIconHolder(x, y, width, height){
            Entity entity;

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                super.render(graphics, mouseX, mouseY, delta);
                if (this.entity == null && Minecraft.getInstance().level != null) {
                    this.entity = entityType.create((Level)Minecraft.getInstance().level, EntitySpawnReason.EVENT);
                }
                if (this.entity != null) {
                    this.renderEntity(graphics, this.entity, mouseX, mouseY, delta);
                }
            }
        };
    }

    public void setBounds(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setPos(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public LegacyIconHolder slotBoundsWithItem(int leftPos, int topPos, Slot slot) {
        return this.slotBounds(leftPos, topPos, slot, slot.getItem());
    }

    public LegacyIconHolder slotBounds(Slot slot) {
        return this.slotBounds(0, 0, slot);
    }

    public LegacyIconHolder slotBounds(int leftPos, int topPos, Slot slot) {
        return this.slotBounds(leftPos, topPos, slot, ItemStack.EMPTY);
    }

    public LegacyIconHolder slotBounds(int leftPos, int topPos, Slot slot, ItemStack stack) {
        return this.itemHolder(leftPos + slot.x, topPos + slot.y, LegacySlotDisplay.of(slot).getWidth(), LegacySlotDisplay.of(slot).getHeight(), stack, LegacySlotDisplay.of(slot).isWarning(), LegacySlotDisplay.of(slot).getIconSprite(), LegacySlotDisplay.of(slot).getOffset(), LegacySlotDisplay.of(slot).getIconHolderOverride());
    }

    public LegacyIconHolder itemHolder(ItemStack itemIcon, boolean isWarning) {
        return this.itemHolder(itemIcon, isWarning, Vec2.ZERO);
    }

    public LegacyIconHolder itemHolder(ItemStack itemIcon, boolean isWarning, Vec2 offset) {
        return this.itemHolder(0, 0, 21, 21, itemIcon, isWarning, offset);
    }

    public LegacyIconHolder itemHolder(int x, int y, int width, int height, ItemStack itemIcon, boolean isWarning, Vec2 offset) {
        return this.itemHolder(x, y, width, height, itemIcon, isWarning, null, offset, null);
    }

    public LegacyIconHolder itemHolder(int x, int y, int width, int height, ItemStack itemIcon, boolean isWarning, ResourceLocation iconSprite, Vec2 offset, ArbitrarySupplier<ResourceLocation> override) {
        this.setPos(x, y);
        this.setBounds(width, height);
        this.iconSprite = iconSprite;
        this.iconHolderOverride = override;
        this.itemIcon = itemIcon;
        this.isWarning = isWarning;
        this.allowItemDecorations = true;
        this.offset = offset;
        return this;
    }

    public double getMiddleX() {
        return this.getXCorner() + this.offset.x + (float)this.getWidth() / 2.0f;
    }

    public double getMiddleY() {
        return this.getYCorner() + this.offset.y + (float)this.getHeight() / 2.0f;
    }

    public float getXCorner() {
        return (float)this.getX() - (this.isSizeable() ? 1.0f : (float)this.getWidth() / 20.0f);
    }

    public float getYCorner() {
        return (float)this.getY() - (this.isSizeable() ? 1.0f : (float)this.getHeight() / 20.0f);
    }

    public float getSelectableWidth() {
        return (float)this.getWidth() - 2.0f * (this.isSizeable() ? 1.0f : (float)this.getWidth() / 20.0f);
    }

    public float getSelectableHeight() {
        return (float)this.getHeight() - 2.0f * (this.isSizeable() ? 1.0f : (float)this.getHeight() / 20.0f);
    }

    public float getScaleX() {
        return (float)this.getWidth() / 18.0f;
    }

    public float getScaleY() {
        return (float)this.getHeight() / 18.0f;
    }

    public boolean isSizeable() {
        return Math.min(this.getWidth(), this.getHeight()) < 18 && LegacyOptions.getUIMode().isHD();
    }

    public boolean canSizeIcon() {
        return this.getMinSize() < 18 || this.getMinSize() > 21;
    }

    public void applyOffset(GuiGraphics graphics) {
        if (!this.offset.equals(Vec2.ZERO)) {
            graphics.pose().translate(this.offset.x, this.offset.y);
        }
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public void setWarning(boolean warning) {
        this.isWarning = warning;
    }

    public ResourceLocation getIconHolderSprite() {
        return this.iconHolderOverride == null ? (this.isWarning() ? LegacySprites.RED_ICON_HOLDER : (this.isSizeable() ? LegacySprites.SIZEABLE_ICON_HOLDER : LegacySprites.ICON_HOLDER)) : (ResourceLocation)this.iconHolderOverride.get();
    }

    public void render(GuiGraphics graphics, int i, int j, float f) {
        this.isHovered = this.isHovered(i, j);
        ResourceLocation sprite = this.getIconHolderSprite();
        if (sprite != null) {
            this.renderChild(graphics, this.getXCorner(), this.getYCorner(), () -> FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(sprite, 0, 0, this.getWidth(), this.getHeight()));
        }
        if (this.iconSprite != null) {
            this.renderIcon(this.iconSprite, graphics, this.canSizeIcon(), 16, 16);
        }
        this.renderItem(graphics, i, j, f);
    }

    public void renderIcon(ResourceLocation location, GuiGraphics graphics, boolean scaled, int width, int height) {
        this.renderChild(graphics, this.getX(), this.getY(), () -> {
            if (scaled) {
                graphics.pose().scale(this.getSelectableWidth() / (float)width, this.getSelectableHeight() / (float)height);
            } else {
                graphics.pose().translate((this.getSelectableWidth() - (float)width) / 2.0f, (this.getSelectableHeight() - (float)height) / 2.0f);
            }
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(location, 0, 0, width, height);
        });
    }

    public void renderItem(GuiGraphics graphics, int i, int j, float f) {
        this.renderItem(graphics, this.itemIcon, this.getX(), this.getY(), this.isWarning());
    }

    public void renderItem(GuiGraphics graphics, ItemStack item, int x, int y, boolean isWarning) {
        if (!item.isEmpty()) {
            this.renderItem(graphics, () -> {
                graphics.renderFakeItem(item, 0, 0);
                if (this.allowItemDecorations) {
                    graphics.renderItemDecorations(Minecraft.getInstance().font, item, 0, 0);
                }
            }, x, y, isWarning);
        }
    }

    public void renderItem(GuiGraphics graphics, Runnable itemRender, int x, int y, boolean isWarning) {
        this.renderScaled(graphics, x, y, itemRender);
        if (isWarning) {
            this.renderWarning(graphics);
        }
    }

    public void renderWarning(GuiGraphics graphics) {
        this.renderChild(graphics, this.x, this.y, () -> FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.WARNING_ICON, 0, 0, 8, 8));
    }

    public void renderEntity(GuiGraphics graphics, Entity entity, int mouseX, int mouseY, float deltaTime) {
        entity.setYRot(180.0f);
        entity.yRotO = entity.getYRot();
        entity.xRotO = 0.0f;
        entity.setXRot(0.0f);
        if (entity instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            e.yBodyRot = 180.0f;
            e.yBodyRotO = 180.0f;
            e.yHeadRotO = e.yHeadRot = 180.0f;
        }
        LegacyRenderUtil.renderEntity(graphics, this.getX(), this.getY(), this.getX() + Math.round(this.getSelectableWidth()), this.getY() + Math.round(this.getSelectableHeight() * 2.0f), (int)Math.min(this.getSelectableWidth(), this.getSelectableHeight()), new Vector3f(), new Quaternionf().rotationXYZ(0.0f, 0.7853982f, (float)Math.PI), null, entity, true);
    }

    public void renderSelection(GuiGraphics graphics, int i, int j, float f) {
        if (LegacyOptions.getUIMode().isSD() && this.getMinSize() == 20) {
            this.renderChild(graphics, this.getXCorner() - (21.0f - (float)this.getWidth()) / 2.0f, this.getYCorner() - (21.0f - (float)this.getHeight()) / 2.0f, () -> FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SELECT_ICON_HIGHLIGHT_SMALL, 0, 0, 21, 21));
        } else {
            this.renderChild(graphics, this.getXCorner() + ((float)this.getWidth() - 36.0f) / 2.0f, this.getYCorner() + ((float)this.getHeight() - 36.0f) / 2.0f, () -> FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SELECT_ICON_HIGHLIGHT, 0, 0, 36, 36));
        }
    }

    public void renderScroll(GuiGraphics graphics, LegacyScrollRenderer scrollRenderer) {
        if (LegacyOptions.getUIMode().isSD() && this.getMinSize() == 20) {
            this.renderChild(graphics, this.getXCorner() + (float)(this.getWidth() - 7) / 2.0f, this.getYCorner() - 0.5f, () -> {
                scrollRenderer.renderSmallScroll(graphics, true, 0, -5);
                scrollRenderer.renderSmallScroll(graphics, false, 0, this.getHeight() + 2);
            });
        } else {
            this.renderChild(graphics, this.getXCorner() + (float)(this.getWidth() - 13) / 2.0f, this.getYCorner(), () -> {
                scrollRenderer.renderScroll(graphics, ScreenDirection.UP, -1, -12);
                scrollRenderer.renderScroll(graphics, ScreenDirection.DOWN, -1, this.getHeight() + 5);
            });
        }
    }

    public void renderScaled(GuiGraphics graphics, float x, float y, Runnable render) {
        this.renderChild(graphics, x, y, () -> {
            graphics.pose().scale((float)this.getWidth() / 18.0f, (float)this.getHeight() / 18.0f);
            render.run();
        });
    }

    public void renderChild(GuiGraphics graphics, float x, float y, Runnable render) {
        graphics.pose().pushMatrix();
        graphics.pose().translate(x, y);
        this.applyOffset(graphics);
        render.run();
        graphics.pose().popMatrix();
    }

    public void renderHighlight(GuiGraphics graphics) {
        this.renderChild(graphics, this.x, this.y, () -> {
            graphics.pose().scale(this.getSelectableWidth() / 16.0f, this.getSelectableHeight() / 16.0f);
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SLOT_HIGHLIGHT, 0, 0, 16, 16);
        });
    }

    public void renderTooltip(Minecraft minecraft, GuiGraphics graphics, int i, int j) {
        if (this.isHovered || this.allowFocusedItemTooltip && this.isFocused()) {
            this.renderTooltip(minecraft, graphics, this.itemIcon, !this.isHovered ? (int)this.getMiddleX() : i, !this.isHovered ? (int)this.getMiddleY() : j);
        }
    }

    public void renderTooltip(Minecraft minecraft, GuiGraphics graphics, ItemStack stack, int i, int j) {
        if (!stack.isEmpty()) {
            LegacyFontUtil.applySmallerFont(LegacyFontUtil.MOJANGLES_11_FONT, b -> graphics.setTooltipForNextFrame(minecraft.font, stack, i, j));
        }
    }

    public boolean isHovered(double mouseX, double mouseY) {
        return LegacyRenderUtil.isMouseOver(mouseX, mouseY, this.getXCorner(), this.getYCorner(), this.width, this.height);
    }

    public boolean isHoveredOrFocused() {
        return this.isHovered || this.isFocused();
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isSelection()) {
            this.onPress((InputWithModifiers)keyEvent);
        }
        return false;
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        if (this.isMouseOver(mouseButtonEvent.x(), mouseButtonEvent.y()) && mouseButtonEvent.button() == 0) {
            this.onClick(mouseButtonEvent, bl);
            return !this.isFocused();
        }
        return false;
    }

    public void playClickSound() {
        if (!this.isFocused()) {
            LegacySoundUtil.playSimpleUISound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f);
        }
    }

    public void onClick(MouseButtonEvent event, boolean bl) {
        this.playClickSound();
        this.onPress((InputWithModifiers)event);
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        if (this.isFocused()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        if (this.isHovered) {
            return NarratableEntry.NarrationPriority.HOVERED;
        }
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
        return !this.isFocused() ? ComponentPath.leaf((GuiEventListener)this) : null;
    }

    public ScreenRectangle getRectangle() {
        return new ScreenRectangle((int)(this.offset.x + this.getXCorner()), (int)(this.offset.y + this.getYCorner()), this.getWidth(), this.getHeight());
    }

    public int getMinSize() {
        return Math.min(this.getWidth(), this.getHeight());
    }

    @Override
    @Nullable
    public Component getAction(ControlTooltip.ActionHolder.Context context) {
        return ControlTooltip.getSelectAction(this, context);
    }
}

