/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.util.FactoryItemUtil;
import wily.legacy.network.ServerMenuCraftPayload;

public interface RecipeMenu {
    public static void handleCompactInventoryList(Collection<ItemStack> compactList, Inventory inventory, ItemStack carriedItem) {
        RecipeMenu.handleCompactItemStackList(compactList, (Iterable<ItemStack>)inventory.getNonEquipmentItems());
        if (!carriedItem.isEmpty()) {
            RecipeMenu.handleCompactItemStackListAdd(compactList, carriedItem);
        }
    }

    public static void handleCompactItemStackList(Collection<ItemStack> compactList, Iterable<ItemStack> items) {
        for (ItemStack item : items) {
            if (item.isEmpty()) continue;
            RecipeMenu.handleCompactItemStackListAdd(compactList, item);
        }
    }

    public static void handleCompactItemStackListAdd(Collection<ItemStack> compactList, ItemStack item) {
        for (ItemStack itemStack : compactList) {
            if (!FactoryItemUtil.equalItems((ItemStack)itemStack, (ItemStack)item)) continue;
            itemStack.grow(item.getCount());
            return;
        }
        compactList.add(item.copy());
    }

    public static boolean canCraft(List<Optional<Ingredient>> ingredients, Inventory inventory, ItemStack carriedItem) {
        boolean canCraft = true;
        ArrayList<ItemStack> compactList = new ArrayList<ItemStack>();
        RecipeMenu.handleCompactInventoryList(compactList, inventory, carriedItem);
        block0: for (Optional<Ingredient> ing : ingredients) {
            if (ing.isEmpty()) continue;
            for (int i = 0; i < FactoryIngredient.of((Ingredient)ing.get()).getCount(); ++i) {
                ItemStack itemStack2;
                block3: {
                    for (ItemStack itemStack2 : compactList) {
                        if (itemStack2.isEmpty() || !ing.get().test(itemStack2.copyWithCount(1))) continue;
                        break block3;
                    }
                    canCraft = false;
                    break block0;
                }
                itemStack2.shrink(1);
            }
        }
        return canCraft;
    }

    default public boolean canCraft(List<Optional<Ingredient>> ingredients, Player player, ServerMenuCraftPayload packet) {
        return RecipeMenu.canCraft(ingredients, player.getInventory(), player.containerMenu.getCarried());
    }

    default public List<ItemStack> getRemainingItems(Player player, ServerMenuCraftPayload packet) {
        return Collections.emptyList();
    }

    default public void tryCraft(Player player, ServerMenuCraftPayload packet) {
        int tries = 0;
        List<Optional<Ingredient>> ingredients = this.getIngredients(player, packet);
        if (ingredients.isEmpty()) {
            return;
        }
        while (this.canCraft(ingredients, player, packet) && (packet.max() && tries <= 2304 || tries == 0)) {
            ++tries;
            this.setupActualItems(player, packet, null, -1);
            for (int index = 0; index < ingredients.size(); ++index) {
                Optional<Ingredient> ing = ingredients.get(index);
                if (ing.isEmpty()) continue;
                int count = FactoryIngredient.of((Ingredient)ing.get()).getCount();
                block2: for (int c = 0; c < count; ++c) {
                    ItemStack copy;
                    if (!player.containerMenu.getCarried().isEmpty()) {
                        copy = player.containerMenu.getCarried().copyWithCount(1);
                        if (ing.get().test(copy)) {
                            if (c == count - 1) {
                                this.setupActualItems(player, packet, copy, index);
                            }
                            player.containerMenu.getCarried().shrink(1);
                            continue;
                        }
                    }
                    for (int i = 0; i < player.containerMenu.slots.size(); ++i) {
                        Slot slot = player.containerMenu.getSlot(i);
                        if (slot.container != player.getInventory() || !slot.hasItem()) continue;
                        copy = slot.getItem().copyWithCount(1);
                        if (!ing.get().test(copy)) continue;
                        if (c == count - 1) {
                            this.setupActualItems(player, packet, copy, index);
                        }
                        slot.getItem().shrink(1);
                        continue block2;
                    }
                }
            }
            ItemStack result = this.getResult(player, packet);
            this.onCraft(player, packet, result);
            this.getRemainingItems(player, packet).forEach(arg_0 -> ((Inventory)player.getInventory()).placeItemBackInInventory(arg_0));
            player.getInventory().placeItemBackInInventory(result.copy());
        }
    }

    public void onCraft(Player var1, ServerMenuCraftPayload var2, ItemStack var3);

    public ItemStack getResult(Player var1, ServerMenuCraftPayload var2);

    default public List<Optional<Ingredient>> getIngredients(Player player, ServerMenuCraftPayload packet) {
        return packet.customIngredients();
    }

    default public void setupActualItems(Player player, ServerMenuCraftPayload packet, ItemStack setItem, int index) {
    }
}

