/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.platform.Window;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.AdvancementToastAccessor;
import wily.legacy.client.LegacyMusicFader;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.SoundManagerAccessor;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyAdvancementsScreen;
import wily.legacy.client.screen.OverlayPanelScreen;
import wily.legacy.client.screen.ReplaceableScreen;
import wily.legacy.network.ServerPlayerMissHitPayload;
import wily.legacy.util.client.LegacyGuiElements;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    @Nullable
    public ClientLevel level;
    @Shadow
    public Options options;
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Final
    public Font font;
    @Shadow
    @Nullable
    public Screen screen;
    @Shadow
    @Nullable
    public HitResult hitResult;
    @Shadow
    @Nullable
    public MultiPlayerGameMode gameMode;
    @Shadow
    @Final
    public Gui gui;
    @Unique
    public float realtimeDeltaTickResidual;
    @Unique
    public long lastMillis;
    Vec3 lastPlayerBlockUsePos = null;
    @Unique
    Screen oldScreen;
    private boolean inventoryKeyLastPressed = false;
    private int inventoryKeyHold = 0;
    @Shadow
    private int rightClickDelay;
    @Shadow
    @Final
    private SoundManager soundManager;

    @Shadow
    public abstract void setScreen(@Nullable Screen var1);

    @Shadow
    public abstract Window getWindow();

    @Shadow
    @Nullable
    public abstract ClientPacketListener getConnection();

    @Shadow
    public abstract boolean isPaused();

    private Minecraft self() {
        return (Minecraft)this;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/loading/ImmediateWindowHandler;loadingOverlay(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Ljava/util/function/Consumer;Z)Ljava/util/function/Supplier;", remap=false))
    private Supplier<Overlay> init(Supplier<Minecraft> mc, Supplier<ReloadInstance> ri, Consumer<Optional<Throwable>> ex, boolean fade) {
        return () -> new LoadingOverlay((Minecraft)mc.get(), (ReloadInstance)ri.get(), ex, fade);
    }

    @Inject(method={"handleKeybinds"}, at={@At(value="HEAD")})
    private void handleKeybinds(CallbackInfo ci) {
        if (!this.options.keyUse.isDown()) {
            this.lastPlayerBlockUsePos = null;
        }
    }

    @Inject(method={"startAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;resetAttackStrengthTicker()V")})
    private void startAttack(CallbackInfoReturnable<Boolean> cir) {
        CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerPlayerMissHitPayload());
    }

    @Inject(method={"startUseItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void startUseItem(CallbackInfo ci) {
        if (this.player != null && this.player.isSleeping()) {
            ClientPacketListener clientPacketListener = this.player.connection;
            clientPacketListener.send((Packet)new ServerboundPlayerCommandPacket((Entity)this.player, ServerboundPlayerCommandPacket.Action.STOP_SLEEPING));
            ci.cancel();
        }
        if (this.lastPlayerBlockUsePos != null) {
            if (Math.abs(this.lastPlayerBlockUsePos.x - this.player.position().x) >= 1.0 || Math.abs(this.lastPlayerBlockUsePos.y - this.player.position().y) >= 1.0 || Math.abs(this.lastPlayerBlockUsePos.z - this.player.position().z) >= 1.0) {
                this.lastPlayerBlockUsePos = this.lastPlayerBlockUsePos.subtract(Mth.clamp((double)(this.lastPlayerBlockUsePos.x - this.player.position().x), (double)-1.0, (double)1.0), Mth.clamp((double)(this.lastPlayerBlockUsePos.y - this.player.position().y), (double)-1.0, (double)1.0), Mth.clamp((double)(this.lastPlayerBlockUsePos.z - this.player.position().z), (double)-1.0, (double)1.0));
            } else {
                ci.cancel();
            }
        }
    }

    @Inject(method={"startUseItem"}, at={@At(value="RETURN")})
    private void startUseItemReturn(CallbackInfo ci) {
        if (this.player.getAbilities().flying && this.player.isSprinting()) {
            this.rightClickDelay = -1;
        }
    }

    @Inject(method={"startUseItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;useItemOn(Lnet/minecraft/client/player/LocalPlayer;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;")})
    private void startUseItemCreativeBlockPlacing(CallbackInfo ci, @Local InteractionHand hand, @Local BlockHitResult hit) {
        if (((Boolean)LegacyOptions.legacyCreativeBlockPlacing.get()).booleanValue() && this.rightClickDelay == 4 && this.player.getAbilities().instabuild && ControlTooltip.canPlace(this.self(), this.player.getItemInHand(hand), hand)) {
            if (this.lastPlayerBlockUsePos == null) {
                this.lastPlayerBlockUsePos = this.player.position();
            }
            this.rightClickDelay = 0;
        }
        if (this.level.getBlockState(hit.getBlockPos()).getBlock() instanceof BedBlock || this.player.getAbilities().flying && this.player.isSprinting()) {
            this.rightClickDelay = -1;
        }
    }

    @ModifyExpressionValue(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isSleeping()Z")})
    private boolean tick(boolean original) {
        return false;
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundManager;updateSource(Lnet/minecraft/client/Camera;)V")})
    public void runSoundTick(boolean bl, CallbackInfo ci) {
        float deltaTicks = FactoryAPIClient.getPartialTick();
        this.realtimeDeltaTickResidual += deltaTicks;
        int i = (int)this.realtimeDeltaTickResidual;
        this.realtimeDeltaTickResidual -= (float)i;
        if (Util.getMillis() - this.lastMillis > 50L || i > 0) {
            this.lastMillis = Util.getMillis();
        }
        if (Util.getMillis() - this.lastMillis > 60L && i == 0) {
            i = 1;
        }
        for (int j = 0; j < Math.min(10, i); ++j) {
            this.soundManager.tick(this.isPaused());
            LegacyMusicFader.tick();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundManager;tick(Z)V"))
    private void noSoundTick(SoundManager instance, boolean bl) {
    }

    @WrapWithCondition(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/MusicManager;tick()V")})
    private boolean tickMusicManager(MusicManager instance) {
        return LegacyMusicFader.musicManagerShouldTick;
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;onDisconnected()V")})
    private void disconnectFadeMusic(CallbackInfo ci) {
        SoundManagerAccessor.of(this.soundManager).fadeAllMusic();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Redirect(method={"handleKeybinds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;consumeClick()Z", ordinal=4))
    private boolean handleKeybindsInventoryKey(KeyMapping instance) {
        if (!instance.consumeClick()) {
            if (!this.inventoryKeyLastPressed) return false;
            if (instance.isDown()) return false;
            this.inventoryKeyLastPressed = false;
            if (false) return false;
            return true;
        }
        AdvancementToast toast = (AdvancementToast)FactoryAPIClient.getToasts().getToast(AdvancementToast.class, Toast.NO_TOKEN);
        if (toast == null) {
            return true;
        }
        ++this.inventoryKeyHold;
        this.inventoryKeyLastPressed = this.inventoryKeyHold < 10;
        if (this.inventoryKeyLastPressed) return false;
        FactoryAPIClient.getToasts().clear();
        this.inventoryKeyHold = 0;
        LegacyAdvancementsScreen screen = new LegacyAdvancementsScreen(null);
        this.setScreen(screen);
        screen.focusRenderable(r -> {
            if (!(r instanceof LegacyAdvancementsScreen.AdvancementButton)) return false;
            LegacyAdvancementsScreen.AdvancementButton b = (LegacyAdvancementsScreen.AdvancementButton)((Object)r);
            if (!b.id.equals((Object)AdvancementToastAccessor.of(toast).getAdvancementId())) return false;
            return true;
        }, i -> screen.getTabList().tabButtons.get(i).onPress((InputWithModifiers)new KeyEvent(257, 0, 0)));
        return false;
    }

    @WrapWithCondition(method={"handleKeybinds"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V", ordinal=1)})
    private boolean handleKeybinds(Minecraft instance, Screen screen) {
        if (screen instanceof ReplaceableScreen) {
            ReplaceableScreen s = (ReplaceableScreen)screen;
            s.setCanReplace(false);
        }
        return true;
    }

    @ModifyArg(method={"handleKeybinds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V", ordinal=2))
    private Screen handleKeybinds(Screen arg) {
        return (Boolean)LegacyOptions.legacyAdvancements.get() != false ? new LegacyAdvancementsScreen(null) : arg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WrapWithCondition(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;removed()V")})
    private boolean removedScreen(Screen instance, Screen newScreen) {
        if (!(newScreen instanceof OverlayPanelScreen)) return true;
        OverlayPanelScreen s = (OverlayPanelScreen)newScreen;
        if (s.parent == instance) return false;
        return true;
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;added()V")})
    private void addedScreen(Screen screen, CallbackInfo ci) {
        ControlTooltip.Event.of(screen).setupControlTooltips();
        ((BiConsumer)ControlTooltip.Renderer.SCREEN_EVENT.invoker).accept(screen, ControlTooltip.Event.of(screen).getControlTooltips());
        LegacyTipManager.tipDiffPercentage = 0.0f;
    }

    @WrapWithCondition(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init(Lnet/minecraft/client/Minecraft;II)V")})
    private boolean initScreen(Screen instance, Minecraft minecraft, int i, int j) {
        Screen screen = this.oldScreen;
        if (screen instanceof OverlayPanelScreen) {
            OverlayPanelScreen s = (OverlayPanelScreen)screen;
            if (s.parent == instance) {
                instance.resize(minecraft, i, j);
                return false;
            }
        }
        return true;
    }

    @Inject(method={"resizeDisplay"}, at={@At(value="RETURN")})
    private void resizeDisplay(CallbackInfo ci) {
        LegacyTipManager.rebuildActual();
        LegacyTipManager.rebuildActualLoading();
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    public void setScreen(Screen screen, CallbackInfo ci) {
        this.oldScreen = this.screen;
        Screen replacement = Legacy4JClient.getReplacementScreen(screen);
        if (replacement != screen) {
            ci.cancel();
            this.setScreen(replacement);
            return;
        }
        if (Minecraft.getInstance().screen == null && Minecraft.getInstance().level != null && screen != null && (screen instanceof PauseScreen || !screen.isPauseScreen())) {
            LegacySoundUtil.playSimpleUISound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f);
        }
        if (screen == null && this.level != null) {
            LegacyGuiElements.lastGui = Util.getMillis();
            ControlTooltip.Event.of(this.gui).setupControlTooltips();
            ((BiConsumer)ControlTooltip.Renderer.GUI_EVENT.invoker).accept(this.gui, ControlTooltip.Event.of(this.gui).getControlTooltips());
        }
    }

    @WrapWithCondition(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundManager;pauseAllExcept([Lnet/minecraft/sounds/SoundSource;)V")})
    public boolean pauseGame(SoundManager instance, SoundSource[] soundSources) {
        return false;
    }

    @WrapWithCondition(method={"updateLevelInEngines"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundManager;stop()V")})
    public boolean updateScreenAndTick(SoundManager instance) {
        SoundManagerAccessor.of(instance).stopAllSound();
        return false;
    }

    @ModifyVariable(method={"buildInitialScreens"}, at=@At(value="STORE"))
    private Runnable addInitialScreens(Runnable run) {
        return () -> {
            run.run();
            if (this.screen != null) {
                this.setScreen(LegacyRenderUtil.getInitialScreen());
            }
        };
    }
}

