/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.create_world;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldCallback;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.client.gui.screens.worldselection.WorldOpenFlows;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.OptionsScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PublishScreen;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.WorldMoreOptionsScreen;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

@Mixin(value={CreateWorldScreen.class})
public abstract class CreateWorldScreenMixin
extends Screen
implements ControlTooltip.Event {
    @Shadow
    @Final
    private static Component GAME_MODEL_LABEL;
    @Shadow
    @Final
    private static Component NAME_LABEL;
    protected Bearer<Boolean> trustPlayers = Bearer.of((Object)true);
    protected Panel panel;
    protected PublishScreen publishScreen;
    protected PackAlbum.Selector resourceAlbumSelector;
    @Shadow
    @Final
    private WorldCreationUiState uiState;

    protected CreateWorldScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"createNewWorldDirectory"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelStorageSource;createAccess(Ljava/lang/String;)Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;")})
    private static void createNewWorldDirectory(Minecraft minecraft, String string, @Nullable Path path, CallbackInfoReturnable<Optional<LevelStorageSource.LevelStorageAccess>> cir) {
        if (!((Boolean)LegacyOptions.saveCache.get()).booleanValue()) {
            return;
        }
        try {
            LevelStorageSource.LevelStorageAccess access = LegacySaveCache.currentWorldSource.createAccess(string);
            access.close();
            if (Files.exists(access.getDimensionPath(Level.OVERWORLD), new LinkOption[0])) {
                FileUtils.deleteDirectory((File)access.getDimensionPath(Level.OVERWORLD).toFile());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @ModifyExpressionValue(method={"createNewWorldDirectory"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getLevelSource()Lnet/minecraft/world/level/storage/LevelStorageSource;")})
    private static LevelStorageSource createNewWorldDirectory(LevelStorageSource original) {
        return (Boolean)LegacyOptions.saveCache.get() != false ? LegacySaveCache.currentWorldSource : original;
    }

    @Shadow
    public abstract void popScreen();

    @Shadow
    protected abstract void onCreate();

    private CreateWorldScreen self() {
        return (CreateWorldScreen)this;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void initReturn(Minecraft minecraft, Runnable runnable, WorldCreationContext worldCreationContext, Optional optional, OptionalLong optionalLong, CreateWorldCallback createWorldCallback, CallbackInfo ci) {
        this.uiState.setDifficulty((Difficulty)LegacyOptions.createWorldDifficulty.get());
        this.panel = Panel.createPanel((Screen)this, p -> (this.width - (p.width + (LegacyRenderUtil.hasTooltipBoxes(UIAccessor.of((Screen)this)) ? 160 : 0))) / 2, p -> (this.height - p.height) / 2, 245, 228);
        this.resourceAlbumSelector = PackAlbum.Selector.resources(this.panel.x + 13, this.panel.y + 106, 220, 45, !LegacyRenderUtil.hasTooltipBoxes());
        this.publishScreen = new PublishScreen((Screen)this, this.uiState.getGameMode().gameType);
    }

    public void added() {
        super.added();
        OptionsScreen.setupSelectorControlTooltips(ControlTooltip.Renderer.of(this), this);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        UIAccessor accessor = UIAccessor.of((Screen)this);
        this.panel.init();
        int layoutX = accessor.getInteger("layout.x", this.panel.x + 13);
        int layoutWidth = accessor.getInteger("layout.width", 220);
        this.addRenderableOnly((Renderable)this.panel);
        EditBox nameEdit = new EditBox(this.font, layoutX, this.panel.y + 25, layoutWidth, 20, (Component)Component.translatable((String)"selectWorld.enterName"));
        nameEdit.setValue(this.uiState.getName());
        nameEdit.setResponder(arg_0 -> ((WorldCreationUiState)this.uiState).setName(arg_0));
        this.uiState.addListener(worldCreationUiState -> nameEdit.setTooltip(Tooltip.create((Component)Component.translatable((String)"selectWorld.targetFolder", (Object[])new Object[]{Component.literal((String)worldCreationUiState.getTargetFolder()).withStyle(ChatFormatting.ITALIC)}))));
        this.setInitialFocus((GuiEventListener)nameEdit);
        this.addRenderableWidget((GuiEventListener)((EditBox)accessor.putWidget("nameEditBox", (AbstractWidget)nameEdit)));
        LegacySliderButton gameModeButton = (LegacySliderButton)this.addRenderableWidget((GuiEventListener)((LegacySliderButton)accessor.putWidget("gameTypeSlider", new LegacySliderButton<WorldCreationUiState.SelectedGameMode>(layoutX, this.panel.y + 51, layoutWidth, 16, b -> b.getDefaultMessage(GAME_MODEL_LABEL, ((WorldCreationUiState.SelectedGameMode)b.getObjectValue()).displayName), b -> Tooltip.create((Component)this.uiState.getGameMode().getInfo()), this.uiState.getGameMode(), () -> List.of(WorldCreationUiState.SelectedGameMode.SURVIVAL, WorldCreationUiState.SelectedGameMode.HARDCORE, WorldCreationUiState.SelectedGameMode.CREATIVE), b -> this.uiState.setGameMode((WorldCreationUiState.SelectedGameMode)b.getObjectValue())))));
        this.uiState.addListener(worldCreationUiState -> {
            gameModeButton.active = !worldCreationUiState.isDebug();
        });
        LegacySliderButton difficultyButton = (LegacySliderButton)this.addRenderableWidget((GuiEventListener)((LegacySliderButton)accessor.putWidget("difficultySlider", new LegacySliderButton<Difficulty>(layoutX, this.panel.y + 77, layoutWidth, 16, b -> b.getDefaultMessage((Component)Component.translatable((String)"options.difficulty"), ((Difficulty)b.getObjectValue()).getDisplayName()), b -> Tooltip.create((Component)this.uiState.getDifficulty().getInfo()), this.uiState.getDifficulty(), () -> Arrays.asList(Difficulty.values()), b -> this.uiState.setDifficulty((Difficulty)b.getObjectValue())))));
        this.uiState.addListener(worldCreationUiState -> {
            difficultyButton.setObjectValue(this.uiState.getDifficulty());
            difficultyButton.updateMessage();
            difficultyButton.active = !this.uiState.isHardcore();
        });
        this.addRenderableWidget((GuiEventListener)((Button)accessor.putWidget("moreOptionsButton", (AbstractWidget)Button.builder((Component)Component.translatable((String)"createWorld.tab.more.title"), button -> this.minecraft.setScreen((Screen)new WorldMoreOptionsScreen(this.self(), this.trustPlayers))).bounds(layoutX, this.panel.y + 172, layoutWidth, 20).build())));
        this.addRenderableWidget((GuiEventListener)((Button)accessor.putWidget("createButton", (AbstractWidget)Button.builder((Component)Component.translatable((String)"selectWorld.create"), button -> this.onCreate()).bounds(layoutX, this.panel.y + 197, layoutWidth, 20).build())));
        this.addRenderableWidget((GuiEventListener)((TickBox)accessor.putWidget("onlineTickBox", (AbstractWidget)new TickBox(layoutX + 1, this.panel.y + 155, layoutWidth, this.publishScreen.publish, b -> PublishScreen.PUBLISH, b -> null, button -> {
            if (button.selected) {
                this.minecraft.setScreen((Screen)this.publishScreen);
            }
            this.publishScreen.publish = false;
            button.selected = false;
        }))));
        this.resourceAlbumSelector.setX(layoutX);
        this.resourceAlbumSelector.setY(this.panel.y + 106);
        this.resourceAlbumSelector.setWidth(layoutWidth);
        this.addRenderableWidget((GuiEventListener)((PackAlbum.Selector)accessor.putWidget("resourceAlbumSelector", (AbstractWidget)this.resourceAlbumSelector)));
        this.uiState.onChanged();
    }

    @Inject(method={"repositionElements"}, at={@At(value="HEAD")}, cancellable=true)
    public void repositionElements(CallbackInfo ci) {
        this.rebuildWidgets();
        ci.cancel();
    }

    @Inject(method={"createWorldAndCleanup"}, at={@At(value="RETURN")})
    private void onCreate(CallbackInfo ci) {
        this.resourceAlbumSelector.applyChanges(true);
        Legacy4JClient.serverPlayerJoinConsumer = s -> {
            MinecraftServer server = FactoryAPIPlatform.getEntityServer((Entity)s);
            LegacyClientWorldSettings.of(server.getWorldData()).setTrustPlayers((Boolean)this.trustPlayers.get());
            server.getPlayerList().sendPlayerPermissionLevel(s);
            this.publishScreen.publish((IntegratedServer)server);
            LegacyClientWorldSettings.of(this.minecraft.getSingleplayerServer().getWorldData()).setSelectedResourceAlbum(this.resourceAlbumSelector.getSelectedAlbum());
        };
    }

    @ModifyExpressionValue(method={"createNewWorld"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;createWorldOpenFlows()Lnet/minecraft/client/gui/screens/worldselection/WorldOpenFlows;")})
    private WorldOpenFlows createNewWorld(WorldOpenFlows original) {
        return (Boolean)LegacyOptions.saveCache.get() != false ? new WorldOpenFlows(this.minecraft, LegacySaveCache.currentWorldSource) : original;
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.resourceAlbumSelector.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        return super.mouseScrolled(d, e, f, g);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        LegacyRenderUtil.renderDefaultBackground(UIAccessor.of((Screen)this), guiGraphics, false);
        this.resourceAlbumSelector.renderTooltipBox(guiGraphics, (LayoutElement)this.panel);
        super.render(guiGraphics, i, j, f);
        UIAccessor accessor = UIAccessor.of((Screen)this);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)accessor.getInteger("nameLabel.x", this.panel.x + 14), (float)accessor.getInteger("nameLabel.y", this.panel.y + 15));
        if (LegacyOptions.getUIMode().isSD()) {
            guiGraphics.pose().scale(0.5f, 0.5f);
        }
        guiGraphics.drawString(this.font, NAME_LABEL, 0, 0, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.pose().popMatrix();
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        return super.keyPressed(keyEvent);
    }

    public void onClose() {
        LegacySoundUtil.playBackSound();
        this.popScreen();
    }
}

