/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Rotations;
import net.minecraft.world.entity.decoration.ArmorStand;
import wily.factoryapi.base.Stocker;

public record ArmorStandPose(Rotations headPose, Rotations bodyPose, Rotations leftArmPose, Rotations rightArmPose, Rotations leftLegPose, Rotations rightLegPose) {
    public static final Rotations ZERO_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    public static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    public static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    public static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    public static ArmorStandPose DEFAULT = new ArmorStandPose(ZERO_POSE, ZERO_POSE, DEFAULT_LEFT_ARM_POSE, DEFAULT_RIGHT_ARM_POSE, DEFAULT_LEFT_LEG_POSE, DEFAULT_RIGHT_LEG_POSE);
    public static List<ArmorStandPose> LIST = new ArrayList<ArmorStandPose>(15);

    public static ArmorStandPose getActualPose(int signal) {
        return LIST.get(Math.min(signal - 1, LIST.size() - 1));
    }

    public static ArmorStandPose getActualPose(ArmorStand armorStand) {
        for (ArmorStandPose pose : LIST) {
            if (!pose.isApplied(armorStand)) continue;
            return pose;
        }
        return null;
    }

    public static ArmorStandPose getNextPose(ArmorStand armorStand) {
        ArmorStandPose pose = ArmorStandPose.getActualPose(armorStand);
        return pose == null ? DEFAULT : LIST.get(Stocker.cyclic((int)0, (int)(LIST.indexOf(pose) + 1), (int)(LIST.size() - 1)));
    }

    public static void init() {
        LIST.add(DEFAULT);
        LIST.add(DEFAULT.withArmsAndLegs(ZERO_POSE, ZERO_POSE, ZERO_POSE, ZERO_POSE));
        LIST.add(new ArmorStandPose(new Rotations(16.0f, 0.0f, 0.0f), ZERO_POSE, new Rotations(303.0f, 18.0f, 0.0f), new Rotations(303.0f, 338.0f, 0.0f), DEFAULT_LEFT_LEG_POSE, DEFAULT_RIGHT_LEG_POSE));
        LIST.add(DEFAULT.withArms(new Rotations(16.0f, 18.0f, 0.0f), new Rotations(303.0f, 11.0f, 12.0f)));
        LIST.add(new ArmorStandPose(new Rotations(357.0f, 0.0f, 0.0f), ZERO_POSE, new Rotations(16.0f, 18.0f, 0.0f), new Rotations(241.0f, 31.0f, 12.0f), new Rotations(351.0f, 11.0f, 0.0f), new Rotations(10.0f, 352.0f, 0.0f)));
        LIST.add(new ArmorStandPose(new Rotations(357.0f, 0.0f, 0.0f), ZERO_POSE, new Rotations(241.0f, 38.0f, 0.0f), new Rotations(241.0f, 318.0f, 12.0f), new Rotations(10.0f, 352.0f, 0.0f), new Rotations(351.0f, 11.0f, 0.0f)));
        LIST.add(new ArmorStandPose(new Rotations(357.0f, 0.0f, 0.0f), ZERO_POSE, new Rotations(241.0f, 318.0f, 0.0f), new Rotations(241.0f, 38.0f, 12.0f), new Rotations(10.0f, 352.0f, 0.0f), new Rotations(351.0f, 11.0f, 0.0f)));
        LIST.add(DEFAULT.withArms(new Rotations(16.0f, 0.0f, 0.0f), new Rotations(296.0f, 318.0f, 0.0f)));
        LIST.add(new ArmorStandPose(new Rotations(16.0f, 11.0f, 0.0f), ZERO_POSE, new Rotations(180.0f, 86.0f, 60.0f), new Rotations(282.0f, 331.0f, 0.0f), new Rotations(0.0f, 38.0f, 353.0f), new Rotations(10.0f, 11.0f, 6.0f)));
        LIST.add(new ArmorStandPose(new Rotations(351.0f, 345.0f, 0.0f), ZERO_POSE, new Rotations(255.0f, 4.0f, 60.0f), new Rotations(255.0f, 352.0f, 0.0f), new Rotations(16.0f, 0.0f, 0.0f), new Rotations(330.0f, 0.0f, 0.0f)));
        LIST.add(new ArmorStandPose(new Rotations(357.0f, 106.0f, 12.0f), new Rotations(0.0f, 4.0f, 6.0f), new Rotations(173.0f, 52.0f, 53.0f), new Rotations(201.0f, 113.0f, 319.0f), new Rotations(255.0f, 35.0f, 0.0f), new Rotations(3.0f, 31.0f, 0.0f)));
        LIST.add(new ArmorStandPose(new Rotations(357.0f, 79.0f, 0.0f), new Rotations(0.0f, 0.0f, 353.0f), new Rotations(160.0f, 120.0f, 53.0f), new Rotations(201.0f, 0.0f, 299.0f), new Rotations(351.0f, 31.0f, 6.0f), new Rotations(228.0f, 331.0f, 46.0f)));
        LIST.add(DEFAULT.withArmsAndLegs(new Rotations(16.0f, 0.0f, 0.0f), new Rotations(248.0f, 38.0f, 0.0f), new Rotations(0.0f, 38.0f, 353.0f), new Rotations(3.0f, 243.0f, 0.0f)));
    }

    public ArmorStandPose withArmsAndLegs(Rotations leftArmPose, Rotations rightArmPose, Rotations leftLegPose, Rotations rightLegPose) {
        return new ArmorStandPose(this.headPose, this.bodyPose, leftArmPose, rightArmPose, leftLegPose, rightLegPose);
    }

    public ArmorStandPose withArms(Rotations leftArmPose, Rotations rightArmPose) {
        return new ArmorStandPose(this.headPose, this.bodyPose, leftArmPose, rightArmPose, this.leftLegPose, this.rightLegPose);
    }

    public void applyPose(ArmorStand armorStand) {
        if (this.headPose != null) {
            armorStand.setHeadPose(this.headPose);
        }
        if (this.bodyPose != null) {
            armorStand.setBodyPose(this.bodyPose);
        }
        if (this.leftArmPose != null) {
            armorStand.setLeftArmPose(this.leftArmPose);
        }
        if (this.rightArmPose != null) {
            armorStand.setRightArmPose(this.rightArmPose);
        }
        if (this.leftLegPose != null) {
            armorStand.setLeftLegPose(this.leftLegPose);
        }
        if (this.rightLegPose != null) {
            armorStand.setRightLegPose(this.rightLegPose);
        }
    }

    public boolean isApplied(ArmorStand armorStand) {
        return armorStand.getHeadPose().equals((Object)this.headPose) && armorStand.getBodyPose().equals((Object)this.bodyPose) && armorStand.getLeftArmPose().equals((Object)this.leftArmPose) && armorStand.getRightArmPose().equals((Object)this.rightArmPose) && armorStand.getLeftLegPose().equals((Object)this.leftLegPose) && armorStand.getRightLegPose().equals((Object)this.rightLegPose);
    }
}

