/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.worldselection.PresetEditor;
import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.FireworkRocketRenderState;
import net.minecraft.client.renderer.entity.state.GhastRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.ThrownTridentRenderState;
import net.minecraft.client.renderer.entity.state.VillagerRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.RegisterPresetEditorsEvent;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.client.FactoryRenderStateExtension;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.config.FactoryMixinToggle;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.ListMap;
import wily.factoryapi.util.ModInfo;
import wily.legacy.Legacy4J;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.client.BackupConfirmScreenAccessor;
import wily.legacy.client.ControlType;
import wily.legacy.client.DisconnectedScreenAccessor;
import wily.legacy.client.KnownListing;
import wily.legacy.client.LegacyBiomeOverride;
import wily.legacy.client.LegacyCraftingTabListing;
import wily.legacy.client.LegacyCreativeTabListing;
import wily.legacy.client.LegacyFireworkRenderState;
import wily.legacy.client.LegacyLivingEntityRenderState;
import wily.legacy.client.LegacyMixinOptions;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyResourceManager;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.LegacyTipOverride;
import wily.legacy.client.LegacyVillagerRenderState;
import wily.legacy.client.LegacyWorldTemplate;
import wily.legacy.client.LevelRendererAccessor;
import wily.legacy.client.LoomTabListing;
import wily.legacy.client.LoyaltyLinesRenderState;
import wily.legacy.client.MapIdValueManager;
import wily.legacy.client.OptionsPreset;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.client.StoneCuttingGroupManager;
import wily.legacy.client.TypeCraftingTab;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.ControllerManager;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreativeModeScreen;
import wily.legacy.client.screen.HostOptionsScreen;
import wily.legacy.client.screen.HowToPlayScreen;
import wily.legacy.client.screen.LeaderboardsScreen;
import wily.legacy.client.screen.Legacy4JSettingsScreen;
import wily.legacy.client.screen.LegacyBuffetWorldScreen;
import wily.legacy.client.screen.LegacyCraftingScreen;
import wily.legacy.client.screen.LegacyFlatWorldScreen;
import wily.legacy.client.screen.LegacyLoadingScreen;
import wily.legacy.client.screen.LegacyLoomScreen;
import wily.legacy.client.screen.LegacyMerchantScreen;
import wily.legacy.client.screen.LegacyScreen;
import wily.legacy.client.screen.LegacyStonecutterScreen;
import wily.legacy.client.screen.MixedCraftingScreen;
import wily.legacy.client.screen.PlayGameScreen;
import wily.legacy.client.screen.ReplaceableScreen;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.compat.IrisCompat;
import wily.legacy.client.screen.compat.SodiumCompat;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.entity.LegacyLocalPlayer;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.init.LegacyUIElementTypes;
import wily.legacy.inventory.LegacyPistonMovingBlockEntity;
import wily.legacy.network.ServerOpenClientMenuPayload;
import wily.legacy.network.TopMessage;
import wily.legacy.util.client.LegacyGuiElements;
import wily.legacy.util.client.MCAccount;

public class Legacy4JClient {
    public static final List<Runnable> whenResetOptions = new ArrayList<Runnable>();
    public static final LegacyTipManager legacyTipManager = new LegacyTipManager();
    public static final MapIdValueManager<LegacyCreativeTabListing, ?> legacyCreativeListingManager = MapIdValueManager.create(Legacy4J.createModLocation("creative_tab_listing"), LegacyCreativeTabListing.CODEC);
    public static final MapIdValueManager<LegacyCraftingTabListing, ?> legacyCraftingListingManager = MapIdValueManager.create(Legacy4J.createModLocation("crafting_tab_listing"), LegacyCraftingTabListing.CODEC);
    public static final MapIdValueManager<LegacyBiomeOverride, ?> legacyBiomeOverrides = MapIdValueManager.createWithListCodec(Legacy4J.createModLocation("biome_overrides"), LegacyBiomeOverride.LIST_MAP_CODEC);
    public static final LegacyWorldTemplate.Manager legacyWorldTemplateManager = new LegacyWorldTemplate.Manager();
    public static final LegacyTipOverride.Manager legacyTipOverridesManager = new LegacyTipOverride.Manager();
    public static final LegacyResourceManager legacyResourceManager = new LegacyResourceManager();
    public static final StoneCuttingGroupManager stoneCuttingGroupManager = new StoneCuttingGroupManager();
    public static final MapIdValueManager<LoomTabListing, ?> loomListingManager = MapIdValueManager.create(Legacy4J.createModLocation("loom_tab_listing"), LoomTabListing.CODEC);
    public static final MapIdValueManager<TypeCraftingTab, ?> typeCraftingTabs = MapIdValueManager.create(Legacy4J.createModLocation("type_crafting_tabs"), TypeCraftingTab.CODEC);
    public static final ControlTooltip.GuiManager controlTooltipGuiManager = new ControlTooltip.GuiManager();
    public static final LeaderboardsScreen.Manager leaderBoardListingManager = new LeaderboardsScreen.Manager();
    public static final HowToPlayScreen.Manager howToPlaySectionManager = new HowToPlayScreen.Manager();
    public static final MapIdValueManager<OptionsPreset, ListMap<ResourceLocation, OptionsPreset>> optionPresetsManager = MapIdValueManager.createListMap(Legacy4J.createModLocation("option_presets"), OptionsPreset.CODEC);
    public static final MapIdValueManager<ControlType, ListMap<ResourceLocation, ControlType>> controlTypesManager = MapIdValueManager.createListMap(Legacy4J.createModLocation("control_types"), ControlType.CODEC);
    public static final ControllerManager controllerManager = new ControllerManager();
    public static final Map<Block, ResourceLocation> fastLeavesModels = new HashMap<Block, ResourceLocation>();
    public static final FactoryConfig.StorageHandler MIXIN_CONFIGS_STORAGE = FactoryConfig.StorageHandler.fromMixin((FactoryMixinToggle.Storage)LegacyMixinOptions.CLIENT_MIXIN_STORAGE, (boolean)false);
    public static final RenderType GHAST_SHOOTING_GLOW = RenderType.eyes((ResourceLocation)FactoryAPI.createVanillaLocation((String)"textures/entity/ghast/ghast_shooting_glow.png"));
    public static final RenderType DROWNED_GLOW = RenderType.eyes((ResourceLocation)FactoryAPI.createVanillaLocation((String)"textures/entity/zombie/drowned_glow.png"));
    public static final Map<Optional<ResourceKey<WorldPreset>>, PresetEditor> VANILLA_PRESET_EDITORS = new HashMap<Optional<ResourceKey>, PresetEditor>(Map.of(Optional.of(WorldPresets.FLAT), (createWorldScreen, settings) -> {
        ChunkGenerator chunkGenerator = settings.selectedDimensions().overworld();
        RegistryAccess.Frozen registryAccess = settings.worldgenLoadContext();
        Registry biomeGetter = registryAccess.lookupOrThrow(Registries.BIOME);
        Registry structureGetter = registryAccess.lookupOrThrow(Registries.STRUCTURE_SET);
        Registry placeFeatureGetter = registryAccess.lookupOrThrow(Registries.PLACED_FEATURE);
        return new LegacyFlatWorldScreen((Screen)createWorldScreen, createWorldScreen.getUiState(), (HolderLookup.RegistryLookup<Biome>)biomeGetter, (HolderLookup.RegistryLookup<StructureSet>)structureGetter, flatLevelGeneratorSettings -> createWorldScreen.getUiState().updateDimensions(PresetEditor.flatWorldConfigurator((FlatLevelGeneratorSettings)flatLevelGeneratorSettings)), chunkGenerator instanceof FlatLevelSource ? ((FlatLevelSource)chunkGenerator).settings() : FlatLevelGeneratorSettings.getDefault((HolderGetter)biomeGetter, (HolderGetter)structureGetter, (HolderGetter)placeFeatureGetter));
    }, Optional.of(WorldPresets.SINGLE_BIOME_SURFACE), (createWorldScreen, settings) -> new LegacyBuffetWorldScreen(createWorldScreen, (HolderLookup.RegistryLookup<Biome>)settings.worldgenLoadContext().lookupOrThrow(Registries.BIOME), holder -> createWorldScreen.getUiState().updateDimensions(PresetEditor.fixedBiomeConfigurator((Holder)holder)))));
    public static final KeyMapping keyCrafting = new KeyMapping("legacy.key.crafting", 69, KeyMapping.Category.INVENTORY);
    public static final KeyMapping keyCycleHeldLeft = new KeyMapping("legacy.key.cycleHeldLeft", 267, KeyMapping.Category.INVENTORY);
    public static final KeyMapping keyCycleHeldRight = new KeyMapping("legacy.key.cycleHeldRight", 266, KeyMapping.Category.INVENTORY);
    public static final KeyMapping keyToggleCursor = new KeyMapping("legacy.key.toggleCursor", -1, KeyMapping.Category.MISC);
    public static KeyMapping keyHostOptions = new KeyMapping("legacy.key.host_options", 72, KeyMapping.Category.MISC);
    public static KeyMapping keyLegacy4JSettings = new KeyMapping("legacy.key.legacy4JSettings", 89, KeyMapping.Category.MISC);
    public static KeyMapping keyFlyUp = new KeyMapping("legacy.key.flyUp", 265, KeyMapping.Category.MOVEMENT);
    public static KeyMapping keyFlyDown = new KeyMapping("legacy.key.flyDown", 264, KeyMapping.Category.MOVEMENT);
    public static KeyMapping keyFlyLeft = new KeyMapping("legacy.key.flyLeft", 263, KeyMapping.Category.MOVEMENT);
    public static KeyMapping keyFlyRight = new KeyMapping("legacy.key.flyRight", 262, KeyMapping.Category.MOVEMENT);
    public static boolean isNewerVersion = false;
    public static boolean isNewerMinecraftVersion = false;
    public static ControlType lastControlType;
    public static boolean canSprint;
    public static int sprintTicksLeft;
    public static LegacyLoadingScreen legacyLoadingScreen;
    public static KnownListing<Block> knownBlocks;
    public static KnownListing<EntityType<?>> knownEntities;
    public static GameType defaultServerGameType;
    public static GameRules gameRules;
    public static Consumer<ServerPlayer> serverPlayerJoinConsumer;

    public static float[] getVisualPlayerColor(LegacyPlayerInfo info) {
        return Legacy4JClient.getVisualPlayerColor(info.getIdentifierIndex() >= 0 ? info.getIdentifierIndex() : info.legacyMinecraft$getProfile().id().hashCode());
    }

    public static float[] getVisualPlayerColor(int i) {
        PlayerIdentifier playerIdentifier = PlayerIdentifier.of(i);
        if (PlayerIdentifier.list.containsKey(i)) {
            return new float[]{(float)(playerIdentifier.color() >> 16 & 0xFF) / 255.0f, (float)(playerIdentifier.color() >> 8 & 0xFF) / 255.0f, (float)(playerIdentifier.color() & 0xFF) / 255.0f};
        }
        float r = (float)(playerIdentifier.color() >> 16 & 0xFF) * (0.8f + (float)(i % 15) / 30.0f) / 255.0f;
        float g = (float)(playerIdentifier.color() >> 8 & 0xFF) * (1.2f - (float)(i % 16) / 32.0f) / 255.0f;
        float b = (float)(playerIdentifier.color() & 0xFF) * (0.8f + (float)(i % 17) / 34.0f) / 255.0f;
        return new float[]{r, g, b};
    }

    public static void updateLegacyPlayerInfos(Map<UUID, LegacyPlayerInfo> map) {
        Minecraft minecraft = Minecraft.getInstance();
        map.forEach((s, i) -> {
            PlayerInfo patt0$temp;
            if (minecraft.getConnection() != null && (patt0$temp = minecraft.getConnection().getPlayerInfo(s)) instanceof LegacyPlayerInfo) {
                LegacyPlayerInfo info = (LegacyPlayerInfo)patt0$temp;
                info.copyFrom((LegacyPlayerInfo)i);
            }
        });
        LeaderboardsScreen.refreshStatsBoards(minecraft);
        Screen screen = minecraft.screen;
        if (screen instanceof LeaderboardsScreen) {
            LeaderboardsScreen s2 = (LeaderboardsScreen)screen;
            if (LeaderboardsScreen.statsBoards.get((int)s2.selectedStatBoard).statsList.isEmpty()) {
                minecraft.executeIfPossible(() -> s2.changeStatBoard(false));
            }
        }
        if (minecraft.player != null) {
            LegacyOptions.classicCrafting.set((Object)((Boolean)LegacyOptions.classicCrafting.get()));
            LegacyOptions.classicTrading.set((Object)((Boolean)LegacyOptions.classicTrading.get()));
            LegacyOptions.classicStonecutting.set((Object)((Boolean)LegacyOptions.classicStonecutting.get()));
            LegacyOptions.classicLoom.set((Object)((Boolean)LegacyOptions.classicLoom.get()));
        }
    }

    public static boolean playerHasInfiniteMaterials() {
        return Minecraft.getInstance().player.hasInfiniteMaterials();
    }

    public static Screen getReplacementScreen(Screen screen) {
        if (!((Boolean)LegacyMixinOptions.legacyTitleScreen.get()).booleanValue()) {
            return screen;
        }
        if (screen instanceof JoinMultiplayerScreen) {
            return new PlayGameScreen((Screen)new TitleScreen(), 2);
        }
        if (screen instanceof DisconnectedScreen) {
            DisconnectedScreen s = (DisconnectedScreen)screen;
            return ConfirmationScreen.createInfoScreen(Legacy4JClient.getReplacementScreen(DisconnectedScreenAccessor.of(s).getParent()), s.getTitle(), DisconnectedScreenAccessor.of(s).getReason());
        }
        if (screen instanceof AlertScreen) {
            final AlertScreen s = (AlertScreen)screen;
            return new ConfirmationScreen(Minecraft.getInstance().screen, ConfirmationScreen::getPanelWidth, () -> LegacyOptions.getUIMode().isSD() ? 50 : 75, s.getTitle(), s.messageText, LegacyScreen::onClose){

                @Override
                protected void addButtons() {
                    this.okButton = Button.builder((Component)Component.translatable((String)"gui.ok"), b -> s2.callback.run()).bounds(this.panel.x + 15, this.panel.y + this.panel.height - 30, 200, 20).build();
                    this.renderableVList.addRenderable((Renderable)this.okButton);
                }

                public boolean shouldCloseOnEsc() {
                    return s.shouldCloseOnEsc();
                }
            };
        }
        if (screen instanceof BackupConfirmScreen) {
            final BackupConfirmScreen s = (BackupConfirmScreen)screen;
            return new ConfirmationScreen(Minecraft.getInstance().screen, ConfirmationScreen::getPanelWidth, () -> (LegacyOptions.getUIMode().isSD() ? 94 : 141) + (BackupConfirmScreenAccessor.of(s).hasCacheErase() ? (LegacyOptions.getUIMode().isSD() ? 11 : 14) : 0), s.getTitle(), BackupConfirmScreenAccessor.of(s).getDescription(), LegacyScreen::onClose){
                boolean eraseCache;
                {
                    super(parent, imageWidth, baseHeight, title, message, okAction);
                    this.eraseCache = false;
                }

                @Override
                protected void addButtons() {
                    if (BackupConfirmScreenAccessor.of(s).hasCacheErase()) {
                        this.renderableVList.addRenderable((Renderable)new TickBox(this.panel.x + 15, this.panel.y + this.panel.height - 88, this.eraseCache, b -> Component.translatable((String)"selectWorld.backupEraseCache"), b -> null, b -> {
                            this.eraseCache = b.selected;
                        }));
                    }
                    this.okButton = Button.builder((Component)Component.translatable((String)"selectWorld.backupJoinConfirmButton"), b -> BackupConfirmScreenAccessor.of(s).proceed(true, this.eraseCache)).build();
                    this.renderableVList.addRenderable((Renderable)this.okButton);
                    this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"selectWorld.backupJoinSkipButton"), b -> BackupConfirmScreenAccessor.of(s).proceed(false, this.eraseCache)).build());
                    this.renderableVList.addRenderable((Renderable)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> this.onClose()).build());
                }

                @Override
                public void onClose() {
                    BackupConfirmScreenAccessor.of(s).cancel();
                }
            };
        }
        return screen;
    }

    public static void preTick(Minecraft minecraft) {
        boolean left;
        ReplaceableScreen r;
        Screen screen;
        ControlType activeControlType;
        if (minecraft.isGameLoadFinished() && lastControlType != (activeControlType = ControlType.getActiveType())) {
            if (lastControlType != null) {
                ((ControlType.UpdateEvent)ControlType.UpdateEvent.EVENT.invoker).change(lastControlType, activeControlType);
            }
            lastControlType = activeControlType;
        }
        if ((screen = minecraft.screen) instanceof ReplaceableScreen && (r = (ReplaceableScreen)screen).canReplace()) {
            minecraft.setScreen(r.getReplacement());
        }
        if (((Boolean)LegacyOptions.unfocusedInputs.get()).booleanValue()) {
            minecraft.setWindowActive(true);
        }
        while (keyCrafting.consumeClick()) {
            if (minecraft.player != null && (minecraft.player.isCreative() || minecraft.player.isSpectator())) {
                if (minecraft.player.isSpectator()) {
                    minecraft.gui.getSpectatorGui().onHotbarActionKeyPressed();
                    continue;
                }
                minecraft.setScreen(CreativeModeScreen.getActualCreativeScreenInstance(minecraft));
                continue;
            }
            screen = minecraft.hitResult;
            if (screen instanceof BlockHitResult && minecraft.level.getBlockState((r = (BlockHitResult)screen).getBlockPos()).getBlock() instanceof CraftingTableBlock && controllerManager.isControllerTheLastInput()) {
                minecraft.gameMode.useItemOn(minecraft.player, InteractionHand.MAIN_HAND, (BlockHitResult)r);
                continue;
            }
            if (LegacyOptions.hasClassicCrafting()) {
                minecraft.getTutorial().onOpenInventory();
                minecraft.setScreen((Screen)new InventoryScreen((Player)minecraft.player));
                continue;
            }
            if (LegacyOptions.hasMixedCrafting()) {
                minecraft.setScreen(MixedCraftingScreen.playerCraftingScreen((Player)minecraft.player));
                continue;
            }
            CommonNetwork.sendToServer((CommonNetwork.Payload)ServerOpenClientMenuPayload.playerCrafting());
        }
        while (keyHostOptions.consumeClick()) {
            minecraft.setScreen((Screen)new HostOptionsScreen());
        }
        while (keyLegacy4JSettings.consumeClick()) {
            minecraft.setScreen((Screen)new Legacy4JSettingsScreen(Minecraft.getInstance().screen));
        }
        while ((left = keyCycleHeldLeft.consumeClick()) || keyCycleHeldRight.consumeClick()) {
            if (minecraft.player == null) continue;
            if (minecraft.player.isSpectator()) {
                if (!minecraft.gui.getSpectatorGui().isMenuActive()) continue;
                minecraft.gui.getSpectatorGui().onMouseScrolled(left ? -1 : 1);
                continue;
            }
            minecraft.player.getInventory().setSelectedSlot(Stocker.cyclic((int)0, (int)(minecraft.player.getInventory().getSelectedSlot() + (left ? -1 : 1)), (int)9));
        }
        if (sprintTicksLeft > 0) {
            --sprintTicksLeft;
        }
        if (minecraft.player != null && controllerManager.isControllerTheLastInput()) {
            float y;
            BindingState.Axis stick = controllerManager.getButtonState(ControllerBinding.LEFT_STICK);
            float f = y = Math.abs(stick.y) > stick.getDeadZone() ? stick.y : 0.0f;
            if (((LegacyLocalPlayer)minecraft.player).canSprintController()) {
                if ((double)y < -0.85) {
                    if (!canSprint && sprintTicksLeft == -1) {
                        sprintTicksLeft = 9;
                    } else if (canSprint && sprintTicksLeft > 0) {
                        minecraft.player.setSprinting(true);
                    } else {
                        canSprint = false;
                    }
                } else if ((double)y > -0.85 && sprintTicksLeft == 0) {
                    canSprint = false;
                    sprintTicksLeft = -1;
                } else if ((double)y > -0.5 && !canSprint && sprintTicksLeft > 0) {
                    canSprint = true;
                }
            } else {
                if ((double)y > -0.85) {
                    minecraft.player.setSprinting(false);
                }
                canSprint = false;
                sprintTicksLeft = -1;
            }
        }
        if (!Minecraft.getInstance().isPaused()) {
            TopMessage.tick();
        }
    }

    public static void postTick(Minecraft minecraft) {
        if (minecraft.level != null && minecraft.screen == null && ((Boolean)LegacyOptions.hints.get()).booleanValue() && LegacyTipManager.getActualTip() == null) {
            EntityHitResult r;
            Entity e;
            HitResult hit = minecraft.hitResult;
            if (hit instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hit;
                BlockState state = minecraft.level.getBlockState(blockHitResult.getBlockPos());
                if (!state.isAir() && !(state.getBlock() instanceof LiquidBlock) && state.getBlock().asItem() instanceof BlockItem && !knownBlocks.contains(state.getBlock()) && LegacyTipManager.setTip(LegacyTipManager.getTip(state.getBlock().asItem().getDefaultInstance()))) {
                    knownBlocks.add(state.getBlock());
                }
            } else if (hit instanceof EntityHitResult && !knownEntities.contains((e = (r = (EntityHitResult)hit).getEntity()).getType()) && LegacyTipManager.setTip(LegacyTipManager.getTip(e))) {
                knownEntities.add(r.getEntity().getType());
            }
        }
    }

    public static void postScreenInit(Screen screen) {
        if (screen.getFocused() != null && !screen.children().contains(screen.getFocused())) {
            screen.clearFocus();
        }
        if ((Minecraft.getInstance().getLastInputType().isKeyboard() || controllerManager.isControllerTheLastInput() || controllerManager.getCursorMode().isNever()) && !controllerManager.getCursorMode().isAlways()) {
            ComponentPath path;
            Controller.Event e = Controller.Event.of(screen);
            if (e.disableCursorOnInit() && !controllerManager.getCursorMode().isAlways()) {
                controllerManager.tryDisableCursor();
            }
            if (Legacy4JClient.controllerManager.isCursorDisabled && (!e.disableCursorOnInit() || controllerManager.getCursorMode().isAlways())) {
                controllerManager.enableCursorAndScheduleReset();
            }
            if (Legacy4JClient.controllerManager.isCursorDisabled && (screen.getFocused() == null || !screen.getFocused().isFocused()) && (path = screen.nextFocusPath((FocusNavigationEvent)new FocusNavigationEvent.ArrowNavigation(ScreenDirection.DOWN))) != null) {
                path.applyFocus(true);
            }
        }
        controllerManager.resetCursor();
    }

    public static void clientPlayerJoin(LocalPlayer p) {
        gameRules = new GameRules(p.connection.enabledFeatures());
        LegacyCreativeTabListing.rebuildVanillaCreativeTabsItems(Minecraft.getInstance());
    }

    public static void serverPlayerJoin(ServerPlayer player) {
        if (serverPlayerJoinConsumer != null) {
            serverPlayerJoinConsumer.accept(player);
            serverPlayerJoinConsumer = null;
        }
    }

    public static void init() {
        ControlType.UpdateEvent.EVENT.register((last, actual) -> {
            UIAccessor uiAccessor = Minecraft.getInstance().screen == null ? FactoryScreenUtil.getGuiAccessor() : FactoryScreenUtil.getScreenAccessor();
            uiAccessor.reloadUI();
            LegacyTipManager.rebuildActual();
        });
        FactoryAPIClient.registerKeyMapping(registry -> {
            registry.accept(keyCrafting);
            registry.accept(keyHostOptions);
            registry.accept(keyLegacy4JSettings);
            registry.accept(keyCycleHeldLeft);
            registry.accept(keyCycleHeldRight);
            registry.accept(keyToggleCursor);
            registry.accept(keyFlyUp);
            registry.accept(keyFlyDown);
            registry.accept(keyFlyLeft);
            registry.accept(keyFlyRight);
        });
        DynamicUtil.COMMON_ITEMS.put((Object)FactoryAPI.createVanillaLocation((String)"ominous_banner"), () -> {
            if (Minecraft.getInstance().getConnection() == null) {
                return ItemStack.EMPTY;
            }
            return Raid.getOminousBannerInstance((HolderGetter)Minecraft.getInstance().getConnection().registryAccess().lookupOrThrow(Registries.BANNER_PATTERN));
        });
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyTipManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, legacyCreativeListingManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, legacyCraftingListingManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyWorldTemplateManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyTipOverridesManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, legacyBiomeOverrides);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, optionPresetsManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, controlTypesManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)legacyResourceManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)stoneCuttingGroupManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, loomListingManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, typeCraftingTabs);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)controlTooltipGuiManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)leaderBoardListingManager);
        FactoryEvent.registerReloadListener((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)howToPlaySectionManager);
        FactoryOptions.NEAREST_MIPMAP_SCALING.setDefault((Object)true);
        FactoryOptions.RANDOM_BLOCK_ROTATIONS.setDefault((Object)false);
        FactoryAPIClient.setup(m -> {
            MCAccount.loadAll();
            controllerManager.setup((Minecraft)m);
            knownBlocks = new KnownListing(BuiltInRegistries.BLOCK, m.gameDirectory.toPath());
            knownEntities = new KnownListing(BuiltInRegistries.ENTITY_TYPE, m.gameDirectory.toPath());
            LegacySaveCache.setup(m);
            ControllerBinding.setupDefaultBindings(m);
            LegacyOptions.CLIENT_STORAGE.load();
            FactoryAPIClient.registerRenderType((ChunkSectionLayer)ChunkSectionLayer.CUTOUT_MIPPED, (Block[])new Block[]{(Block)LegacyRegistries.SHRUB.get()});
            FactoryAPIClient.registerRenderType((ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT, (Block[])new Block[]{Blocks.WATER});
            if (FactoryAPI.isModLoaded((String)"sodium")) {
                SodiumCompat.init();
            }
            if (FactoryAPI.isModLoaded((String)"iris")) {
                IrisCompat.init();
            }
            LegacyGuiElements.setup(m);
        });
        FactoryAPIClient.registerBlockColor(registry -> {
            registry.accept((blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter == null || blockPos == null ? GrassColor.getDefaultColor() : BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos), (Block)LegacyRegistries.SHRUB.get());
            BlockColor blockColor = (blockState, blockAndTintGetter, blockPos, i) -> {
                if (blockAndTintGetter != null && blockPos != null) {
                    LegacyPistonMovingBlockEntity e;
                    BlockEntity blockEntity = blockAndTintGetter.getBlockEntity(blockPos);
                    if (blockEntity instanceof LegacyPistonMovingBlockEntity && (e = (LegacyPistonMovingBlockEntity)blockEntity).getRenderingBlockEntity() != null && ((Boolean)LegacyOptions.enhancedPistonMovingRenderer.get()).booleanValue()) {
                        blockEntity = e.getRenderingBlockEntity();
                    }
                    if (blockEntity instanceof WaterCauldronBlockEntity) {
                        WaterCauldronBlockEntity be = (WaterCauldronBlockEntity)blockEntity;
                        if (!be.hasWater()) {
                            return PotionContents.getColorOptional((Iterable)((Potion)be.potion.value()).getEffects()).orElse(-13083194);
                        }
                        if (be.waterColor != null) {
                            return be.waterColor;
                        }
                    }
                    return BiomeColors.getAverageWaterColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos);
                }
                return -1;
            };
            registry.accept(blockColor, Blocks.WATER_CAULDRON);
            registry.accept(blockColor, (Block)LegacyRegistries.COLORED_WATER_CAULDRON.get());
        });
        fastLeavesModels.put(Blocks.OAK_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_oak_leaves"));
        fastLeavesModels.put(Blocks.SPRUCE_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_spruce_leaves"));
        fastLeavesModels.put(Blocks.BIRCH_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_birch_leaves"));
        fastLeavesModels.put(Blocks.JUNGLE_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_jungle_leaves"));
        fastLeavesModels.put(Blocks.ACACIA_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_acacia_leaves"));
        fastLeavesModels.put(Blocks.CHERRY_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_cherry_leaves"));
        fastLeavesModels.put(Blocks.DARK_OAK_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_dark_oak_leaves"));
        fastLeavesModels.put(Blocks.MANGROVE_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_mangrove_leaves"));
        fastLeavesModels.put(Blocks.PALE_OAK_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_pale_oak_leaves"));
        fastLeavesModels.put(Blocks.AZALEA_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_azalea_leaves"));
        fastLeavesModels.put(Blocks.FLOWERING_AZALEA_LEAVES, FactoryAPI.createVanillaLocation((String)"fast_flowering_azalea_leaves"));
        FactoryAPIClient.registerExtraModels(register -> fastLeavesModels.values().forEach(register));
        FactoryAPIClient.registerMenuScreen(registry -> {
            registry.register((MenuType)LegacyRegistries.CRAFTING_PANEL_MENU.get(), LegacyCraftingScreen::craftingScreen);
            registry.register((MenuType)LegacyRegistries.PLAYER_CRAFTING_PANEL_MENU.get(), LegacyCraftingScreen::playerCraftingScreen);
            registry.register((MenuType)LegacyRegistries.LOOM_PANEL_MENU.get(), LegacyLoomScreen::new);
            registry.register((MenuType)LegacyRegistries.STONECUTTER_PANEL_MENU.get(), LegacyStonecutterScreen::new);
            registry.register((MenuType)LegacyRegistries.MERCHANT_MENU.get(), LegacyMerchantScreen::new);
        });
        FactoryAPIClient.preTick(Legacy4JClient::preTick);
        FactoryAPIClient.postTick(Legacy4JClient::postTick);
        FactoryAPIClient.PlayerEvent.JOIN_EVENT.register(Legacy4JClient::clientPlayerJoin);
        FactoryAPIClient.STOPPING.register(m -> {
            knownBlocks.save();
            knownEntities.save();
            PackAlbum.applyDefaultResourceAlbum();
            LegacyOptions.lastLoadedVersion.set((Object)Legacy4J.VERSION.get());
            LegacyOptions.lastLoadedMinecraftVersion.set((Object)SharedConstants.getCurrentVersion().name());
            LegacyOptions.CLIENT_STORAGE.save();
        });
        FactoryEvent.ServerSave.EVENT.register((server, log, flush, force) -> {
            LegacySaveCache.retakeWorldIcon = true;
            knownBlocks.save();
            knownEntities.save();
        });
        FactoryEvent.registerBuiltInPacks(registry -> {
            registry.registerResourcePack(FactoryAPI.createLocation((String)"legacy", (String)"legacy_resources"), true);
            registry.registerResourcePack(FactoryAPI.createLocation((String)"legacy", (String)"legacy_waters"), true);
            registry.registerResourcePack(FactoryAPI.createLocation((String)"legacy", (String)"console_aspects"), false);
            if (FactoryAPI.getLoader().isForgeLike()) {
                registry.register("programmer_art", FactoryAPI.createLocation((String)"legacy", (String)"programmer_art"), (Component)Component.translatable((String)"legacy.builtin.console_programmer"), Pack.Position.TOP, false);
                registry.register("high_contrast", FactoryAPI.createLocation((String)"legacy", (String)"high_contrast"), (Component)Component.translatable((String)"legacy.builtin.high_contrast"), Pack.Position.TOP, false);
            }
        });
        LegacyUIElementTypes.init();
        FactoryRenderStateExtension.types.add(new FactoryRenderStateExtension.Type(ThrownTridentRenderState.class, LoyaltyLinesRenderState::new));
        FactoryRenderStateExtension.types.add(new FactoryRenderStateExtension.Type(FireworkRocketRenderState.class, LegacyFireworkRenderState::new));
        FactoryRenderStateExtension.types.add(new FactoryRenderStateExtension.Type(LivingEntityRenderState.class, LegacyLivingEntityRenderState::new));
        FactoryRenderStateExtension.types.add(new FactoryRenderStateExtension.Type(VillagerRenderState.class, LegacyVillagerRenderState::new));
        FactoryAPIClient.registerRenderLayer(r -> {
            EntityRenderer patt1$temp;
            GhastRenderer renderer;
            EntityRenderer patt0$temp = r.getEntityRenderer(EntityType.GHAST);
            if (patt0$temp instanceof GhastRenderer) {
                renderer = (GhastRenderer)patt0$temp;
                r.register((LivingEntityRenderer)renderer, (RenderLayer)new EyesLayer<GhastRenderState, GhastModel>((RenderLayerParent)renderer){

                    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int i, GhastRenderState entityRenderState, float f, float g) {
                        if (!entityRenderState.isCharging) {
                            return;
                        }
                        super.submit(poseStack, submitNodeCollector, i, (EntityRenderState)entityRenderState, f, g);
                    }

                    public RenderType renderType() {
                        return GHAST_SHOOTING_GLOW;
                    }
                });
            }
            if ((patt1$temp = r.getEntityRenderer(EntityType.DROWNED)) instanceof DrownedRenderer) {
                renderer = (DrownedRenderer)patt1$temp;
                r.register((LivingEntityRenderer)renderer, (RenderLayer)new EyesLayer<ZombieRenderState, DrownedModel>((RenderLayerParent)renderer){

                    public RenderType renderType() {
                        return DROWNED_GLOW;
                    }
                });
            }
        });
        FactoryAPIPlatform.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterPresetEditorsEvent.class, e -> VANILLA_PRESET_EDITORS.forEach((o, presetEditor) -> o.ifPresent(worldPresetResourceKey -> e.register(worldPresetResourceKey, presetEditor))));
        FactoryAPIClient.PlayerEvent.DISCONNECTED_EVENT.register(p -> {
            PackAlbum.applyDefaultResourceAlbum();
            TopMessage.setSmall(null);
            TopMessage.setMedium(null);
        });
        FactoryAPIClient.registerConfigScreen((ModInfo)FactoryAPIPlatform.getModInfo((String)"legacy"), Legacy4JSettingsScreen::new);
        FactoryAPIClient.registerDefaultConfigScreen((String)"minecraft", s -> new OptionsScreen(s, Minecraft.getInstance().options));
    }

    public static void updateChunks() {
        FactoryAPIClient.SECURE_EXECUTOR.execute(() -> Minecraft.getInstance().levelRenderer.allChanged());
    }

    public static void updateSkyShape() {
        Minecraft.getInstance().execute(() -> ((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).updateSkyBuffers());
    }

    public static void buildLegacySkyDisc(VertexConsumer consumer, float f) {
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -256; l <= 384; l += 64) {
                float g = k;
                float f1 = k + 64;
                consumer.addVertex(g, f, (float)l);
                consumer.addVertex(f1, f, (float)l);
                consumer.addVertex(f1, f, (float)(l + 64));
                consumer.addVertex(g, f, (float)(l + 64));
            }
        }
    }

    public static BlockStateModel getFastLeavesModelReplacement(BlockGetter blockGetter, BlockPos pos, BlockState blockState, BlockStateModel model) {
        boolean fastGraphics;
        boolean bl = fastGraphics = Minecraft.getInstance().options.graphicsMode().get() == GraphicsStatus.FAST;
        if (((Boolean)LegacyOptions.fastLeavesCustomModels.get()).booleanValue() && blockState.getBlock() instanceof LeavesBlock && fastLeavesModels.containsKey(blockState.getBlock()) && (fastGraphics || ((Boolean)LegacyOptions.fastLeavesWhenBlocked.get()).booleanValue())) {
            if (!fastGraphics && blockGetter != null) {
                for (Direction value : Direction.values()) {
                    BlockPos relative = pos.relative(value);
                    BlockState relativeBlockState = blockGetter.getBlockState(relative);
                    if (relativeBlockState.getBlock() instanceof LeavesBlock || relativeBlockState.isSolidRender()) continue;
                    return model;
                }
            }
            return FactoryAPIClient.getExtraModel((ResourceLocation)fastLeavesModels.get(blockState.getBlock()));
        }
        return model;
    }

    public static boolean hasModOnServer() {
        return FactoryAPIClient.hasModOnServer((String)"legacy");
    }

    public static int getEffectiveRenderDistance() {
        return Minecraft.getInstance().options.getEffectiveRenderDistance();
    }

    public static void onClientPlayerInfoChange() {
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (screen instanceof HostOptionsScreen) {
            HostOptionsScreen s = (HostOptionsScreen)screen;
            s.reloadPlayerButtons();
        } else {
            screen = minecraft.screen;
            if (screen instanceof LeaderboardsScreen) {
                LeaderboardsScreen s = (LeaderboardsScreen)screen;
                s.rebuildRenderableVList(minecraft);
                s.repositionElements();
            }
        }
    }

    public static void resetOptions(Minecraft minecraft) {
        whenResetOptions.forEach(Runnable::run);
        for (KeyMapping keyMapping : minecraft.options.keyMappings) {
            keyMapping.setKey(keyMapping.getDefaultKey());
            LegacyKeyMapping.of(keyMapping).setBinding(LegacyKeyMapping.of(keyMapping).getDefaultBinding());
            KeyMapping.resetMapping();
        }
        LegacyOptions.CLIENT_STORAGE.configMap.values().forEach(FactoryConfig::reset);
        LegacyOptions.CLIENT_STORAGE.save();
        LegacyCommonOptions.COMMON_STORAGE.save();
        LegacyCommonOptions.COMMON_STORAGE.configMap.values().forEach(FactoryConfig::reset);
        minecraft.options.save();
    }

    public static String manageAvailableSaveDirName(Consumer<File> copy, Predicate<String> exists, LevelStorageSource source, String levelId) {
        String destId = Legacy4JClient.manageAvailableName(exists, levelId);
        copy.accept(source.getBaseDir().resolve(destId).toFile());
        return destId;
    }

    public static String manageAvailableName(Predicate<String> exists, String saveDirName) {
        StringBuilder builder = new StringBuilder(saveDirName);
        int repeat = 0;
        while (exists.test(String.valueOf(builder) + (repeat > 0 ? String.format(" (%s)", repeat) : ""))) {
            ++repeat;
        }
        if (repeat > 0) {
            builder.append(String.format(" (%s)", repeat));
        }
        return builder.toString();
    }

    static {
        canSprint = false;
        sprintTicksLeft = -1;
        legacyLoadingScreen = new LegacyLoadingScreen();
    }
}

