/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BannerPattern;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyTabInfo;
import wily.legacy.client.screen.LegacyTabButton;

public record LoomTabListing(ResourceLocation id, Optional<Component> name, Optional<LegacyTabButton.IconHolder<?>> iconHolder, List<ResourceKey<BannerPattern>> patterns) implements LegacyTabInfo<LoomTabListing>
{
    public static final Codec<List<ResourceKey<BannerPattern>>> PATTERNS_CODEC = ResourceKey.codec((ResourceKey)Registries.BANNER_PATTERN).listOf().xmap(ArrayList::new, Function.identity());
    public static final Codec<LoomTabListing> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(LoomTabListing::id), (App)DynamicUtil.getComponentCodec().optionalFieldOf("name").forGetter(LoomTabListing::name), (App)LegacyTabButton.ICON_HOLDER_CODEC.optionalFieldOf("icon").forGetter(LoomTabListing::iconHolder), (App)PATTERNS_CODEC.fieldOf("listing").orElseGet(ArrayList::new).forGetter(LoomTabListing::patterns)).apply((Applicative)i, LoomTabListing::new));
    public static final ResourceLocation SELECT_BANNER = Legacy4J.createModLocation("select_banner");

    @Override
    public boolean isValid() {
        return LegacyTabInfo.super.isValid() && !this.patterns.isEmpty() || this.is(SELECT_BANNER);
    }

    @Override
    public LoomTabListing copyFrom(LoomTabListing otherListing) {
        this.patterns.addAll(otherListing.patterns);
        return new LoomTabListing(this.id, otherListing.name.or(this::name), otherListing.iconHolder.or(this::iconHolder), this.patterns);
    }
}

