/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.NavigationElement;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.client.LegacySoundUtil;

public class LegacySlotWidget
extends LegacyIconHolder
implements NavigationElement {
    public final Slot slot;
    public int itemSeed;
    public String quickCraftText = null;
    public boolean quickCraftHighlight = false;
    public boolean isVisible = true;

    public LegacySlotWidget(Slot slot) {
        this.slot = slot;
    }

    @Override
    public void renderItem(GuiGraphics graphics, int i, int j, float f) {
        if (this.isHovered) {
            this.renderHighlight(graphics);
        }
        if (this.quickCraftHighlight) {
            this.renderHighlight(graphics);
        }
        super.renderItem(graphics, i, j, f);
    }

    @Override
    public void applyFocus(ComponentPath.Path path, boolean apply) {
        if (apply) {
            path.component().setFocused(null);
            if (Legacy4JClient.controllerManager.isControllerTheLastInput() && (Double)LegacyOptions.interfaceSensitivity.get() > 0.0) {
                ControllerBinding.LEFT_STICK.state().block();
            }
            Legacy4JClient.controllerManager.enableCursor();
            Legacy4JClient.controllerManager.setPointerPos(this.getMiddleX(), this.getMiddleY());
        }
    }

    @Override
    public void playFocusSound(ComponentPath.Path path) {
        if (((Boolean)LegacyOptions.inventoryHoverFocusSound.get()).booleanValue()) {
            LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
        }
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return this.isHovered;
    }

    @Override
    public boolean isMouseOver(double d, double e) {
        return false;
    }

    public boolean shouldTakeFocusAfterInteraction() {
        return false;
    }

    @Override
    public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
        return this.isVisible && !this.isHovered ? super.nextFocusPath(focusNavigationEvent) : null;
    }

    @Override
    public void renderItem(GuiGraphics graphics, ItemStack item, int x, int y, boolean isWarning) {
        if (!item.isEmpty()) {
            this.renderItem(graphics, () -> {
                graphics.renderItem(item, 0, 0, this.itemSeed);
                if (this.allowItemDecorations) {
                    graphics.renderItemDecorations(Minecraft.getInstance().font, item, 0, 0, this.quickCraftText);
                }
            }, x, y, isWarning);
        }
    }
}

