/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.block.entity.BaseContainerBlockEntityAccessor;

@Mixin(value={BaseContainerBlockEntity.class})
public class BaseContainerBlockEntityMixin
implements BaseContainerBlockEntityAccessor {
    @Unique
    Component tempName;

    @Override
    public Component getTempName() {
        return this.tempName;
    }

    @Override
    public void setTempName(Component component) {
        this.tempName = component;
    }

    @Inject(method={"loadAdditional"}, at={@At(value="RETURN")})
    private void loadAdditional(ValueInput input, CallbackInfo ci) {
        this.tempName = BlockEntity.parseCustomNameSafe((ValueInput)input, (String)"TempName");
    }

    @Inject(method={"saveAdditional"}, at={@At(value="RETURN")})
    private void saveAdditional(ValueOutput valueOutput, CallbackInfo ci) {
        valueOutput.storeNullable("TempName", ComponentSerialization.CODEC, (Object)this.tempName);
    }

    @Inject(method={"getName"}, at={@At(value="HEAD")}, cancellable=true)
    private void getName(CallbackInfoReturnable<Component> cir) {
        if (this.tempName != null) {
            cir.setReturnValue((Object)this.tempName);
        }
    }
}

