/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.util.ColorUtil;
import wily.legacy.client.LegacyActivationAnim;

@Mixin(value={ScreenEffectRenderer.class})
public abstract class ScreenEffectRendererMixin {
    @Unique
    private static int texRenderColor = -1;
    @Shadow
    private ItemStack itemActivationItem;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private MultiBufferSource bufferSource;

    @ModifyArg(method={"renderTex"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexConsumer;setColor(I)Lcom/mojang/blaze3d/vertex/VertexConsumer;"))
    private static int renderTex(int i) {
        return ColorUtil.mergeColors((int)texRenderColor, (int)i);
    }

    @ModifyArg(method={"renderScreenEffect"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ScreenEffectRenderer;renderTex(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"))
    private TextureAtlasSprite renderScreenEffect(TextureAtlasSprite f, PoseStack i, MultiBufferSource f1, @Local Pair<BlockState, BlockPos> pair) {
        BlockState state = (BlockState)pair.getLeft();
        List quads = Collections.emptyList();
        List parts = this.minecraft.getBlockRenderer().getBlockModelShaper().getBlockModel(state).collectParts(this.minecraft.player.getRandom());
        if (!parts.isEmpty()) {
            quads = ((BlockModelPart)parts.get(0)).getQuads(Direction.UP);
        }
        if (!quads.isEmpty()) {
            BakedQuad quad = (BakedQuad)quads.get(0);
            f = quad.sprite();
            texRenderColor = ColorUtil.withAlpha((int)this.minecraft.getBlockColors().getColor(state, (BlockAndTintGetter)this.minecraft.level, this.minecraft.player.blockPosition(), quad.tintIndex()), (float)1.0f);
        } else {
            texRenderColor = -1;
        }
        return f;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        if (this.itemActivationItem == null && LegacyActivationAnim.itemActivationRenderReplacement != null) {
            LegacyActivationAnim.itemActivationRenderReplacement = null;
        }
    }

    @Inject(method={"renderItemActivationAnimation"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/item/ItemStackRenderState;submit(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;III)V")}, cancellable=true)
    private void renderItemActivationAnimation(PoseStack poseStack, float f, SubmitNodeCollector submitNodeCollector, CallbackInfo ci) {
        if (LegacyActivationAnim.itemActivationRenderReplacement != null) {
            ci.cancel();
            LegacyActivationAnim.itemActivationRenderReplacement.render(poseStack, f, this.bufferSource);
            poseStack.popPose();
        }
    }
}

