/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.book;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.BookSignScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WritableBookContent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.BookPanel;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.util.LegacyComponents;

@Mixin(value={BookEditScreen.class})
public abstract class BookEditScreenMixin
extends Screen
implements Controller.Event,
ControlTooltip.Event {
    private static final Component EXIT_BOOK = Component.translatable((String)"legacy.menu.exit_book");
    private static final Component EXIT_BOOK_MESSAGE = Component.translatable((String)"legacy.menu.exit_book_message");
    @Shadow
    private PageButton forwardButton;
    @Shadow
    private PageButton backButton;
    @Shadow
    private int currentPage;
    @Shadow
    private MultiLineEditBox page;
    @Shadow
    private Component numberOfPages;
    @Unique
    private List<String> initialPages;
    @Shadow
    @Final
    private List<String> pages;
    @Shadow
    @Final
    private BookSignScreen signScreen;
    @Unique
    private final BookPanel panel = new BookPanel(this){

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return BookEditScreenMixin.this.page.isFocused() ? context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, ControlTooltip::getKeyboardAction) : null;
        }
    };

    protected BookEditScreenMixin(Component component) {
        super(component);
    }

    @Shadow
    protected abstract void pageBack();

    @Shadow
    protected abstract void pageForward();

    @Shadow
    protected abstract int getNumPages();

    @Shadow
    protected abstract void saveChanges();

    @Shadow
    protected abstract void updatePageContent();

    @Shadow
    protected abstract Component getPageNumberMessage();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initReturn(Player player, ItemStack itemStack, InteractionHand interactionHand, WritableBookContent writableBookContent, CallbackInfo ci) {
        this.initialPages = List.copyOf(this.pages);
    }

    public void added() {
        super.added();
        ControlTooltip.Renderer.of(this).add(() -> ControlType.getActiveType().isKbm() ? (this.getFocused() == this.panel ? null : ControlTooltip.CompoundComponentIcon.of(ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(263))) : ControllerBinding.LEFT_BUMPER.getIcon(), () -> this.currentPage != 0 ? LegacyComponents.PREVIOUS_PAGE : null).add(() -> ControlType.getActiveType().isKbm() ? (this.getFocused() == this.panel ? null : ControlTooltip.CompoundComponentIcon.of(ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(262))) : ControllerBinding.RIGHT_BUMPER.getIcon(), () -> this.currentPage < this.getNumPages() - 1 ? LegacyComponents.NEXT_PAGE : LegacyComponents.ADD_PAGE);
    }

    public void onClose() {
        if (!this.pages.equals(this.initialPages)) {
            this.minecraft.setScreen((Screen)new ConfirmationScreen((Screen)this, EXIT_BOOK, EXIT_BOOK_MESSAGE, b -> this.minecraft.setScreen(null)));
        } else {
            super.onClose();
        }
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.panel.init();
        this.addRenderableOnly((Renderable)this.panel);
        this.page = MultiLineEditBox.builder().setShowDecorations(false).setTextColor(-16777216).setCursorColor(-16777216).setShowBackground(false).setTextShadow(false).setX(this.panel.x + 20).setY(this.panel.y + 37).build(this.font, this.panel.getWidth() - 40, this.panel.getHeight() - 74, CommonComponents.EMPTY);
        this.page.setCharacterLimit(1024);
        MultiLineEditBox var10000 = this.page;
        Objects.requireNonNull(this.font);
        var10000.setLineLimit(14);
        this.page.setValueListener(string -> this.pages.set(this.currentPage, (String)string));
        this.addRenderableWidget((GuiEventListener)this.page);
        this.updatePageContent();
        this.numberOfPages = this.getPageNumberMessage();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"book.signButton"), button -> this.minecraft.setScreen((Screen)this.signScreen)).bounds(this.width / 2 - 108, this.panel.y + this.panel.height + 5, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.minecraft.setScreen(null);
            this.saveChanges();
        }).bounds(this.width / 2 + 8, this.panel.y + this.panel.height + 5, 100, 20).build());
        this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)this.panel.createLegacyPageButton(this.panel.x + this.panel.width - 62, this.panel.y + this.panel.height - 34, true, button -> this.pageForward(), true));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)this.panel.createLegacyPageButton(this.panel.x + 26, this.panel.y + this.panel.height - 34, false, button -> this.pageBack(), true));
    }

    @Inject(method={"renderBackground"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBackground(CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if ((state.is(ControllerBinding.RIGHT_BUMPER) || state.is(ControllerBinding.LEFT_BUMPER)) && state.canClick()) {
            (state.is(ControllerBinding.RIGHT_BUMPER) ? this.forwardButton : this.backButton).keyPressed(new KeyEvent(257, 0, 0));
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (keyEvent.hasShiftDown() && (keyEvent.isRight() || keyEvent.isLeft()) && this.getFocused() != this.panel) {
            (keyEvent.isRight() ? this.forwardButton : this.backButton).keyPressed(new KeyEvent(257, 0, 0));
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)super.keyPressed(keyEvent));
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIZ)V"), index=2)
    public int pageX(int x, @Local(ordinal=4) int pageWidth) {
        return this.panel.x + this.panel.width - 24 - pageWidth;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIZ)V"), index=3)
    public int pageY(int x) {
        return this.panel.y + 22;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

