/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;

public class GLFWControllerHandler
implements Controller.Handler {
    private boolean init = false;
    public static final class_2561 TITLE = class_2561.method_43470((String)"GLFW");
    private static final GLFWControllerHandler INSTANCE = new GLFWControllerHandler();

    @Override
    public class_2561 getName() {
        return TITLE;
    }

    public static GLFWControllerHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void init() {
        if (!this.init) {
            this.tryDownloadAndApplyNewMappings();
            this.init = true;
        }
    }

    @Override
    public boolean update() {
        return true;
    }

    @Override
    public Controller getController(final int jid) {
        return new Controller(){
            GLFWGamepadState gamepadState;
            String name;

            @Override
            public String getName() {
                if (this.name == null) {
                    this.name = GLFW.glfwGetGamepadName((int)jid);
                }
                return this.name == null ? "Unknown" : this.name;
            }

            @Override
            public ControlType getType() {
                String name = this.getName();
                if (name != null) {
                    if (name.contains("PS3")) {
                        return ControlType.PS3;
                    }
                    if (name.contains("PS4")) {
                        return ControlType.PS4;
                    }
                    if (name.contains("PS5")) {
                        return ControlType.PS5;
                    }
                    if (name.contains("Xbox 360")) {
                        return ControlType.x360;
                    }
                    if (name.contains("Xbox One")) {
                        return ControlType.xONE;
                    }
                    if (name.contains("Nintendo Switch")) {
                        return ControlType.SWITCH;
                    }
                    if (name.contains("Wii U")) {
                        return ControlType.WII_U;
                    }
                }
                return ControlType.x360;
            }

            @Override
            public boolean buttonPressed(int i) {
                return this.gamepadState != null && this.gamepadState.buttons(i) == 1;
            }

            @Override
            public float axisValue(int i) {
                float value = this.gamepadState == null ? 0.0f : this.gamepadState.axes(i);
                return switch (i) {
                    case 4, 5 -> (value + 1.0f) / 2.0f;
                    default -> value;
                };
            }

            @Override
            public boolean hasButton(ControllerBinding.Button button) {
                return GLFWControllerHandler.this.getButtonIndex(button) != -1;
            }

            @Override
            public boolean hasAxis(ControllerBinding.Axis axis) {
                return GLFWControllerHandler.this.getAxisIndex(axis) != -1;
            }

            @Override
            public void manageBindings(Runnable run) {
                this.gamepadState = GLFWGamepadState.calloc();
                if (GLFW.glfwGetGamepadState((int)jid, (GLFWGamepadState)this.gamepadState)) {
                    Controller.super.manageBindings(run);
                }
                this.gamepadState.free();
            }
        };
    }

    @Override
    public boolean isValidController(int jid) {
        return GLFW.glfwJoystickIsGamepad((int)jid);
    }

    @Override
    public int getButtonIndex(ControllerBinding.Button button) {
        return switch (button) {
            case ControllerBinding.Button.DOWN -> 0;
            case ControllerBinding.Button.RIGHT -> 1;
            case ControllerBinding.Button.LEFT -> 2;
            case ControllerBinding.Button.UP -> 3;
            case ControllerBinding.Button.BACK -> 6;
            case ControllerBinding.Button.GUIDE -> 8;
            case ControllerBinding.Button.START -> 7;
            case ControllerBinding.Button.LEFT_STICK -> 9;
            case ControllerBinding.Button.RIGHT_STICK -> 10;
            case ControllerBinding.Button.LEFT_BUMPER -> 4;
            case ControllerBinding.Button.RIGHT_BUMPER -> 5;
            case ControllerBinding.Button.DPAD_UP -> 11;
            case ControllerBinding.Button.DPAD_DOWN -> 13;
            case ControllerBinding.Button.DPAD_LEFT -> 14;
            case ControllerBinding.Button.DPAD_RIGHT -> 12;
            default -> -1;
        };
    }

    @Override
    public int getAxisIndex(ControllerBinding.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case ControllerBinding.Axis.LEFT_STICK_X -> 0;
            case ControllerBinding.Axis.LEFT_STICK_Y -> 1;
            case ControllerBinding.Axis.RIGHT_STICK_X -> 2;
            case ControllerBinding.Axis.RIGHT_STICK_Y -> 3;
            case ControllerBinding.Axis.LEFT_TRIGGER -> 4;
            case ControllerBinding.Axis.RIGHT_TRIGGER -> 5;
        };
    }

    @Override
    public void applyGamePadMappingsFromBuffer(BufferedReader reader) throws IOException {
        String s = reader.lines().collect(Collectors.joining());
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        ByteBuffer mappingsBuffer = ByteBuffer.allocateDirect(bytes.length + 1);
        mappingsBuffer.put(bytes);
        mappingsBuffer.rewind();
        GLFW.glfwUpdateGamepadMappings((ByteBuffer)mappingsBuffer);
        mappingsBuffer.clear();
        reader.close();
    }
}

