/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4013;
import net.minecraft.class_437;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.Legacy4J;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScreen;
import wily.legacy.client.screen.ScreenSection;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.util.JsonUtil;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.ScreenUtil;

public class HowToPlayScreen
extends LegacyScreen {
    protected final Section section;
    protected final int sectionIndex;
    protected final class_2960 uiDefinitionID;
    protected final ScrollableRenderer scrollableRenderer = new ScrollableRenderer();

    public HowToPlayScreen(class_437 parent, Section section) {
        super(parent, section.title());
        this.section = section;
        this.sectionIndex = Section.list.indexOf(section);
        this.uiDefinitionID = section.uiDefinitionLocation().method_45138("ui_definitions/").method_48331(".json");
    }

    public String toString() {
        return this.uiDefinitionID.toString();
    }

    public ScrollableRenderer getScrollableRenderer() {
        return (ScrollableRenderer)this.accessor.getElementValue("scrollable_renderer", (Object)this.scrollableRenderer, ScrollableRenderer.class);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.replace(1, i -> i, a -> this.hasNextPage() ? LegacyComponents.NEXT_PAGE : null).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> this.hasPreviousPage() ? LegacyComponents.PREVIOUS_PAGE : null);
    }

    protected void method_25426() {
        super.method_25426();
        this.accessor.putStaticElement("scrollable_renderer", (Object)this.scrollableRenderer);
    }

    protected boolean hasNextPage() {
        return this.sectionIndex < Section.list.size() - 1;
    }

    protected boolean hasPreviousPage() {
        return this.sectionIndex > 0;
    }

    public boolean method_25404(int i, int j, int k) {
        boolean next = i == 257;
        if (next && this.hasNextPage() || i == 88 && this.hasPreviousPage()) {
            ScreenUtil.playSimpleUISound((class_3414)class_3417.field_15015.comp_349(), 1.0f);
            this.field_22787.method_1507((class_437)Section.list.get(this.sectionIndex + (next ? 1 : -1)).build(this.parent));
            return true;
        }
        if (this.getScrollableRenderer().keyPressed(i)) {
            return true;
        }
        return super.method_25404(i, j, k);
    }

    public boolean method_25401(double d, double e, double f, double g) {
        if (this.getScrollableRenderer().mouseScrolled(g)) {
            return true;
        }
        return super.method_25401(d, e, f, g);
    }

    public record Section(class_2561 title, class_2960 uiDefinitionLocation, boolean hasButton, int index) implements ScreenSection<HowToPlayScreen>
    {
        public static final Codec<Section> CODEC = RecordCodecBuilder.create(i -> i.group((App)DynamicUtil.getComponentCodec().fieldOf("title").forGetter(Section::title), (App)class_2960.field_25139.fieldOf("ui_definition").forGetter(Section::uiDefinitionLocation), (App)Codec.BOOL.fieldOf("hasButton").orElse((Object)true).forGetter(Section::hasButton), (App)Codec.INT.fieldOf("index").orElse((Object)-1).forGetter(Section::index)).apply((Applicative)i, Section::new));
        public static final Codec<List<Section>> LIST_CODEC = CODEC.listOf();
        public static final List<Section> list = new ArrayList<Section>();

        public static Stream<Section> getWithButton() {
            return list.stream().filter(Section::hasButton);
        }

        @Override
        public HowToPlayScreen build(class_437 parent) {
            return new HowToPlayScreen(parent, this);
        }
    }

    public static class Manager
    implements class_4013 {
        public static final String HOW_TO_PLAY_SECTIONS = "how_to_play_sections.json";

        public void method_14491(class_3300 resourceManager) {
            Section.list.clear();
            JsonUtil.getOrderedNamespaces(resourceManager).forEach(name -> resourceManager.method_14486(FactoryAPI.createLocation((String)name, (String)HOW_TO_PLAY_SECTIONS)).ifPresent(r -> {
                try (BufferedReader bufferedReader = r.method_43039();){
                    Section.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)bufferedReader)).result().ifPresent(l -> l.forEach(s -> Section.list.add(s.index < 0 ? Section.list.size() : Math.min(s.index, Section.list.size()), (Section)s)));
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            }));
        }

        public String method_22322() {
            return "legacy:how_to_play_sections";
        }
    }
}

