/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import wily.factoryapi.base.Stocker;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.ScreenUtil;

public class TabList
implements class_4068,
class_364,
class_6379 {
    public final List<LegacyTabButton> tabButtons;
    public int selectedTab = 0;
    boolean focused = false;

    public TabList() {
        this(new ArrayList<LegacyTabButton>());
    }

    public TabList(List<LegacyTabButton> list) {
        this.tabButtons = list;
    }

    public LegacyTabButton addTabButton(LegacyTabButton button) {
        this.tabButtons.add(button);
        return button;
    }

    public LegacyTabButton addTabButton(int x, int y, int width, int height, int type, Function<LegacyTabButton, class_4068> icon, class_2561 message, class_7919 tooltip, Consumer<LegacyTabButton> onPress) {
        return this.addTabButton(new LegacyTabButton(x, y, width, height, type, icon, message, tooltip, t -> {
            int index = this.tabButtons.indexOf(t);
            if (this.selectedTab != index) {
                this.selectedTab = index;
                onPress.accept((LegacyTabButton)((Object)t));
            }
        }));
    }

    public LegacyTabButton addTabButton(int height, int type, Function<LegacyTabButton, class_4068> icon, class_2561 component, Consumer<LegacyTabButton> onPress) {
        return this.addTabButton(0, 0, 0, height, type, icon, component, null, onPress);
    }

    public TabList add(int x, int y, int width, int height, int type, Function<LegacyTabButton, class_4068> icon, class_2561 message, class_7919 tooltip, Consumer<LegacyTabButton> onPress) {
        this.addTabButton(x, y, width, height, type, icon, message, tooltip, onPress);
        return this;
    }

    public TabList add(int height, int type, Function<LegacyTabButton, class_4068> icon, class_2561 component, Consumer<LegacyTabButton> onPress) {
        return this.add(0, 0, 0, height, type, icon, component, null, onPress);
    }

    public TabList add(int x, int y, int width, int height, int type, class_2561 message, Consumer<LegacyTabButton> onPress) {
        return this.add(x, y, width, height, type, null, message, null, onPress);
    }

    public TabList add(int x, int y, int height, int type, class_2561 message, Consumer<LegacyTabButton> onPress) {
        return this.add(x, y, 0, height, type, null, message, null, onPress);
    }

    public TabList add(int height, int type, class_2561 message, Consumer<LegacyTabButton> onPress) {
        return this.add(0, 0, 0, height, type, null, message, null, onPress);
    }

    public void init(int leftPos, int topPos, int width) {
        this.init(leftPos, topPos, width, (t, i) -> {});
    }

    public void init(int leftPos, int topPos, int width, BiConsumer<LegacyTabButton, Integer> buttonManager) {
        this.init((b, i) -> {
            b.method_25358(width / this.tabButtons.size());
            b.method_46421(leftPos + i);
            b.method_46419(topPos);
            buttonManager.accept((LegacyTabButton)((Object)b), (Integer)i);
        }, false);
    }

    public void init(BiConsumer<LegacyTabButton, Integer> buttonManager, boolean vertical) {
        int position = 0;
        for (LegacyTabButton b : this.tabButtons) {
            buttonManager.accept(b, position);
            position += vertical ? b.method_25364() : b.method_25368();
        }
    }

    public void method_25394(class_332 graphics, int i, int j, float f) {
        for (int index = 0; index < this.tabButtons.size(); ++index) {
            LegacyTabButton tabButton = this.tabButtons.get(index);
            tabButton.selected = this.selectedTab == index;
            tabButton.method_25394(graphics, i, j, f);
        }
    }

    public void resetSelectedTab() {
        if (!this.tabButtons.isEmpty()) {
            this.selectedTab = -1;
            this.tabButtons.get(0).method_25306();
        }
    }

    public void method_25365(boolean bl) {
        this.focused = bl;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public boolean method_25404(int i, int j, int k) {
        return this.tabButtons.stream().anyMatch(t -> t.method_25367() && t.method_25404(i, j, k));
    }

    public boolean controlTab(int i) {
        return this.controlTab(i, 91, 93);
    }

    public boolean directionalControlTab(int i) {
        return this.controlTab(i, 263, 262);
    }

    public boolean controlTab(int i, int leftButton, int rightButton) {
        return this.controlTab(i == leftButton, i == rightButton);
    }

    public boolean controlTab(boolean left, boolean right) {
        if (!left && !right || this.tabButtons.isEmpty()) {
            return false;
        }
        Optional<LegacyTabButton> opt = this.tabButtons.stream().filter(class_339::method_37303).min(Comparator.comparingInt(t -> {
            int diff = this.tabButtons.indexOf(t) - this.selectedTab;
            return left ? (diff < 0 ? -diff : this.tabButtons.size() * 2 - diff) : (diff > 0 ? diff : this.tabButtons.size() * 2 + diff);
        }));
        if (opt.isPresent() && this.tabButtons.indexOf((Object)opt.get()) != this.selectedTab) {
            opt.get().method_25306();
            ScreenUtil.playSimpleUISound((class_3414)LegacyRegistries.FOCUS.get(), true);
            return true;
        }
        return false;
    }

    protected boolean controlPage(Stocker.Sizeable page, boolean left, boolean right) {
        if ((left || right) && page.max > 0) {
            int lastPage = (Integer)page.get();
            page.add(left ? -1 : 1);
            if (lastPage != (Integer)page.get()) {
                this.resetSelectedTab();
                return true;
            }
        }
        return false;
    }

    public void numberControlTab(int i) {
        if (i <= 57 && i > 48 && i - 49 < this.tabButtons.size()) {
            this.tabButtons.get(i - 49).method_25306();
            ScreenUtil.playSimpleUISound((class_3414)LegacyRegistries.FOCUS.get(), true);
        }
    }

    public boolean method_25402(double d, double e, int i) {
        return !this.tabButtons.stream().filter(t -> t.method_25402(d, e, i)).toList().isEmpty();
    }

    public boolean method_25405(double d, double e) {
        return !this.tabButtons.stream().filter(t -> t.method_25405(d, e)).toList().isEmpty();
    }

    public class_6379.class_6380 method_37018() {
        return this.tabButtons.stream().map(class_339::method_37018).max(Comparator.naturalOrder()).orElse(class_6379.class_6380.field_33784);
    }

    public void method_37020(class_6382 narrationElementOutput) {
        Optional<LegacyTabButton> optional = this.tabButtons.stream().filter(class_339::method_49606).findFirst().or(() -> Optional.ofNullable(this.tabButtons.get(this.selectedTab)));
        optional.ifPresent(tabButton -> {
            narrationElementOutput.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.tab", (Object[])new Object[]{this.selectedTab + 1, this.tabButtons.size()}));
            tabButton.method_37020(narrationElementOutput);
        });
        if (this.method_25370()) {
            narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.tab_navigation.usage"));
        }
    }

    public static interface Access {
        public TabList getTabList();
    }
}

