/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.network;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2186;
import net.minecraft.class_2287;
import net.minecraft.class_2321;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.config.LegacyWorldOptions;
import wily.legacy.util.LegacyTipBuilder;

public class TipCommand {
    public static final SuggestionProvider<class_2168> TIP_PROVIDER = (c, builder) -> {
        ((Map)LegacyWorldOptions.customTips.get()).keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> commandDispatcher, class_7157 commandBuildContext, class_2170.class_5364 environment) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"legacyTip").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(class_2170.method_9247((String)"item").then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)commandBuildContext)).then(class_2170.method_9247((String)"display").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(commandContext -> TipCommand.sendTip((CommandContext<class_2168>)commandContext, new Payload(new LegacyTipBuilder().itemIcon(class_2287.method_9777((CommandContext)commandContext, (String)"item").method_9781(1, true)))))).then(class_2170.method_9244((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> TipCommand.sendTip((CommandContext<class_2168>)commandContext, new Payload(new LegacyTipBuilder().itemIcon(class_2287.method_9777((CommandContext)commandContext, (String)"item").method_9781(1, true)), BoolArgumentType.getBool((CommandContext)commandContext, (String)"force")))))))))).then(class_2170.method_9247((String)"entity").then(class_2170.method_9244((String)"entity", (ArgumentType)class_7733.method_45603((class_7157)commandBuildContext, (class_5321)class_7924.field_41266)).suggests(class_2321.field_10935).then(class_2170.method_9247((String)"display").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(commandContext -> TipCommand.sendTip((CommandContext<class_2168>)commandContext, new EntityPayload((class_1299)class_7733.method_45610((CommandContext)commandContext, (String)"entity").comp_349(), false)))).then(class_2170.method_9244((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> TipCommand.sendTip((CommandContext<class_2168>)commandContext, new EntityPayload((class_1299)class_7733.method_45610((CommandContext)commandContext, (String)"entity").comp_349(), BoolArgumentType.getBool((CommandContext)commandContext, (String)"force")))))))))).then(class_2170.method_9247((String)"custom").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"custom_tip", (ArgumentType)StringArgumentType.string()).suggests(TIP_PROVIDER).then(class_2170.method_9247((String)"add").executes(TipCommand::addCustomTip))).then(class_2170.method_9247((String)"remove").executes(c -> TipCommand.handleCustomTipPresence((CommandContext<class_2168>)c, ((Map)LegacyWorldOptions.customTips.get())::remove, "legacy.commands.legacyTip.success.remove")))).then(class_2170.method_9247((String)"reset").executes(c -> TipCommand.handleCustomTipPresence((CommandContext<class_2168>)c, s -> ((Map)LegacyWorldOptions.customTips.get()).put(s, new LegacyTipBuilder()), "legacy.commands.legacyTip.success.reset")))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"modify").then(class_2170.method_9247((String)"item").then(class_2170.method_9244((String)"item", (ArgumentType)class_2287.method_9776((class_7157)commandBuildContext)).executes(c -> TipCommand.modifyCustomTip((CommandContext<class_2168>)c, t -> t.itemIcon(class_2287.method_9777((CommandContext)c, (String)"item").method_9781(1, false))))))).then(class_2170.method_9247((String)"tip").then(class_2170.method_9244((String)"tip", (ArgumentType)class_2178.method_9281()).executes(c -> TipCommand.modifyCustomTip((CommandContext<class_2168>)c, t -> t.tip(class_2178.method_9280((CommandContext)c, (String)"tip"))))))).then(class_2170.method_9247((String)"title").then(class_2170.method_9244((String)"title", (ArgumentType)class_2178.method_9281()).executes(c -> TipCommand.modifyCustomTip((CommandContext<class_2168>)c, t -> t.title(class_2178.method_9280((CommandContext)c, (String)"title"))))))).then(class_2170.method_9247((String)"time").then(class_2170.method_9244((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> TipCommand.modifyCustomTip((CommandContext<class_2168>)c, t -> t.disappearTime(IntegerArgumentType.getInteger((CommandContext)c, (String)"seconds")))))))).then(class_2170.method_9247((String)"display").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(commandContext -> TipCommand.handleCustomTipPresence((CommandContext<class_2168>)commandContext, s -> TipCommand.sendTip((CommandContext<class_2168>)commandContext, new Payload((LegacyTipBuilder)((Map)LegacyWorldOptions.customTips.get()).get(s)))))).then(class_2170.method_9244((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> TipCommand.handleCustomTipPresence((CommandContext<class_2168>)commandContext, s -> TipCommand.sendTip((CommandContext<class_2168>)commandContext, new Payload((LegacyTipBuilder)((Map)LegacyWorldOptions.customTips.get()).get(s), BoolArgumentType.getBool((CommandContext)commandContext, (String)"force")))))))))));
    }

    private static <T extends CommonNetwork.Payload> int sendTip(CommandContext<class_2168> context, T packet) throws CommandSyntaxException {
        Collection players = class_2186.method_9310(context, (String)"targets");
        CommonNetwork.sendToPlayers((Collection)players, packet);
        return players.size();
    }

    private static int addCustomTip(CommandContext<class_2168> context) {
        return TipCommand.handleCustomTip(context, s -> ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"legacy.commands.legacyTip.invalidName", (Object[])new Object[]{s})), s -> {
            ((Map)LegacyWorldOptions.customTips.get()).put(s, new LegacyTipBuilder());
            LegacyWorldOptions.customTips.save();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"legacy.commands.legacyTip.success.add", (Object[])new Object[]{s}), true);
        });
    }

    private static int handleCustomTipPresence(CommandContext<class_2168> context, CommandConsumer<String> consumer) {
        return TipCommand.handleCustomTip(context, consumer, s -> ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"legacy.commands.legacyTip.incorrectName", (Object[])new Object[]{s})));
    }

    private static int handleCustomTipPresence(CommandContext<class_2168> context, CommandConsumer<String> modifier, String successKey) {
        return TipCommand.handleCustomTipPresence(context, s -> {
            modifier.accept((String)s);
            LegacyWorldOptions.customTips.save();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)successKey, (Object[])new Object[]{s}), true);
        });
    }

    private static int modifyCustomTip(CommandContext<class_2168> context, CommandConsumer<LegacyTipBuilder> modifier) {
        return TipCommand.handleCustomTip(context, s -> {
            modifier.accept((LegacyTipBuilder)((Map)LegacyWorldOptions.customTips.get()).get(s));
            LegacyWorldOptions.customTips.save();
        }, s -> ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"legacy.commands.legacyTip.incorrectName", (Object[])new Object[]{s})));
    }

    private static int handleCustomTip(CommandContext<class_2168> context, CommandConsumer<String> presence, CommandConsumer<String> absence) {
        String tip = StringArgumentType.getString(context, (String)"custom_tip");
        if (((Map)LegacyWorldOptions.customTips.get()).containsKey(tip)) {
            presence.accept(tip);
        } else {
            absence.accept(tip);
        }
        return 1;
    }

    static interface CommandConsumer<T>
    extends Consumer<T> {
        @Override
        default public void accept(T t) {
            try {
                this.acceptExceptionally(t);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public void acceptExceptionally(T var1) throws CommandSyntaxException;
    }

    public record Payload(LegacyTipBuilder builder, boolean force) implements CommonNetwork.Payload
    {
        public static final CommonNetwork.Identifier<Payload> ID = CommonNetwork.Identifier.create((class_2960)Legacy4J.createModLocation("send_tip"), Payload::decode);

        public Payload(LegacyTipBuilder builder) {
            this(builder, false);
        }

        public static Payload decode(CommonNetwork.PlayBuf buf) {
            return new Payload(LegacyTipBuilder.decode(buf), ((class_2540)buf.get()).readBoolean());
        }

        public void encode(CommonNetwork.PlayBuf buf) {
            this.builder.encode(buf);
            ((class_2540)buf.get()).method_52964(this.force);
        }

        public void apply(CommonNetwork.SecureExecutor executor, Supplier<class_1657> player) {
            if (player.get().method_37908().field_9236) {
                if (this.force) {
                    LegacyTipManager.setTip(LegacyTipManager.getTip(this.builder.getItem(), this.builder));
                } else {
                    LegacyTipManager.addTip(LegacyTipManager.getTip(this.builder.getItem(), this.builder));
                }
            }
        }

        public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
            return ID;
        }
    }

    public record EntityPayload(class_1299<?> entityType, boolean force) implements CommonNetwork.Payload
    {
        public static final CommonNetwork.Identifier<EntityPayload> ID = CommonNetwork.Identifier.create((class_2960)Legacy4J.createModLocation("send_entity_tip"), EntityPayload::new);

        public EntityPayload(CommonNetwork.PlayBuf buf) {
            this((class_1299)FactoryAPIPlatform.getRegistryValue((class_2960)((class_2540)buf.get()).method_10810(), (class_2378)class_7923.field_41177), ((class_2540)buf.get()).readBoolean());
        }

        public void encode(CommonNetwork.PlayBuf buf) {
            ((class_2540)buf.get()).method_10812(class_7923.field_41177.method_10221(this.entityType));
            ((class_2540)buf.get()).method_52964(this.force);
        }

        public void apply(CommonNetwork.SecureExecutor executor, Supplier<class_1657> player) {
            if (player.get().method_37908().field_9236) {
                if (this.force) {
                    LegacyTipManager.setTip(LegacyTipManager.getTip(this.entityType));
                } else {
                    LegacyTipManager.addTip(this.entityType);
                }
            }
        }

        public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
            return ID;
        }
    }
}

