/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.util.DynamicUtil;

public class JsonUtil {
    public static <T> Predicate<T> registryMatches(class_2378<T> registry, JsonObject o) {
        JsonPrimitive j;
        JsonElement jsonElement;
        String name = registry.method_30517().method_29177().method_12832();
        if (!o.has(name) && !o.has(name + "s")) {
            return t -> false;
        }
        ArrayList<Object> tip = new ArrayList<Object>();
        ArrayList tipExclusions = new ArrayList();
        ArrayList<class_6862> tipTags = new ArrayList<class_6862>();
        if (o.has(name) && (jsonElement = o.get(name)) instanceof JsonPrimitive && (j = (JsonPrimitive)jsonElement).isString()) {
            String s = j.getAsString();
            if (s.startsWith("#")) {
                tipTags.add(class_6862.method_40092((class_5321)registry.method_30517(), (class_2960)FactoryAPI.createLocation((String)s.replaceFirst("#", ""))));
            } else {
                tip.add(FactoryAPIPlatform.getRegistryValue((class_2960)FactoryAPI.createLocation((String)s), registry));
            }
        }
        if (o.has(name + "s") && (jsonElement = o.get(name + "s")) instanceof JsonArray) {
            JsonArray a = (JsonArray)jsonElement;
            a.forEach(ie -> {
                JsonPrimitive p;
                if (ie instanceof JsonPrimitive && (p = (JsonPrimitive)ie).isString()) {
                    String s = p.getAsString();
                    if (s.startsWith("#")) {
                        tipTags.add(class_6862.method_40092((class_5321)registry.method_30517(), (class_2960)FactoryAPI.createLocation((String)s.replaceFirst("#", ""))));
                    } else if (s.startsWith("!")) {
                        class_2960 l = FactoryAPI.createLocation((String)s.replaceFirst("!", ""));
                        registry.method_17966(l).ifPresent(tipExclusions::add);
                    } else {
                        tip.add(FactoryAPIPlatform.getRegistryValue((class_2960)FactoryAPI.createLocation((String)s), (class_2378)registry));
                    }
                }
            });
        }
        return t -> {
            if (tipExclusions.contains(t)) return false;
            if (tip.contains(t)) return true;
            if (!tipTags.stream().anyMatch(arg_0 -> ((class_6880.class_6883)registry.method_40290((class_5321)registry.method_29113(t).orElseThrow())).method_40220(arg_0))) return false;
            return true;
        };
    }

    public static BiPredicate<class_1792, class_2487> registryMatchesItem(JsonObject o) {
        class_2487 data = o.has("nbt") ? (class_2487)class_2487.field_25128.parse((DynamicOps)JsonOps.INSTANCE, (Object)o.get("nbt")).result().orElse(null) : null;
        Predicate p = JsonUtil.registryMatches(class_7923.field_41178, o);
        return (item, d) -> p.test(item) && (data == null || class_2512.method_10687((class_2520)data, (class_2520)d, (boolean)true));
    }

    public static ArbitrarySupplier<class_1799> getItemFromJson(JsonElement element, boolean allowData) {
        return DynamicUtil.getItemFromDynamic((Dynamic)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)element), (boolean)allowData);
    }

    public static <K, V> void addMapListEntry(Map<K, List<V>> map, K key, V entry) {
        map.computeIfAbsent(key, k -> new ArrayList()).add(entry);
    }

    public static <T> T getJsonStringOrNull(JsonObject object, String element, Function<String, T> constructor) {
        String s = class_3518.method_15253((JsonObject)object, (String)element, null);
        return s == null ? null : (T)constructor.apply(s);
    }

    public static <T> void ifJsonStringNotNull(JsonObject object, String element, Function<String, T> constructor, Consumer<T> consumer) {
        T obj = JsonUtil.getJsonStringOrNull(object, element, constructor);
        if (obj != null) {
            consumer.accept(obj);
        }
    }

    public static Stream<String> getOrderedNamespaces(class_3300 manager) {
        return manager.method_14487().stream().sorted(Comparator.comparingInt(s -> s.equals("legacy") ? 0 : 1));
    }

    public static Integer optionalJsonColor(JsonObject object, String element, Integer fallback) {
        return JsonUtil.optionalJsonColor(object.get(element), fallback);
    }

    public static Integer optionalJsonColor(JsonElement element, Integer fallback) {
        if (element instanceof JsonPrimitive) {
            JsonPrimitive p = (JsonPrimitive)element;
            if (p.isString() && p.getAsString().startsWith("#")) {
                return (int)Long.parseLong(p.getAsString().substring(1), 16);
            }
            return p.getAsInt();
        }
        return fallback;
    }
}

