/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.client.LegacyBiomeOverride;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.WorldMoreOptionsScreen;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyBuffetWorldScreen
extends PanelVListScreen {
    private final Consumer<Holder<Biome>> applySettings;
    protected Holder<Biome> selectedBiome;

    public LegacyBuffetWorldScreen(CreateWorldScreen screen, HolderLookup.RegistryLookup<Biome> biomeGetter, Consumer<Holder<Biome>> consumer) {
        super((Screen)screen, (Screen s) -> Panel.centered(s, () -> 282, () -> Math.min(248, s.f_96544_)), (Component)Component.m_237115_((String)"createWorld.customize.buffet.title"));
        Object object;
        Screen screen2 = Minecraft.m_91087_().f_91080_;
        if (screen2 instanceof WorldMoreOptionsScreen) {
            WorldMoreOptionsScreen s2 = (WorldMoreOptionsScreen)screen2;
            object = s2;
        } else {
            object = screen;
        }
        this.parent = object;
        this.renderableVList.layoutSpacing(l -> 0);
        this.applySettings = consumer;
        biomeGetter.m_214062_().forEach(this::addBiome);
    }

    public void addBiome(final Holder.Reference<Biome> biome) {
        this.renderableVList.addRenderable((Renderable)new AbstractButton(0, 0, 260, 30, (Component)Component.m_237115_((String)("biome." + biome.m_205785_().m_135782_().m_214298_()))){

            public void m_5691_() {
                LegacyBuffetWorldScreen.this.selectedBiome = biome;
            }

            protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
                super.m_87963_(guiGraphics, i, j, f);
                ItemStack s = LegacyBiomeOverride.getOrDefault(biome.m_203543_()).icon();
                if (!s.m_41619_()) {
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_252880_((float)(this.m_252754_() + 26), (float)(this.m_252907_() + 5), 0.0f);
                    guiGraphics.m_280168_().m_85841_(1.25f, 1.25f, 1.25f);
                    guiGraphics.m_280480_(s, 0, 0);
                    guiGraphics.m_280168_().m_85849_();
                }
                RenderSystem.enableBlend();
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(TickBox.SPRITES[this.m_198029_() ? 1 : 0], this.m_252754_() + 6, this.m_252907_() + (this.f_93619_ - 12) / 2, 12, 12);
                if (LegacyBuffetWorldScreen.this.selectedBiome == biome) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(TickBox.TICK, this.m_252754_() + 6, this.m_252907_() + (this.f_93619_ - 12) / 2, 14, 12);
                }
                RenderSystem.disableBlend();
            }

            protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
                int k = this.m_252754_() + 54;
                int l = this.m_252754_() + this.m_5711_();
                ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), k, this.m_252907_(), l, this.m_252907_() + this.m_93694_(), j, true);
            }

            protected void m_168797_(NarrationElementOutput narrationElementOutput) {
                this.m_168802_(narrationElementOutput);
            }
        });
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.m_169394_((guiGraphics, i, j, f) -> FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 7, this.panel.y + 7, this.panel.width - 14, this.panel.height - 14));
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 11, this.panel.y + 11, 260, this.panel.height - 25);
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        if (this.selectedBiome != null) {
            this.applySettings.accept(this.selectedBiome);
        }
    }
}

