/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.entity;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;

public class BabyVillagerFollowIronGolemBehavior
extends Behavior<Villager> {
    private IronGolem ironGolem;
    private boolean tookGolemRose;
    private int takeGolemRoseTick;

    public BabyVillagerFollowIronGolemBehavior() {
        super((Map)ImmutableMap.of(), 60, 160);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Villager villager) {
        if (villager.m_146764_() >= 0) {
            return false;
        }
        if (!serverLevel.m_46461_()) {
            return false;
        }
        List list = serverLevel.m_45976_(IronGolem.class, villager.m_20191_().m_82377_(6.0, 2.0, 6.0));
        if (list.isEmpty()) {
            return false;
        }
        for (IronGolem ironGolem : list) {
            if (ironGolem.m_28875_() <= 0) continue;
            this.ironGolem = ironGolem;
            break;
        }
        return this.ironGolem != null;
    }

    protected boolean canStillUse(ServerLevel serverLevel, Villager livingEntity, long l) {
        return this.ironGolem.m_28875_() > 0;
    }

    protected void start(ServerLevel serverLevel, Villager livingEntity, long l) {
        this.takeGolemRoseTick = serverLevel.f_46441_.m_188503_(320);
        this.tookGolemRose = false;
        livingEntity.m_21573_().m_26573_();
    }

    protected void stop(ServerLevel serverLevel, Villager livingEntity, long l) {
        this.ironGolem = null;
        livingEntity.m_21573_().m_26573_();
    }

    protected void tick(ServerLevel serverLevel, Villager livingEntity, long l) {
        livingEntity.m_21563_().m_24960_((Entity)this.ironGolem, 30.0f, 30.0f);
        if (this.ironGolem.m_28875_() == this.takeGolemRoseTick) {
            livingEntity.m_21573_().m_5624_((Entity)this.ironGolem, 0.5);
            this.tookGolemRose = true;
        }
        if (this.tookGolemRose && (double)livingEntity.m_20270_((Entity)this.ironGolem) < 4.0) {
            this.ironGolem.m_28885_(false);
            livingEntity.m_21573_().m_26573_();
        }
    }
}

