/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.entity;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.mixin.base.ClientBoundAwardStatsPacketAccessor;

public interface LegacyPlayerInfo {
    public static LegacyPlayerInfo of(Object obj) {
        return (LegacyPlayerInfo)obj;
    }

    default public GameProfile legacyMinecraft$getProfile() {
        return null;
    }

    public int getIdentifierIndex();

    public void setIdentifierIndex(int var1);

    public boolean isVisible();

    public void setVisibility(boolean var1);

    public boolean isExhaustionDisabled();

    public void setDisableExhaustion(boolean var1);

    public boolean mayFlySurvival();

    public void setMayFlySurvival(boolean var1);

    public static void updateMayFlySurvival(ServerPlayer player, boolean mayFlySurvival, boolean updateAbilities) {
        LegacyPlayerInfo.of(player).setMayFlySurvival(mayFlySurvival);
        if (player.m_150110_().f_35936_ != mayFlySurvival && player.f_8941_.m_9294_()) {
            player.m_150110_().f_35936_ = mayFlySurvival;
            if (!player.m_150110_().f_35936_ && player.m_150110_().f_35935_) {
                player.m_150110_().f_35935_ = false;
            }
            if (updateAbilities) {
                player.m_6885_();
            }
        }
    }

    public Object2IntMap<Stat<?>> getStatsMap();

    public void setStatsMap(Object2IntMap<Stat<?>> var1);

    public static LegacyPlayerInfo decode(CommonNetwork.PlayBuf buf) {
        return new Instance(((FriendlyByteBuf)buf.get()).m_130242_(), ((FriendlyByteBuf)buf.get()).readBoolean(), ((FriendlyByteBuf)buf.get()).readBoolean(), ((FriendlyByteBuf)buf.get()).readBoolean(), (Object2IntMap)((FriendlyByteBuf)buf.get()).m_236841_(Object2IntOpenHashMap::new, b -> ClientBoundAwardStatsPacketAccessor.decodeStatCap(b, (StatType)BuiltInRegistries.f_256899_.m_7942_(b.m_130242_())), FriendlyByteBuf::m_130242_));
    }

    public static void encode(CommonNetwork.PlayBuf buf, LegacyPlayerInfo info) {
        ((FriendlyByteBuf)buf.get()).m_130130_(info.getIdentifierIndex());
        ((FriendlyByteBuf)buf.get()).writeBoolean(info.isVisible());
        ((FriendlyByteBuf)buf.get()).writeBoolean(info.isExhaustionDisabled());
        ((FriendlyByteBuf)buf.get()).writeBoolean(info.mayFlySurvival());
        ((FriendlyByteBuf)buf.get()).m_236831_(info.getStatsMap(), ClientBoundAwardStatsPacketAccessor::encodeStatCap, FriendlyByteBuf::m_130130_);
    }

    default public void copyFrom(LegacyPlayerInfo info) {
        this.setIdentifierIndex(info.getIdentifierIndex());
        this.setVisibility(info.isVisible());
        this.setDisableExhaustion(info.isExhaustionDisabled());
        this.setMayFlySurvival(info.mayFlySurvival());
        this.setStatsMap(info.getStatsMap());
    }

    public static class Instance
    implements LegacyPlayerInfo {
        int index = -1;
        boolean visibility = true;
        boolean disableExhaustion;
        boolean mayFlySurvival = false;
        Object2IntMap<Stat<?>> statsMap;

        public Instance(int index, boolean invisible, boolean disableExhaustion, boolean mayFlySurvival, Object2IntMap<Stat<?>> object2IntMap) {
            this.setIdentifierIndex(index);
            this.setVisibility(invisible);
            this.setDisableExhaustion(disableExhaustion);
            this.setMayFlySurvival(mayFlySurvival);
            this.setStatsMap(object2IntMap);
        }

        @Override
        public int getIdentifierIndex() {
            return this.index;
        }

        @Override
        public void setIdentifierIndex(int i) {
            this.index = i;
        }

        @Override
        public boolean isVisible() {
            return this.visibility;
        }

        @Override
        public void setVisibility(boolean visible) {
            this.visibility = visible;
        }

        @Override
        public boolean isExhaustionDisabled() {
            return this.disableExhaustion;
        }

        @Override
        public void setDisableExhaustion(boolean exhaustion) {
            this.disableExhaustion = exhaustion;
        }

        @Override
        public boolean mayFlySurvival() {
            return this.mayFlySurvival;
        }

        @Override
        public void setMayFlySurvival(boolean mayFly) {
            this.mayFlySurvival = mayFly;
        }

        @Override
        public Object2IntMap<Stat<?>> getStatsMap() {
            return this.statsMap;
        }

        @Override
        public void setStatsMap(Object2IntMap<Stat<?>> statsMap) {
            this.statsMap = statsMap;
        }
    }
}

