/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.inventory;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.ClientSideMerchant;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import wily.factoryapi.base.StackIngredient;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.network.ServerMenuCraftPayload;

public class LegacyMerchantMenu
extends LegacyCraftingMenu {
    public final Merchant merchant;
    public int merchantLevel;
    public boolean showProgressBar;

    public LegacyMerchantMenu(int i, Inventory inventory) {
        this(i, inventory, (Merchant)new ClientSideMerchant(inventory.f_35978_));
    }

    public LegacyMerchantMenu(int i, Inventory inventory, Merchant merchant) {
        super((MenuType)LegacyRegistries.MERCHANT_MENU.get(), i, (Player p) -> merchant.m_7962_() == p);
        this.addInventorySlotGrid((Container)inventory, 9, 133, 98, 3);
        this.addInventorySlotGrid((Container)inventory, 0, 133, 154, 1);
        this.merchant = merchant;
    }

    public static List<Optional<Ingredient>> ingredientsFromStacks(ItemStack ... s) {
        return Arrays.stream(s).map(i -> i.m_41619_() ? Optional.empty() : Optional.of(StackIngredient.of((boolean)true, (ItemStack)i))).toList();
    }

    @Override
    public boolean canCraft(List<Optional<Ingredient>> ingredients, Player player, ServerMenuCraftPayload packet) {
        return packet.button() >= 0 && packet.button() < this.merchant.m_6616_().size() && !this.merchant.m_6616_().isEmpty() && !((MerchantOffer)this.merchant.m_6616_().get(packet.button())).m_45380_() && super.canCraft(ingredients, player, packet);
    }

    @Override
    public void onCraft(Player player, ServerMenuCraftPayload packet, ItemStack result) {
        int n;
        super.onCraft(player, packet, result);
        MerchantOffer offer = (MerchantOffer)this.merchant.m_6616_().get(packet.button());
        offer.m_45368_().m_41678_(player.m_9236_(), player, offer.m_45368_().m_41613_());
        Merchant merchant = this.merchant;
        if (merchant instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)merchant;
            e.m_5496_(this.merchant.m_7596_(), 1.0f, e.m_6100_());
        }
        this.merchant.m_6996_(offer);
        player.m_36220_(Stats.f_12941_);
        this.merchant.m_6621_(this.merchant.m_7809_() + offer.m_45379_());
        MerchantOffers merchantOffers = this.merchant.m_6616_();
        merchant = this.merchant;
        if (merchant instanceof Villager) {
            Villager v = (Villager)merchant;
            n = v.m_7141_().m_35576_();
        } else {
            n = 0;
        }
        player.m_7662_(this.f_38840_, merchantOffers, n, this.merchant.m_7809_(), this.merchant.m_7826_(), this.merchant.m_7862_());
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.merchant.m_7189_(null);
    }

    @Override
    public ItemStack getResult(Player player, ServerMenuCraftPayload packet) {
        if (player instanceof ServerPlayer && packet.button() >= 0 && packet.button() < this.merchant.m_6616_().size() && !this.merchant.m_6616_().isEmpty()) {
            return ((MerchantOffer)this.merchant.m_6616_().get(packet.button())).m_45368_();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public List<Optional<Ingredient>> getIngredients(Player player, ServerMenuCraftPayload packet) {
        if (player instanceof ServerPlayer && packet.button() >= 0 && packet.button() < this.merchant.m_6616_().size() && !this.merchant.m_6616_().isEmpty()) {
            return LegacyMerchantMenu.ingredientsFromStacks(((MerchantOffer)this.merchant.m_6616_().get(packet.button())).m_45358_(), ((MerchantOffer)this.merchant.m_6616_().get(packet.button())).m_45364_());
        }
        return super.getIngredients(player, packet);
    }
}

