/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.util.LegacyComponents;

@Mixin(value={EntityType.class})
public abstract class EntityTypeMixin {
    @Unique
    boolean wasLastEnemySpawnFailed = false;

    /*
     * Enabled aggressive block sorting
     */
    @Inject(method={"create(Lnet/minecraft/world/level/Level;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="RETURN")}, cancellable=true)
    public void create(Level level, CallbackInfoReturnable<Entity> cir) {
        Entity entity = (Entity)cir.getReturnValue();
        if (entity instanceof Mob) {
            Mob m = (Mob)entity;
            if (level.m_46791_() == Difficulty.PEACEFUL && m.m_8028_()) {
                cir.setReturnValue(null);
                this.wasLastEnemySpawnFailed = true;
                return;
            }
        }
        this.wasLastEnemySpawnFailed = false;
    }

    @Inject(method={"spawn(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/MobSpawnType;ZZ)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="RETURN")})
    public void spawn(ServerLevel arg, ItemStack arg2, Player arg3, BlockPos arg4, MobSpawnType arg5, boolean bl, boolean bl2, CallbackInfoReturnable<Entity> cir) {
        if (arg5 == MobSpawnType.SPAWN_EGG && this.wasLastEnemySpawnFailed && cir.getReturnValue() == null && arg3 != null) {
            arg3.m_5661_(LegacyComponents.PEACEFUL_SPAWN_TIP, true);
        }
    }
}

