/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.base.client.AdvancedTextWidget;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class LegacyTip
extends SimpleLayoutRenderable
implements Toast,
Controller.Event {
    protected final AdvancedTextWidget tipLabel = new AdvancedTextWidget(FactoryScreenUtil.getGuiAccessor());
    public Toast.Visibility visibility = Toast.Visibility.SHOW;
    public Component title = null;
    public long disappearTime = -1L;
    public long createdTime = Util.getMillis();
    public Supplier<Boolean> canRemove = () -> false;
    public LegacyIconHolder holder = null;
    protected boolean centered = false;
    protected boolean compactMode;
    protected Minecraft minecraft = Minecraft.getInstance();
    protected Screen initScreen;

    public LegacyTip(Component tip, int width, int height, boolean compactMode) {
        super(width, height);
        this.initScreen = this.minecraft.screen;
        this.compactMode = compactMode;
        this.tip(tip);
    }

    public LegacyTip(Component tip, int width, int height) {
        this(tip, width, height, LegacyOptions.getUIMode().isSD());
    }

    public LegacyTip(Component title, Component tip) {
        this(tip, LegacyOptions.getUIMode().isSD() ? 136 : 250, 0);
        this.title(title);
        this.height = (title == null ? (LegacyOptions.getUIMode().isSD() ? 14 : 26) : (LegacyOptions.getUIMode().isSD() ? 22 : 38)) + this.tipLabel.getHeight();
        this.setY(25);
        this.canRemove(() -> this.initScreen != this.minecraft.screen);
    }

    public LegacyTip(Component tip) {
        this(null, tip);
    }

    public LegacyTip canRemove(Supplier<Boolean> canRemove) {
        this.canRemove = canRemove;
        return this;
    }

    public LegacyTip title(Component title) {
        this.title = CommonComponents.EMPTY.equals((Object)title) ? null : title;
        return this;
    }

    public LegacyTip centered() {
        this.centered = true;
        return this;
    }

    public LegacyTip tip(Component tip) {
        LegacyFontUtil.applyFontOverrideIf(this.compactMode, LegacyFontUtil.MOJANGLES_11_FONT, b -> this.tipLabel.lineSpacing(b != false ? 8 : 12).withLines(tip, this.width - (b != false ? 10 : 26)));
        return this.disappearTime((long)tip.getString().length() * 80L);
    }

    public LegacyTip disappearTime(long disappearTime) {
        if (disappearTime >= 0L) {
            this.createdTime = Util.getMillis();
            this.disappearTime = disappearTime;
        }
        return this;
    }

    public LegacyTip itemStack(ItemStack itemStack) {
        if (!itemStack.isEmpty()) {
            this.height += 32;
            if (this.holder == null) {
                this.holder = new LegacyIconHolder(32, 32);
                this.holder.allowItemDecorations = false;
            }
            this.holder.setX((this.width - 32) / 2);
            this.holder.setY((LegacyOptions.getUIMode().isSD() ? 5 : 13) + this.tipLabel.getHeight() + (this.title == null ? 0 : (LegacyOptions.getUIMode().isSD() ? 8 : 12)));
            this.holder.itemIcon = itemStack;
        }
        return this;
    }

    public int width() {
        return this.getWidth();
    }

    public int height() {
        return this.getHeight();
    }

    public void render(GuiGraphics guiGraphics, Font font, long l) {
        this.renderTip(guiGraphics, 0, 0, 0.0f, l);
    }

    public Toast.Visibility getWantedVisibility() {
        return this.visibility;
    }

    public void update(ToastManager toastManager, long l) {
    }

    public int occcupiedSlotCount() {
        return Math.min(5, super.occcupiedSlotCount());
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderTip(guiGraphics, i, j, f, Util.getMillis() - this.createdTime);
    }

    public void renderTip(GuiGraphics guiGraphics, int i, int j, float f, float l) {
        if (this.canRemove.get().booleanValue() || l >= (float)this.disappearTime) {
            this.visibility = Toast.Visibility.HIDE;
        }
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY());
        LegacyRenderUtil.renderPointerPanel(guiGraphics, 0, 0, this.getWidth(), this.getHeight());
        if (this.title != null) {
            LegacyFontUtil.applyFontOverrideIf(this.compactMode, LegacyFontUtil.MOJANGLES_11_FONT, b -> guiGraphics.drawString(this.minecraft.font, this.title, this.centered ? (this.width() - this.minecraft.font.width((FormattedText)this.title)) / 2 : (b != false ? 5 : 13), b != false ? 5 : 13, ((Integer)CommonColor.TIP_TITLE_TEXT.get()).intValue()));
        }
        LegacyFontUtil.applyFontOverrideIf(this.compactMode, LegacyFontUtil.MOJANGLES_11_FONT, b -> this.tipLabel.centered(this.centered).withColor(((Integer)CommonColor.TIP_TEXT.get()).intValue()).withShadow(this.centered).withPos(b != false ? 5 : 13, this.title == null ? (b.booleanValue() ? 5 : 13) : (b != false ? 13 : 25)).render(guiGraphics, i, j, f));
        if (this.holder != null) {
            this.holder.render(guiGraphics, i, j, f);
        }
        guiGraphics.pose().popMatrix();
    }
}

