/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;

public class LegacyFlatPresetsScreen
extends PanelVListScreen {
    public LegacyFlatPresetsScreen(Screen parent, HolderLookup.RegistryLookup<FlatLevelGeneratorPreset> presetGetter, FeatureFlagSet enabledFeatures, final Consumer<Holder<FlatLevelGeneratorPreset>> applyPreset) {
        super(parent, s -> Panel.centered(s, LegacySprites.PANEL, 285, 260), (Component)Component.translatable((String)"createWorld.customize.presets"));
        presetGetter.listElements().forEach(holder -> {
            Set set = ((FlatLevelGeneratorPreset)holder.value()).settings().getLayersInfo().stream().map(flatLayerInfo -> flatLayerInfo.getBlockState().getBlock()).filter(block -> !block.isEnabled(enabledFeatures)).collect(Collectors.toSet());
            if (!set.isEmpty()) {
                Legacy4J.LOGGER.info("Discarding flat world preset {} since it contains experimental blocks {}", (Object)holder.unwrapKey().map(resourceKey -> resourceKey.location().toString()).orElse("<unknown>"), set);
            } else {
                final FlatLevelGeneratorPreset preset = (FlatLevelGeneratorPreset)holder.value();
                this.renderableVList.addRenderable((Renderable)new AbstractButton(0, 0, 263, 30, (Component)Component.translatable((String)holder.key().location().toLanguageKey("flat_world_preset")), (Holder.Reference)holder, parent){
                    final /* synthetic */ Holder.Reference val$holder;
                    final /* synthetic */ Screen val$parent;
                    {
                        this.val$holder = reference;
                        this.val$parent = screen;
                        super(i, j, k, l, arg);
                    }

                    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
                        super.renderWidget(guiGraphics, i, j, f);
                        guiGraphics.pose().pushMatrix();
                        guiGraphics.pose().translate((float)(this.getX() + 5), (float)(this.getY() + 5));
                        guiGraphics.pose().scale(1.25f, 1.25f);
                        guiGraphics.renderItem(((Item)preset.displayItem().value()).getDefaultInstance(), 0, 0);
                        guiGraphics.pose().popMatrix();
                    }

                    protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
                        int k = this.getX() + 33;
                        int l = this.getX() + this.getWidth();
                        LegacyRenderUtil.renderScrollingString(guiGraphics, font, this.getMessage(), k, this.getY(), l, this.getY() + this.getHeight(), j, true);
                    }

                    public void onPress(InputWithModifiers input) {
                        LegacyFlatPresetsScreen.this.minecraft.setScreen((Screen)new ConfirmationScreen((Screen)LegacyFlatPresetsScreen.this, (Component)Component.translatable((String)"legacy.menu.create_flat_world.load_preset"), (Component)Component.translatable((String)"legacy.menu.create_flat_world.load_preset_message"), b -> {
                            applyPreset.accept(this.val$holder);
                            LegacyFlatPresetsScreen.this.minecraft.setScreen(this.val$parent);
                        }));
                    }

                    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                        this.defaultButtonNarrationText(narrationElementOutput);
                    }
                });
            }
        });
        this.renderableVList.layoutSpacing(l -> 0);
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.addRenderableOnly((guiGraphics, i, j, f) -> guiGraphics.drawString(this.font, this.getTitle(), this.panel.x + (this.panel.width - this.font.width((FormattedText)this.getTitle())) / 2, this.panel.y + 9, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
        this.addRenderableOnly((guiGraphics, i, j, f) -> FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 6, this.panel.y + 20, this.panel.width - 12, 231));
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 11, this.panel.y + 26, 263, this.panel.height - 38);
    }
}

