/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.StackIngredient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.PagedList;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LoomTabListing;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CustomRecipeIconHolder;
import wily.legacy.client.screen.LegacyCraftingScreen;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.RecipeIconHolder;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.client.screen.TabList;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacyItemUtil;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public class LegacyLoomScreen
extends AbstractContainerScreen<LegacyCraftingMenu>
implements Controller.Event,
ControlTooltip.Event,
TabList.Access {
    protected final List<ItemStack> compactInventoryList = new ArrayList<ItemStack>();
    protected final List<Optional<Ingredient>> ingredientsGrid = new ArrayList(Collections.nCopies(9, Optional.empty()));
    protected final List<Optional<Ingredient>> selectedIngredients = new ArrayList<Optional<Ingredient>>();
    protected final UIAccessor accessor = UIAccessor.of((Screen)this);
    protected final ScrollableRenderer scrollableRenderer = new ScrollableRenderer();
    protected final List<LoomTabListing> loomTabListings = List.copyOf(Legacy4JClient.loomListingManager.map().values());
    protected final List<RecipeIconHolder<BannerRecipe>> craftingButtons = new ArrayList<RecipeIconHolder<BannerRecipe>>();
    protected final Stocker.Sizeable page = new Stocker.Sizeable(Integer.valueOf(0));
    protected final Stocker.Sizeable craftingButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected final TabList craftingTabList = new TabList(this.accessor, (List<LegacyTabButton>)new PagedList(this.page, this::getMaxTabCount));
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    private final Inventory inventory;
    private final boolean[] warningSlots = new boolean[9];
    protected final List<CustomRecipeIconHolder> selectBannerButton = Collections.singletonList(new CustomRecipeIconHolder(){

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 79 && this.isFocused() && this.hasItem() ? LegacyComponents.SELECT : null);
        }

        @Override
        public Component getDisplayName() {
            return LegacyComponents.SELECT_BANNER_TAB;
        }

        @Override
        public ItemStack nextItem() {
            return this.nextItem(LegacyLoomScreen.this.inventory, i -> i.getItem() instanceof BannerItem && LegacyItemUtil.getPatternsCount(i) < 6);
        }

        @Override
        public ItemStack previousItem() {
            return this.previousItem(LegacyLoomScreen.this.inventory, i -> i.getItem() instanceof BannerItem && LegacyItemUtil.getPatternsCount(i) < 6);
        }

        @Override
        public boolean applyNextItemIfAbsent() {
            return true;
        }

        @Override
        public boolean canCraft() {
            return true;
        }

        @Override
        public void craft(InputWithModifiers input) {
        }

        @Override
        public List<Optional<Ingredient>> getIngredientsGrid() {
            return LegacyLoomScreen.this.ingredientsGrid;
        }

        @Override
        int findInventoryMatchSlot() {
            for (int i = 0; i < ((LegacyCraftingMenu)((LegacyLoomScreen)LegacyLoomScreen.this).menu).slots.size(); ++i) {
                if (((Slot)((LegacyCraftingMenu)((LegacyLoomScreen)LegacyLoomScreen.this).menu).slots.get(i)).getItem() != this.itemIcon) continue;
                return i;
            }
            this.itemIcon = this.nextItem;
            return this.itemIcon.isEmpty() ? 0 : this.findInventoryMatchSlot();
        }

        @Override
        public void render(GuiGraphics graphics, int i, int j, float f) {
            if (this.isFocused()) {
                LegacyLoomScreen.this.selectedCraftingButton = LegacyLoomScreen.this.getCraftingButtons().indexOf(this);
            }
            super.render(graphics, i, j, f);
        }

        @Override
        public boolean keyPressed(KeyEvent keyEvent) {
            if (keyEvent.key() == 79 && !this.itemIcon.isEmpty() && this.hasItem()) {
                this.updateRecipe();
                LegacyLoomScreen.this.selectedStack = this.itemIcon.copyWithCount(1);
                LegacyLoomScreen.this.craftingTabList.tabButtons.get(1).onPress((InputWithModifiers)new KeyEvent(257, 0, 0));
                return true;
            }
            return super.keyPressed(keyEvent);
        }

        @Override
        void updateRecipe() {
            LegacyCraftingScreen.clearIngredients(LegacyLoomScreen.this.ingredientsGrid);
            LegacyLoomScreen.this.resultStack = this.itemIcon.copyWithCount(1);
            LegacyLoomScreen.this.ingredientsGrid.set(4, LegacyLoomScreen.this.resultStack.isEmpty() ? Optional.empty() : Optional.of(StackIngredient.of((boolean)true, (ItemStack)LegacyLoomScreen.this.resultStack, (int)1)));
            LegacyLoomScreen.this.scrollableRenderer.resetScrolled();
        }

        @Override
        LegacyScrollRenderer getScrollRenderer() {
            return LegacyLoomScreen.this.scrollRenderer;
        }
    });
    protected ItemStack resultStack = ItemStack.EMPTY;
    protected ItemStack selectedStack = ItemStack.EMPTY;
    protected ItemStack previewStack = ItemStack.EMPTY;
    protected List<RecipeInfo<BannerRecipe>> selectedPatterns = new ArrayList<RecipeInfo<BannerRecipe>>();
    protected List<List<RecipeInfo<BannerRecipe>>> recipesByGroup = new ArrayList<List<RecipeInfo<BannerRecipe>>>();
    protected int selectedCraftingButton;
    protected boolean inited;
    protected final ContainerListener listener = new ContainerListener(){

        public void slotChanged(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
            LegacyIconHolder legacyIconHolder;
            LegacyLoomScreen.this.recipesByGroup.clear();
            LegacyLoomScreen.this.selectedIngredients.clear();
            if (!LegacyLoomScreen.this.isSelectionTab() && !LegacyLoomScreen.this.selectedStack.isEmpty()) {
                LegacyLoomScreen.this.previewStack = LegacyLoomScreen.this.selectedStack.copy();
                LegacyLoomScreen.this.selectedIngredients.add(Optional.of(StackIngredient.of((boolean)true, (ItemStack)LegacyLoomScreen.this.selectedStack, (int)1)));
                if (!LegacyLoomScreen.this.selectedPatterns.isEmpty()) {
                    ArrayList layersList = LegacyLoomScreen.this.previewStack.get(DataComponents.BANNER_PATTERNS) == null ? new ArrayList() : new ArrayList(((BannerPatternLayers)LegacyLoomScreen.this.previewStack.get(DataComponents.BANNER_PATTERNS)).layers());
                    LegacyLoomScreen.this.selectedPatterns.forEach(rcp -> {
                        layersList.add(new BannerPatternLayers.Layer((Holder)Minecraft.getInstance().getConnection().registryAccess().lookupOrThrow(Registries.BANNER_PATTERN).getOrThrow(((BannerRecipe)rcp.get()).pattern), ((BannerRecipe)rcp.get()).color));
                        for (int i1 = 1; i1 < rcp.getOptionalIngredients().size(); ++i1) {
                            Optional<Ingredient> ing = rcp.getOptionalIngredients().get(i1);
                            if (ing.isEmpty()) continue;
                            LegacyLoomScreen.this.selectedIngredients.add(ing);
                        }
                    });
                    LegacyLoomScreen.this.previewStack.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers(layersList));
                }
                Optional<StackIngredient> previewIng = Optional.of(StackIngredient.of((boolean)true, (ItemStack)LegacyLoomScreen.this.previewStack, (int)1));
                LegacyLoomScreen.this.loomTabListings.get(LegacyLoomScreen.this.craftingTabList.getIndex()).patterns().stream().filter(p -> Minecraft.getInstance().getConnection().registryAccess().lookupOrThrow(Registries.BANNER_PATTERN).listElementIds().anyMatch(arg_0 -> ((ResourceKey)p).equals(arg_0))).forEach(p -> LegacyLoomScreen.this.recipesByGroup.add(Arrays.stream(DyeColor.values()).map(color -> {
                    ItemStack result = LegacyLoomScreen.this.previewStack.copy();
                    ArrayList<BannerPatternLayers.Layer> layersList = result.get(DataComponents.BANNER_PATTERNS) == null ? new ArrayList<BannerPatternLayers.Layer>() : new ArrayList(((BannerPatternLayers)result.get(DataComponents.BANNER_PATTERNS)).layers());
                    layersList.add(new BannerPatternLayers.Layer((Holder)Minecraft.getInstance().getConnection().registryAccess().lookupOrThrow(Registries.BANNER_PATTERN).getOrThrow(p), color));
                    result.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers(layersList));
                    Optional<Ingredient> dye = Optional.of(Ingredient.of((ItemLike)DyeItem.byColor((DyeColor)color)));
                    ArrayList<Optional<Ingredient>> previewIngs = new ArrayList<Optional<Ingredient>>(LegacyLoomScreen.this.selectedIngredients);
                    previewIngs.add(dye);
                    List<Optional<Ingredient>> ings = List.of(previewIng, dye);
                    ArrayList<Optional<Ingredient>> displayIngs = new ArrayList<Optional<Ingredient>>(ings);
                    Optional<Ingredient> extraIng = LegacyCraftingMenu.getBannerPatternExtraIngredient((RegistryAccess)Minecraft.getInstance().getConnection().registryAccess(), (ResourceKey<BannerPattern>)p);
                    if (extraIng.isPresent()) {
                        displayIngs.add(1, extraIng);
                        previewIngs.add(extraIng);
                    }
                    displayIngs.set(0, LegacyLoomScreen.this.selectedIngredients.get(0));
                    return RecipeInfo.create(p.location().withPrefix(color.getName() + "_"), new BannerRecipe((List<Optional<Ingredient>>)previewIngs, LegacyCraftingMenu.updateShapedIngredients(new ArrayList<Optional<Ingredient>>(Collections.nCopies(9, Optional.empty())), displayIngs, 3, 2, 2), (ResourceKey<BannerPattern>)p, (DyeColor)color), ings, result);
                }).collect(Collectors.collectingAndThen(Collectors.toList(), l -> {
                    Collections.reverse(l);
                    return l;
                }))));
                LegacyLoomScreen.this.craftingButtons.get(LegacyLoomScreen.this.selectedCraftingButton).updateRecipeDisplay();
            } else if (LegacyLoomScreen.this.getCraftingButtons().size() > LegacyLoomScreen.this.selectedCraftingButton && (legacyIconHolder = LegacyLoomScreen.this.getCraftingButtons().get(LegacyLoomScreen.this.selectedCraftingButton)) instanceof LegacyCraftingScreen.CustomCraftingIconHolder) {
                LegacyCraftingScreen.CustomCraftingIconHolder h = (LegacyCraftingScreen.CustomCraftingIconHolder)legacyIconHolder;
                h.updateRecipe();
            }
        }

        public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int j) {
        }
    };

    public LegacyLoomScreen(LegacyCraftingMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.inventory = inventory;
        for (LoomTabListing listing : this.loomTabListings) {
            if (!listing.isValid()) continue;
            this.craftingTabList.add(LegacyTabButton.Type.LEFT, listing.icon(), listing.nameOrEmpty(), t -> this.resetElements());
        }
        this.inited = true;
        this.addCraftingButtons();
        this.resetElements(false);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
        renderer.add(() -> ControlTooltip.OPTION.get(), () -> ControlTooltip.getKeyMessage(79, (Screen)this)).add(() -> ControlTooltip.EXTRA.get(), () -> {
            RecipeIconHolder r;
            GuiEventListener patt0$temp = this.getFocused();
            return patt0$temp instanceof RecipeIconHolder && (r = (RecipeIconHolder)patt0$temp).getFocusedRecipe() != null && this.selectedPatterns.contains(r.getFocusedRecipe()) ? LegacyComponents.REMOVE : null;
        }).add(() -> ControlTooltip.CONTROL_TAB.get(), () -> this.isSelectionTab() ? null : LegacyComponents.GROUP).add(() -> ControlTooltip.CONTROL_TYPE.get(), () -> this.page.max > 0 ? LegacyComponents.PAGE : null);
    }

    public void resetElements() {
        this.resetElements(true);
    }

    public void resetElements(boolean reposition) {
        if (!reposition) {
            this.listener.slotChanged(this.menu, -1, ItemStack.EMPTY);
        }
        this.selectedCraftingButton = 0;
        this.craftingButtonsOffset.set(Integer.valueOf(0));
        this.craftingButtons.get(this.selectedCraftingButton).invalidateFocused();
        if (reposition) {
            this.repositionElements();
        }
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        if (guiEventListener instanceof TabList) {
            return;
        }
        super.setFocused(guiEventListener);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        LegacyFontUtil.applySDFont(b -> {
            Component title = !this.isSelectionTab() ? this.craftingTabList.tabButtons.get(this.craftingTabList.getIndex()).getMessage() : this.selectBannerButton.get(0).getDisplayName();
            guiGraphics.drawString(this.font, title, ((!this.isSelectionTab() ? this.imageWidth : this.imageWidth / 2) - this.font.width((FormattedText)title)) / 2, this.accessor.getInteger("title.y", 17), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            int inventoryPanelX = this.accessor.getInteger("inventoryPanel.x", 176);
            int bottomPanelY = this.accessor.getInteger("bottomPanel.y", 103);
            int inventoryPanelWidth = this.accessor.getInteger("inventoryPanel.width", 163);
            if (((LegacyCraftingMenu)this.menu).inventoryActive) {
                guiGraphics.drawString(this.font, this.playerInventoryTitle, inventoryPanelX + (inventoryPanelWidth - this.font.width((FormattedText)this.playerInventoryTitle)) / 2, bottomPanelY + this.accessor.getInteger("inventoryTitle.y", 11), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            } else {
                guiGraphics.drawString(this.font, LegacyComponents.PREVIEW, inventoryPanelX + (inventoryPanelWidth - this.font.width((FormattedText)LegacyComponents.PREVIEW)) / 2, bottomPanelY + this.accessor.getInteger("inventoryTitle.y", 11), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            }
        });
    }

    public void renderContents(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderContents(guiGraphics, i, j, f);
        this.getCraftingButtons().forEach(b -> b.render(guiGraphics, i, j, 0.0f));
        if (this.selectedCraftingButton < this.getCraftingButtons().size()) {
            this.getCraftingButtons().get(this.selectedCraftingButton).renderSelection(guiGraphics, i, j, 0.0f);
        }
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.pressed && state.canClick() && state.is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
            BindingState.Axis s = (BindingState.Axis)state;
            if (!this.isSelectionTab()) {
                this.craftingTabList.controlPage(this.page, s.x < 0.0f && -s.x > Math.abs(s.y), s.x > 0.0f && s.x > Math.abs(s.y));
            }
        }
    }

    @Override
    public TabList getTabList() {
        return this.craftingTabList;
    }

    @Override
    public int getTabYOffset() {
        return this.accessor.getInteger("tabYOffset", 18);
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings(BindingState state) {
        return !state.is(ControllerBinding.DOWN_BUTTON) && Controller.Event.super.onceClickBindings(state);
    }

    protected void init() {
        this.resultStack = ItemStack.EMPTY;
        this.imageWidth = 348;
        this.imageHeight = 215;
        super.init();
        LegacySlotDisplay display = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return 16;
            }

            @Override
            public Vec2 getOffset() {
                return ((LegacyCraftingMenu)((LegacyLoomScreen)LegacyLoomScreen.this).menu).inventoryOffset;
            }

            @Override
            public boolean isVisible() {
                return ((LegacyCraftingMenu)((LegacyLoomScreen)LegacyLoomScreen.this).menu).inventoryActive;
            }
        };
        for (int i2 = 0; i2 < 36; ++i2) {
            Slot s = (Slot)((LegacyCraftingMenu)this.menu).slots.get(i2);
            if (i2 < 27) {
                LegacySlotDisplay.override(s, 186 + (s.getContainerSlot() - 9) % 9 * 16, 133 + (s.getContainerSlot() - 9) / 9 * 16, display);
                continue;
            }
            LegacySlotDisplay.override(s, 186 + s.getContainerSlot() * 16, 186, display);
        }
        this.topPos += this.getTabYOffset();
        ((LegacyCraftingMenu)this.menu).addSlotListener(this.listener);
        this.getTabList().setSelected(this.selectedStack.isEmpty() ? 0 : Math.max(this.getTabList().getIndex(), 1));
        ((LegacyCraftingMenu)this.menu).inventoryActive = (Boolean)this.accessor.putBearer("isInventoryActive", Bearer.of((Object)this.selectedStack.isEmpty()));
        int count = (Integer)this.accessor.putStaticElement("craftingButtons.count", (Object)this.getCraftingButtons().size());
        if (this.selectedCraftingButton < count) {
            this.setFocused(this.getCraftingButtons().get(this.selectedCraftingButton));
        }
        int craftingButtonsX = this.accessor.getInteger("craftingButtons.x", 13);
        int craftingButtonsY = this.accessor.getInteger("craftingButtons.y", 38);
        int craftingButtonsSize = this.accessor.getInteger("craftingButtons.size", 27);
        if (!this.isSelectionTab()) {
            this.craftingButtonsOffset.max = Math.max(0, this.loomTabListings.get((Integer)this.page.get() * this.getMaxTabCount() + this.getTabList().getIndex()).patterns().size() - 12);
            this.craftingButtons.forEach(b -> {
                b.width = b.height = craftingButtonsSize;
                b.setPos(this.leftPos + craftingButtonsX + this.craftingButtons.indexOf(b) * b.width, this.topPos + craftingButtonsY);
                this.addWidget((GuiEventListener)b);
            });
        } else {
            int slotX = this.accessor.getInteger("customCraftingButtons.x", count == 1 ? 77 : (count == 2 ? 52 : (count == 3 ? 21 : 8)));
            int xOffset = this.accessor.getInteger("customCraftingButtons.offset.x", count == 2 ? 35 : (count == 3 ? 28 : 18));
            this.getCraftingButtons().forEach(b -> {
                b.width = b.height = craftingButtonsSize;
                int index = this.getCraftingButtons().indexOf(b);
                b.setPos(this.leftPos + slotX + index * (b.width + xOffset), this.topPos + craftingButtonsY);
                if (count == 3) {
                    b.offset = new Vec2((LegacyRenderUtil.hasHorizontalArtifacts() ? 0.0125f : 0.0f) + 0.5f + (float)index * 0.5f, 0.0f);
                }
                b.init();
                this.addWidget((GuiEventListener)b);
            });
        }
        this.addWidget(this.getTabList());
        this.getTabList().init(this.leftPos, this.topPos - 37, this.imageWidth, 43, (t, i) -> {
            int index = this.getTabList().tabButtons.indexOf(t);
            t.active = index == 0 && this.selectedStack.isEmpty() || index != 0 && !this.selectedStack.isEmpty();
            t.type = LegacyTabButton.Type.bySize(index, this.getMaxTabCount());
            t.setWidth(this.accessor.getInteger("tabList.buttonWidth", 51));
            t.offset = t1 -> new Vec2((LegacyRenderUtil.hasHorizontalArtifacts() && index % 2 != 0 ? 0.0125f : 0.0f) + this.accessor.getFloat("tabList.buttonOffset.x", -1.5f) * (float)index, t1.active ? (t1.selected ? 0.0f : this.accessor.getFloat("tabList.selectedOffset.y", 4.4f)) : this.accessor.getFloat("tabList.inactiveOffset.y", 26.4f));
        });
        this.listener.slotChanged(this.menu, -1, ItemStack.EMPTY);
    }

    protected int getMaxTabCount() {
        return this.accessor.getInteger("maxTabCount", 7);
    }

    protected boolean canCraft() {
        return this.selectedIngredients.size() > 1 && this.canCraft(this.selectedIngredients, false);
    }

    protected boolean canCraft(List<Optional<Ingredient>> ingredients, boolean isFocused) {
        this.compactInventoryList.clear();
        RecipeMenu.handleCompactInventoryList(this.compactInventoryList, Minecraft.getInstance().player.getInventory(), ((LegacyCraftingMenu)this.menu).getCarried());
        return LegacyCraftingScreen.canCraft(this.compactInventoryList, ingredients, isFocused ? this.warningSlots : null);
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.getChildAt(d, e).filter(guiEventListener -> guiEventListener.mouseScrolled(d, e, f, g)).isPresent()) {
            return true;
        }
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        if (this.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.craftingButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.craftingButtonsOffset.max > 0) && this.craftingButtonsOffset.add(scroll, false) != 0) {
            this.repositionElements();
            return true;
        }
        return false;
    }

    protected void addCraftingButtons() {
        for (int i = 0; i < 12; ++i) {
            final int index = i;
            RecipeIconHolder<BannerRecipe> h = new RecipeIconHolder<BannerRecipe>(this.leftPos + 13 + i * 27, this.topPos + 38){

                @Override
                @Nullable
                public Component getAction(ControlTooltip.ActionHolder.Context context) {
                    return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 && this.isFocused() && LegacyLoomScreen.this.canCraft() ? LegacyComponents.CREATE : (c.key() == 79 && this.isFocused() && this.canCraft() ? LegacyComponents.ADD : null));
                }

                @Override
                public void render(GuiGraphics graphics, int i, int j, float f) {
                    if (this.isFocused()) {
                        LegacyLoomScreen.this.selectedCraftingButton = index;
                    }
                    super.render(graphics, i, j, f);
                }

                @Override
                protected boolean canCraft(RecipeInfo<BannerRecipe> rcp) {
                    if (rcp == null) {
                        return true;
                    }
                    return LegacyItemUtil.getPatternsCount(LegacyLoomScreen.this.previewStack) < 6 && LegacyLoomScreen.this.canCraft(((BannerRecipe)rcp.get()).displayIngredients(), this.isFocused() && this.getFocusedRecipe() == rcp) && LegacyLoomScreen.this.canCraft(((BannerRecipe)rcp.get()).previewIngredients, false);
                }

                @Override
                protected List<RecipeInfo<BannerRecipe>> getRecipes() {
                    return LegacyLoomScreen.this.recipesByGroup.size() <= (Integer)LegacyLoomScreen.this.craftingButtonsOffset.get() + index ? Collections.emptyList() : LegacyLoomScreen.this.recipesByGroup.get((Integer)LegacyLoomScreen.this.craftingButtonsOffset.get() + index);
                }

                @Override
                public LegacyScrollRenderer getScrollRenderer() {
                    return LegacyLoomScreen.this.scrollRenderer;
                }

                @Override
                protected void toggleCraftableRecipes(InputWithModifiers input) {
                }

                @Override
                public boolean keyPressed(KeyEvent keyEvent) {
                    if ((keyEvent.key() == 79 || keyEvent.key() == 88) && this.isValidIndex()) {
                        if (keyEvent.key() == 79) {
                            if (this.canCraft()) {
                                LegacyLoomScreen.this.selectedPatterns.add(this.getFocusedRecipe());
                                LegacySoundUtil.playSimpleUISound(SoundEvents.UI_LOOM_SELECT_PATTERN, 1.0f);
                            }
                        } else {
                            LegacyLoomScreen.this.selectedPatterns.remove(this.getFocusedRecipe());
                        }
                        int cycle = this.getFocusedRecipes().indexOf(this.getFocusedRecipe()) - this.getRecipes().indexOf(this.getFocusedRecipe());
                        this.focusedRecipes = null;
                        LegacyLoomScreen.this.listener.slotChanged(LegacyLoomScreen.this.menu, -1, ItemStack.EMPTY);
                        Collections.rotate(this.getFocusedRecipes(), cycle);
                        this.updateRecipeDisplay();
                        return true;
                    }
                    if (this.controlCyclicNavigation(keyEvent.key(), index, LegacyLoomScreen.this.craftingButtons, LegacyLoomScreen.this.craftingButtonsOffset, LegacyLoomScreen.this.scrollRenderer, (Screen)LegacyLoomScreen.this)) {
                        return true;
                    }
                    return super.keyPressed(keyEvent);
                }

                @Override
                protected void updateRecipeDisplay(RecipeInfo<BannerRecipe> rcp) {
                    LegacyLoomScreen.this.resultStack = this.getFocusedResult();
                    LegacyCraftingScreen.clearIngredients(LegacyLoomScreen.this.ingredientsGrid);
                    if (rcp == null) {
                        return;
                    }
                    for (int i = 0; i < ((BannerRecipe)rcp.get()).displayIngredients().size(); ++i) {
                        LegacyLoomScreen.this.ingredientsGrid.set(i, ((BannerRecipe)rcp.get()).displayIngredients().get(i));
                    }
                }

                @Override
                public void onPress(InputWithModifiers input) {
                    if (this.isFocused() && this.isValidIndex()) {
                        if (LegacyLoomScreen.this.canCraft()) {
                            LegacySoundUtil.playSimpleUISound(SoundEvents.UI_LOOM_TAKE_RESULT, 1.0f);
                            LegacyLoomScreen.this.selectedPatterns.forEach(b -> CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload(Optional.of(((BannerRecipe)b.get()).pattern.location()), b.getOptionalIngredients(), -1, input.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed)));
                            LegacyLoomScreen.this.selectedPatterns.clear();
                            LegacyLoomScreen.this.selectedStack = ItemStack.EMPTY;
                            LegacyLoomScreen.this.previewStack = ItemStack.EMPTY;
                            LegacyLoomScreen.this.craftingTabList.tabButtons.get(0).onPress((InputWithModifiers)new KeyEvent(257, 0, 0));
                        } else {
                            LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.CRAFT_FAIL.get(), 1.0f);
                        }
                    }
                }
            };
            this.craftingButtons.add(h);
            h.allowCraftableRecipesToggle = false;
            h.offset = new Vec2(0.5f, 0.5f);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        this.getTabList().render(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.accessor.getResourceLocation("imageSprite", LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        this.getTabList().renderSelected(guiGraphics, i, j, f);
        int bottomPanelHeight = this.accessor.getInteger("bottomPanel.height", 105);
        int panelWidth = this.accessor.getInteger("craftingGridPanel.width", 163);
        int inventoryPanelX = this.accessor.getInteger("inventoryPanel.x", 176);
        int inventoryPanelWidth = this.accessor.getInteger("inventoryPanel.width", 163);
        int bottomPanelY = this.accessor.getInteger("bottomPanel.y", 103);
        int craftingGridPanelX = this.accessor.getInteger("craftingGridPanel.x", 9);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + craftingGridPanelX, this.topPos + bottomPanelY, panelWidth, bottomPanelHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + inventoryPanelX, this.topPos + bottomPanelY, inventoryPanelWidth, bottomPanelHeight);
        if (!((LegacyCraftingMenu)this.menu).inventoryActive && !this.previewStack.isEmpty()) {
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)(this.leftPos + inventoryPanelX) + (float)inventoryPanelWidth / 2.0f, (float)(this.topPos + bottomPanelY) + (float)bottomPanelHeight / 2.0f + 10.0f);
            float previewScale = this.accessor.getFloat("preview.scale", 4.25f);
            guiGraphics.pose().scale(previewScale, previewScale);
            guiGraphics.renderItem(this.previewStack, -8, -8);
            guiGraphics.pose().popMatrix();
        }
        int descriptionPanelWidth = this.accessor.getInteger("descriptionPanel.width", 163);
        int descriptionPanelHeight = this.accessor.getInteger("descriptionPanel.height", 93);
        int descriptionPanelX = this.accessor.getInteger("descriptionPanel.x", 176);
        int descriptionPanelY = this.accessor.getInteger("descriptionPanel.y", 8);
        if (this.getTabList().getIndex() == 0) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + descriptionPanelX, this.topPos + descriptionPanelY, descriptionPanelWidth, descriptionPanelHeight);
        }
        int slotSize = this.accessor.getInteger("craftingGridSlot.size", 23);
        int xDiff = this.leftPos + craftingGridPanelX;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMALL_ARROW, xDiff + this.accessor.getInteger("craftingArrow.x", 77) + slotSize / 2, this.topPos + bottomPanelY + this.accessor.getInteger("craftingArrow.y", 57), 16, 14);
        if (this.getTabList().getIndex() != 0) {
            if ((Integer)this.craftingButtonsOffset.get() > 0) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.leftPos + 5, this.topPos + 45);
            }
            if (this.craftingButtonsOffset.max > 0 && (Integer)this.craftingButtonsOffset.get() < this.craftingButtonsOffset.max) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.leftPos + this.imageWidth - 11, this.topPos + 45);
            }
        }
        int resultSlotSize = this.accessor.getInteger("craftingResultSlot.size", 36);
        int yDiff = this.topPos + bottomPanelY;
        int craftingGridSlotX = this.accessor.getInteger("craftingGridSlot.x", 12);
        int craftingGridSlotY = this.accessor.getInteger("craftingGridSlot.y", 30);
        boolean anyWarning = false;
        for (int index = 0; index < this.ingredientsGrid.size(); ++index) {
            LegacyIconHolder holder = LegacyRenderUtil.iconHolderRenderer.itemHolder(xDiff + craftingGridSlotX + index % 3 * slotSize, yDiff + craftingGridSlotY + index / 3 * slotSize, slotSize, slotSize, RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)), !RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)).isEmpty() && this.warningSlots[index], new Vec2(LegacyRenderUtil.hasHorizontalArtifacts() ? 0.4f : 0.5f, 0.4f));
            if (holder.isWarning()) {
                anyWarning = true;
            }
            holder.render(guiGraphics, i, j, f);
            holder.renderTooltip(this.minecraft, guiGraphics, i, j);
        }
        LegacyIconHolder holder = LegacyRenderUtil.iconHolderRenderer.itemHolder(xDiff + this.accessor.getInteger("resultSlot.x", 104) + slotSize / 2, yDiff + this.accessor.getInteger("resultSlot.y", 48), resultSlotSize, resultSlotSize, this.resultStack, anyWarning, new Vec2(LegacyRenderUtil.hasHorizontalArtifacts() ? 0.4f : 0.5f, 0.0f));
        holder.render(guiGraphics, i, j, f);
        holder.renderTooltip(this.minecraft, guiGraphics, i, j);
        if (!this.resultStack.isEmpty()) {
            Component component;
            Component component2;
            LegacyIconHolder legacyIconHolder = this.getCraftingButtons().get(this.selectedCraftingButton);
            if (legacyIconHolder instanceof RecipeIconHolder) {
                RecipeIconHolder h = (RecipeIconHolder)legacyIconHolder;
                component2 = h.getFocusedRecipe().getName();
            } else {
                component2 = this.resultStack.getHoverName();
            }
            Component resultName = component2;
            LegacyIconHolder legacyIconHolder2 = this.getCraftingButtons().get(this.selectedCraftingButton);
            if (legacyIconHolder2 instanceof RecipeIconHolder) {
                RecipeIconHolder h = (RecipeIconHolder)legacyIconHolder2;
                component = h.getFocusedRecipe().getDescription();
            } else {
                component = null;
            }
            Component description = component;
            int titleY = bottomPanelY + this.accessor.getInteger("craftingTitle.y", 11) - (description == null ? 0 : 6);
            LegacyFontUtil.applySDFont(b -> LegacyRenderUtil.renderScrollingString(guiGraphics, this.font, resultName, xDiff + 2 + Math.max(panelWidth - this.font.width((FormattedText)resultName), 0) / 2, this.topPos + titleY, xDiff + panelWidth - 2, this.topPos + titleY + 11, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false));
            if (description != null) {
                LegacyFontUtil.applySDFont(b -> LegacyRenderUtil.renderScrollingString(guiGraphics, this.font, (Component)description.copy().setStyle(Style.EMPTY), xDiff + 2 + Math.max(panelWidth - this.font.width((FormattedText)description), 0) / 2, this.topPos + titleY + 12, xDiff + panelWidth - 2, this.topPos + titleY + 23, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false));
            }
            LegacyFontUtil.applySDFont(b -> {
                if (this.getTabList().getIndex() == 0) {
                    int descriptionTextXOffset = this.accessor.getInteger("descriptionText.x", 4);
                    int descriptionTextYOffset = this.accessor.getInteger("descriptionText.y", 7);
                    int descriptionTextWidth = descriptionPanelWidth - descriptionTextXOffset * 2;
                    int lineSpacing = b != false ? 8 : 12;
                    this.scrollableRenderer.lineHeight = lineSpacing;
                    int lineAmount = (descriptionPanelHeight - descriptionTextYOffset * 2 - 7) / lineSpacing;
                    List<FormattedCharSequence> list = LegacyRenderUtil.getTooltip(this.resultStack, descriptionTextWidth);
                    this.scrollableRenderer.scrolled.max = Math.max(0, list.size() - lineAmount);
                    this.scrollableRenderer.render(guiGraphics, this.leftPos + descriptionPanelX + descriptionTextXOffset, this.topPos + descriptionPanelY + descriptionTextYOffset, descriptionTextWidth, lineAmount * lineSpacing, () -> {
                        for (int i1 = 0; i1 < list.size(); ++i1) {
                            FormattedCharSequence sequence = (FormattedCharSequence)list.get(i1);
                            guiGraphics.drawString(this.font, sink -> sequence.accept((i2, style, j1) -> sink.accept(i2, Style.EMPTY, j1)), this.leftPos + descriptionPanelX + descriptionTextXOffset, this.topPos + descriptionPanelY + descriptionTextYOffset + i1 * lineSpacing, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                        }
                    });
                }
            });
        }
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.hasShiftDown() && !this.isSelectionTab() && this.craftingTabList.controlPage(this.page, keyEvent.isLeft(), keyEvent.isRight())) {
            return true;
        }
        if (this.craftingTabList.controlTab(keyEvent.key())) {
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public List<? extends LegacyIconHolder> getCraftingButtons() {
        return this.isSelectionTab() ? this.selectBannerButton : this.craftingButtons;
    }

    public boolean isSelectionTab() {
        return this.loomTabListings.get(this.craftingTabList.getIndex()).is(LoomTabListing.SELECT_BANNER);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.getCraftingButtons().forEach(h -> h.renderTooltip(this.minecraft, guiGraphics, i, j));
        this.renderTooltip(guiGraphics, i, j);
    }

    public record BannerRecipe(List<Optional<Ingredient>> previewIngredients, List<Optional<Ingredient>> displayIngredients, ResourceKey<BannerPattern> pattern, DyeColor color) {
    }
}

