/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.phys.Vec2;
import org.spongepowered.asm.mixin.Unique;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.network.CommonRecipeManager;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.StoneCuttingGroupManager;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyCraftingScreen;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.RecipeIconHolder;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class LegacyStonecutterScreen
extends AbstractContainerScreen<LegacyCraftingMenu>
implements Controller.Event,
ControlTooltip.Event {
    public static final Vec2 DISPLAY_OFFSET = new Vec2(0.5f, 0.0f);
    public static final Vec2 ALT_DISPLAY_OFFSET = new Vec2(0.4f, 0.0f);
    protected final List<ItemStack> compactInventoryList = new ArrayList<ItemStack>();
    protected final UIAccessor accessor = UIAccessor.of((Screen)this);
    private final ContainerListener listener;
    protected List<RecipeIconHolder<StonecutterRecipe>> craftingButtons = new ArrayList<RecipeIconHolder<StonecutterRecipe>>();
    protected List<List<RecipeInfo<StonecutterRecipe>>> recipesByGroup = new ArrayList<List<RecipeInfo<StonecutterRecipe>>>();
    protected List<List<RecipeInfo<StonecutterRecipe>>> filteredRecipesByGroup = Collections.emptyList();
    protected Stocker.Sizeable craftingButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    protected List<Optional<Ingredient>> ingredientSlot = Collections.singletonList(Optional.empty());
    protected int selectedCraftingButton = 0;
    private boolean onlyCraftableRecipes;

    public LegacyStonecutterScreen(LegacyCraftingMenu abstractContainerMenu, final Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        List<RecipeInfo> allRecipes = CommonRecipeManager.byType((RecipeType)RecipeType.STONECUTTING).stream().map(h -> RecipeInfo.create(h.id(), (StonecutterRecipe)h.value(), LegacyCraftingMenu.getRecipeOptionalIngredients(h.value()), ((StonecutterRecipe)h.value()).assemble(null, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()))).toList();
        StoneCuttingGroupManager.listing.values().forEach(l -> {
            ArrayList group = new ArrayList();
            l.forEach(v -> v.addRecipes(allRecipes.stream().filter(h -> this.recipesByGroup.stream().noneMatch(r -> r.contains(h)))::iterator, group::add));
            if (!group.isEmpty()) {
                this.recipesByGroup.add(group);
            }
        });
        allRecipes.stream().filter(h -> this.recipesByGroup.stream().noneMatch(r -> r.contains(h))).forEach(h -> this.recipesByGroup.add(Collections.singletonList(h)));
        this.addCraftingButtons();
        this.onlyCraftableRecipes = true;
        this.listener = new ContainerListener(){

            public void slotChanged(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
                if (LegacyStonecutterScreen.this.onlyCraftableRecipes) {
                    LegacyStonecutterScreen.this.filteredRecipesByGroup = LegacyStonecutterScreen.this.recipesByGroup.stream().map(l -> l.stream().filter(r -> RecipeMenu.canCraft(r.getOptionalIngredients(), inventory, abstractContainerMenu.getCarried())).toList()).filter(l -> !l.isEmpty()).toList();
                    LegacyStonecutterScreen.this.craftingButtons.get(LegacyStonecutterScreen.this.selectedCraftingButton).updateRecipeDisplay();
                }
            }

            public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int j) {
            }
        };
        this.listener.slotChanged(this.menu, 0, ItemStack.EMPTY);
        this.onlyCraftableRecipes = false;
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
        renderer.add(() -> ControlTooltip.OPTION.get(), () -> this.onlyCraftableRecipes ? LegacyComponents.ALL_RECIPES : LegacyComponents.SHOW_CRAFTABLE_RECIPES);
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings(BindingState state) {
        return !state.is(ControllerBinding.DOWN_BUTTON) && Controller.Event.super.onceClickBindings(state);
    }

    public void init() {
        this.imageWidth = 348;
        this.imageHeight = 215;
        super.init();
        LegacySlotDisplay display = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return 16;
            }

            @Override
            public Vec2 getOffset() {
                return ((LegacyCraftingMenu)((LegacyStonecutterScreen)LegacyStonecutterScreen.this).menu).inventoryOffset;
            }

            @Override
            public boolean isVisible() {
                return ((LegacyCraftingMenu)((LegacyStonecutterScreen)LegacyStonecutterScreen.this).menu).inventoryActive;
            }
        };
        for (int i = 0; i < 36; ++i) {
            Slot s = (Slot)((LegacyCraftingMenu)this.menu).slots.get(i);
            if (i < 27) {
                LegacySlotDisplay.override(s, 186 + (s.getContainerSlot() - 9) % 9 * 16, 133 + (s.getContainerSlot() - 9) / 9 * 16, display);
                continue;
            }
            LegacySlotDisplay.override(s, 186 + s.getContainerSlot() * 16, 186, display);
        }
        ((LegacyCraftingMenu)this.menu).addSlotListener(this.listener);
        if (this.selectedCraftingButton < this.craftingButtons.size()) {
            this.setFocused(this.craftingButtons.get(this.selectedCraftingButton));
        }
        int craftingButtonsX = this.accessor.getInteger("craftingButtons.x", 13);
        int craftingButtonsY = this.accessor.getInteger("craftingButtons.y", 38);
        int craftingButtonsSize = this.accessor.getInteger("craftingButtons.size", 27);
        this.craftingButtons.forEach(b -> {
            b.width = b.height = craftingButtonsSize;
            b.setPos(this.leftPos + craftingButtonsX + this.craftingButtons.indexOf(b) * craftingButtonsSize, this.topPos + craftingButtonsY);
            this.addRenderableWidget((GuiEventListener)b);
        });
        this.craftingButtonsOffset.max = Math.max(0, this.recipesByGroup.size() - 12);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    public void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        LegacyFontUtil.applySDFont(b -> {
            guiGraphics.drawString(this.font, this.title, (this.imageWidth - this.font.width((FormattedText)this.title)) / 2, this.accessor.getInteger("title.y", 17), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            int inventoryPanelX = this.accessor.getInteger("inventoryPanel.x", 176);
            int bottomPanelY = this.accessor.getInteger("bottomPanel.y", 103);
            int inventoryPanelWidth = this.accessor.getInteger("inventoryPanel.width", 163);
            guiGraphics.drawString(this.font, this.playerInventoryTitle, inventoryPanelX + (inventoryPanelWidth - this.font.width((FormattedText)this.playerInventoryTitle)) / 2, bottomPanelY + this.accessor.getInteger("inventoryTitle.y", 11), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        });
    }

    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        boolean sd = LegacyOptions.getUIMode().isSD();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.accessor.getResourceLocation("imageSprite", LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        int bottomPanelHeight = this.accessor.getInteger("bottomPanel.height", 105);
        int panelWidth = this.accessor.getInteger("craftingGridPanel.width", 163);
        int bottomPanelY = this.accessor.getInteger("bottomPanel.y", 103);
        int craftingGridPanelX = this.accessor.getInteger("craftingGridPanel.x", 9);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + craftingGridPanelX, this.topPos + bottomPanelY, panelWidth, bottomPanelHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + this.accessor.getInteger("inventoryPanel.x", 176), this.topPos + bottomPanelY, this.accessor.getInteger("inventoryPanel.width", 163), bottomPanelHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(sd ? LegacySprites.SMALL_ARROW : LegacySprites.ARROW, this.leftPos + craftingGridPanelX + this.accessor.getInteger("craftingArrow.x", 70), this.topPos + bottomPanelY + this.accessor.getInteger("craftingArrow.y", 55), sd ? 16 : 22, sd ? 14 : 15);
        if ((Integer)this.craftingButtonsOffset.get() > 0) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.accessor.getInteger("horizontalScroll.x", this.leftPos + 5), this.topPos + 45);
        }
        if (this.craftingButtonsOffset.max > 0 && (Integer)this.craftingButtonsOffset.get() < this.craftingButtonsOffset.max) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.leftPos + this.imageWidth - 11, this.topPos + 45);
        }
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.renderTooltip(guiGraphics, i, j);
    }

    public void renderContents(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderContents(guiGraphics, i, j, f);
        this.craftingButtons.get(this.selectedCraftingButton).renderSelection(guiGraphics, i, j, f);
        this.craftingButtons.forEach(h -> h.renderTooltip(this.minecraft, guiGraphics, i, j));
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.getChildAt(d, e).filter(guiEventListener -> guiEventListener.mouseScrolled(d, e, f, g)).isPresent()) {
            return true;
        }
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.craftingButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.craftingButtonsOffset.max > 0) && this.craftingButtonsOffset.add(scroll, false) != 0) {
            this.repositionElements();
            return true;
        }
        return false;
    }

    public void removed() {
        super.removed();
        ((LegacyCraftingMenu)this.menu).removeSlotListener(this.listener);
    }

    @Unique
    protected void addCraftingButtons() {
        for (int i = 0; i < 12; ++i) {
            final int index = i;
            RecipeIconHolder<StonecutterRecipe> h = new RecipeIconHolder<StonecutterRecipe>(this.leftPos + 13 + i * 27, this.topPos + 38){

                @Override
                public void render(GuiGraphics graphics, int i, int j, float f) {
                    if (this.isFocused()) {
                        LegacyStonecutterScreen.this.selectedCraftingButton = index;
                    }
                    super.render(graphics, i, j, f);
                }

                @Override
                protected boolean canCraft(RecipeInfo<StonecutterRecipe> rcp) {
                    if (rcp == null || LegacyStonecutterScreen.this.onlyCraftableRecipes) {
                        return true;
                    }
                    LegacyStonecutterScreen.this.compactInventoryList.clear();
                    RecipeMenu.handleCompactInventoryList(LegacyStonecutterScreen.this.compactInventoryList, Minecraft.getInstance().player.getInventory(), ((LegacyCraftingMenu)LegacyStonecutterScreen.this.menu).getCarried());
                    return LegacyCraftingScreen.canCraft(LegacyStonecutterScreen.this.compactInventoryList, this.isFocused() && this.getFocusedRecipe() == rcp ? LegacyStonecutterScreen.this.ingredientSlot : rcp.getOptionalIngredients(), null);
                }

                @Override
                protected List<RecipeInfo<StonecutterRecipe>> getRecipes() {
                    List<List<RecipeInfo<StonecutterRecipe>>> list = LegacyStonecutterScreen.this.onlyCraftableRecipes ? LegacyStonecutterScreen.this.filteredRecipesByGroup : LegacyStonecutterScreen.this.recipesByGroup;
                    return list.size() <= (Integer)LegacyStonecutterScreen.this.craftingButtonsOffset.get() + index ? Collections.emptyList() : list.get((Integer)LegacyStonecutterScreen.this.craftingButtonsOffset.get() + index);
                }

                @Override
                public LegacyScrollRenderer getScrollRenderer() {
                    return LegacyStonecutterScreen.this.scrollRenderer;
                }

                @Override
                protected void updateRecipeDisplay(RecipeInfo<StonecutterRecipe> rcp) {
                    LegacyStonecutterScreen.this.ingredientSlot = rcp == null ? Collections.singletonList(Optional.empty()) : rcp.getOptionalIngredients();
                }

                @Override
                protected void toggleCraftableRecipes(InputWithModifiers input) {
                    LegacyStonecutterScreen.this.listener.slotChanged(LegacyStonecutterScreen.this.menu, 0, ItemStack.EMPTY);
                    LegacyStonecutterScreen.this.onlyCraftableRecipes = !LegacyStonecutterScreen.this.onlyCraftableRecipes;
                }

                @Override
                public boolean keyPressed(KeyEvent keyEvent) {
                    if (this.controlCyclicNavigation(keyEvent.key(), index, LegacyStonecutterScreen.this.craftingButtons, LegacyStonecutterScreen.this.craftingButtonsOffset, LegacyStonecutterScreen.this.scrollRenderer, (Screen)LegacyStonecutterScreen.this)) {
                        return true;
                    }
                    return super.keyPressed(keyEvent);
                }

                @Override
                public void renderSelection(GuiGraphics graphics, int i, int j, float f) {
                    boolean warning = !this.canCraft(this.getFocusedRecipe());
                    int xDiff = LegacyStonecutterScreen.this.leftPos + LegacyStonecutterScreen.this.accessor.getInteger("craftingGridPanel.x", 9);
                    int yDiff = LegacyStonecutterScreen.this.topPos + LegacyStonecutterScreen.this.accessor.getInteger("bottomPanel.y", 103);
                    int panelWidth = LegacyStonecutterScreen.this.accessor.getInteger("craftingGridPanel.width", 163);
                    int stonecutterSlotSize = LegacyStonecutterScreen.this.accessor.getInteger("stonecutterSlot.size", 36);
                    LegacyIconHolder input = LegacyRenderUtil.iconHolderRenderer.itemHolder(xDiff + LegacyStonecutterScreen.this.accessor.getInteger("inputSlot.x", 29), yDiff + LegacyStonecutterScreen.this.accessor.getInteger("inputSlot.y", 43), stonecutterSlotSize, stonecutterSlotSize, 3.getActualItem(LegacyStonecutterScreen.this.ingredientSlot.get(0)), !LegacyStonecutterScreen.this.onlyCraftableRecipes && !LegacyStonecutterScreen.this.ingredientSlot.get(0).isEmpty() && warning, LegacyRenderUtil.hasHorizontalArtifacts() ? ALT_DISPLAY_OFFSET : DISPLAY_OFFSET);
                    input.render(graphics, i, j, f);
                    input.renderTooltip(this.minecraft, graphics, i, j);
                    LegacyIconHolder output = LegacyRenderUtil.iconHolderRenderer.itemHolder(xDiff + LegacyStonecutterScreen.this.accessor.getInteger("resultSlot.x", 101), yDiff + LegacyStonecutterScreen.this.accessor.getInteger("resultSlot.y", 43), stonecutterSlotSize, stonecutterSlotSize, this.getFocusedResult(), warning, LegacyRenderUtil.hasHorizontalArtifacts() ? ALT_DISPLAY_OFFSET : DISPLAY_OFFSET);
                    output.render(graphics, i, j, f);
                    output.renderTooltip(this.minecraft, graphics, i, j);
                    if (this.getFocusedRecipe() != null) {
                        Component resultName = this.getFocusedRecipe().getName();
                        int titleY = yDiff + LegacyStonecutterScreen.this.accessor.getInteger("craftingTitle.y", 11);
                        LegacyFontUtil.applySDFont(b -> LegacyRenderUtil.renderScrollingString(graphics, LegacyStonecutterScreen.this.font, resultName, xDiff + 2 + Math.max(panelWidth - LegacyStonecutterScreen.this.font.width((FormattedText)resultName), 0) / 2, titleY, xDiff + panelWidth - 2, titleY + 11, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false));
                    }
                    super.renderSelection(graphics, i, j, f);
                }
            };
            this.craftingButtons.add(h);
            h.offset = LegacyCraftingMenu.DEFAULT_INVENTORY_OFFSET;
            h.allowItemDecorations = false;
        }
    }
}

