/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.init.LegacyGameRules;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Unique
    private Entity self() {
        return (Entity)this;
    }

    @Inject(method={"setCustomName"}, at={@At(value="RETURN")})
    public void setCustomName(Component component, CallbackInfo ci) {
        Entity entity = this.self();
        if (entity instanceof Mob) {
            Mob m = (Mob)entity;
            m.setPersistenceRequired();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ModifyExpressionValue(method={"updateSwimming"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isUnderWater()Z")})
    protected boolean updateSwimming(boolean original) {
        Entity entity;
        if (this.self().level().isClientSide() || !this.self().level().getServer().getGameRules().getBoolean(LegacyGameRules.LEGACY_SWIMMING) || !this.self().isInWater() || !(this.self().getXRot() > 0.0f)) {
            if (!original) return false;
        }
        if (!((entity = this.self()) instanceof Player)) return true;
        Player p = (Player)entity;
        if (p.getAbilities().flying) return false;
        return true;
    }
}

