/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.GuiRenderer;
import net.minecraft.client.gui.render.pip.GuiEntityRenderer;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.GuiItemRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.pip.GuiEntityRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyGuiEntityRenderer;
import wily.legacy.client.LegacyGuiItemRenderState;
import wily.legacy.client.LegacyGuiItemRenderer;
import wily.legacy.client.LegacyOptions;

@Mixin(value={GuiRenderer.class})
public class GuiRendererMixin {
    @Shadow
    @Final
    GuiRenderState renderState;
    @Shadow
    @Final
    private MultiBufferSource.BufferSource bufferSource;
    @Shadow
    private int frameNumber;
    @Shadow
    @Final
    private SubmitNodeCollector submitNodeCollector;
    @Shadow
    @Final
    private FeatureRenderDispatcher featureRenderDispatcher;
    @Unique
    private Long2ObjectMap<LegacyGuiItemRenderer> guiItemRenderers = new Long2ObjectArrayMap();
    @Unique
    private List<GuiEntityRenderer> guiEntityRenderers;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    void initTail(GuiRenderState guiRenderState, MultiBufferSource.BufferSource bufferSource, SubmitNodeCollector submitNodeCollector, FeatureRenderDispatcher featureRenderDispatcher, List list, CallbackInfo ci) {
        this.guiEntityRenderers = List.of(new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()), new GuiEntityRenderer(bufferSource, Minecraft.getInstance().getEntityRenderDispatcher()));
    }

    @Inject(method={"prepareItemElements"}, at={@At(value="HEAD")})
    private void prepareItemElementsHead(CallbackInfo ci) {
        if (this.guiItemRenderers == null) {
            Legacy4J.LOGGER.error("that can't be!");
            this.guiItemRenderers = new Long2ObjectArrayMap();
        }
        this.guiItemRenderers.forEach((i, renderer) -> renderer.markInvalid());
    }

    @ModifyArg(method={"prepareItemElements"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/render/state/GuiRenderState;forEachItem(Ljava/util/function/Consumer;)V"))
    private Consumer<GuiItemRenderState> prepareItemElements(Consumer<GuiItemRenderState> consumer) {
        return renderState -> {
            LegacyGuiItemRenderState legacyRenderState = LegacyGuiItemRenderState.of(renderState);
            if (legacyRenderState.size() == 16 && (double)legacyRenderState.opacity() == 1.0) {
                consumer.accept((GuiItemRenderState)renderState);
            } else {
                ((LegacyGuiItemRenderer)this.guiItemRenderers.computeIfAbsent((long)legacyRenderState.size() << 32 | (long)Float.floatToIntBits((Boolean)LegacyOptions.enhancedItemTranslucency.get() != false ? 1.0f : legacyRenderState.opacity()) & 0xFFFFFFFFL, LegacyGuiItemRenderer::new)).markValid();
            }
        };
    }

    @Inject(method={"prepareItemElements"}, at={@At(value="RETURN")})
    private void prepareItemElements(CallbackInfo ci) {
        ObjectIterator iter = this.guiItemRenderers.values().iterator();
        while (iter.hasNext()) {
            LegacyGuiItemRenderer renderer = (LegacyGuiItemRenderer)iter.next();
            if (renderer.isValid()) {
                renderer.prepareItemElements(this.featureRenderDispatcher, this.submitNodeCollector, this.bufferSource, this.renderState, this.frameNumber);
                continue;
            }
            renderer.close();
            iter.remove();
        }
    }

    @Inject(method={"close"}, at={@At(value="RETURN")}, remap=false)
    private void close(CallbackInfo ci) {
        this.guiItemRenderers.forEach((i, renderer) -> renderer.close());
        this.guiEntityRenderers.forEach(PictureInPictureRenderer::close);
    }

    @Inject(method={"preparePictureInPicture"}, at={@At(value="HEAD")})
    void preparePictureInPicture(CallbackInfo ci) {
        for (GuiEntityRenderer guiEntityRenderer : this.guiEntityRenderers) {
            LegacyGuiEntityRenderer.of(guiEntityRenderer).available();
        }
    }

    @Inject(method={"preparePictureInPictureState"}, at={@At(value="HEAD")}, cancellable=true)
    void preparePictureInPictureState(PictureInPictureRenderState arg, int i, CallbackInfo ci) {
        if (arg.getClass() == GuiEntityRenderState.class) {
            GuiEntityRenderer guiEntityRenderer = this.guiEntityRenderers.stream().map(LegacyGuiEntityRenderer::of).filter(LegacyGuiEntityRenderer::isAvailable).findFirst().map(a -> (GuiEntityRenderer)a).orElse(this.guiEntityRenderers.get(0));
            LegacyGuiEntityRenderer.of(guiEntityRenderer).use();
            guiEntityRenderer.prepare((PictureInPictureRenderState)((GuiEntityRenderState)arg), this.renderState, i);
            ci.cancel();
        }
    }
}

