/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.furnace;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractFurnaceMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

@Mixin(value={AbstractFurnaceScreen.class})
public abstract class AbstractFurnaceScreenMixin<T extends AbstractFurnaceMenu>
extends AbstractContainerScreen<T> {
    public AbstractFurnaceScreenMixin(T abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
    }

    public void added() {
        super.added();
        ControlTooltip.Renderer.of((Object)this).replace(3, i -> i, c -> this.hoveredSlot == null || this.hoveredSlot.getItem().isEmpty() || this.hoveredSlot.container != this.minecraft.player.getInventory() ? c : (((AbstractFurnaceMenu)this.menu).canSmelt(this.hoveredSlot.getItem()) ? LegacyComponents.MOVE_INGREDIENT : (this.minecraft.level.fuelValues().isFuel(this.hoveredSlot.getItem()) ? LegacyComponents.MOVE_FUEL : c)));
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        final boolean sd = LegacyOptions.getUIMode().isSD();
        this.imageWidth = sd ? 130 : 214;
        this.imageHeight = sd ? 145 : 215;
        this.inventoryLabelX = sd ? 7 : 14;
        this.inventoryLabelY = sd ? 71 : 98;
        this.titleLabelX = sd ? 7 : 14;
        this.titleLabelY = sd ? 5 : 11;
        final int slotsSize = sd ? 13 : 21;
        LegacySlotDisplay defaultDisplay = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return slotsSize;
            }
        };
        LegacySlotDisplay furnaceDisplay = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return sd ? 17 : 21;
            }
        };
        super.init();
        for (int i = 0; i < ((AbstractFurnaceMenu)this.menu).slots.size(); ++i) {
            Slot s = (Slot)((AbstractFurnaceMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, sd ? 62 : 77, sd ? 16 : 25, furnaceDisplay);
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, sd ? 62 : 77, sd ? 50 : 72, furnaceDisplay);
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s, sd ? 102 : 155, sd ? 30 : 44, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return sd ? 21 : 32;
                    }
                });
                continue;
            }
            if (i < ((AbstractFurnaceMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, this.inventoryLabelX + (s.getContainerSlot() - 9) % 9 * slotsSize, (sd ? 81 : 111) + (s.getContainerSlot() - 9) / 9 * slotsSize, defaultDisplay);
                continue;
            }
            LegacySlotDisplay.override(s, this.inventoryLabelX + s.getContainerSlot() * slotsSize, sd ? 125 : 180, defaultDisplay);
        }
    }

    @Inject(method={"getRecipeBookButtonPosition"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getRecipeBookButtonPosition(CallbackInfoReturnable<ScreenPosition> cir) {
        cir.setReturnValue((Object)new ScreenPosition(this.leftPos + (LegacyOptions.getUIMode().isSD() ? 39 : 49), this.topPos + (LegacyOptions.getUIMode().isSD() ? 30 : 49)));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        LegacyFontUtil.applySDFont(b -> {
            super.renderLabels(guiGraphics, i, j);
            MutableComponent ingredient = Component.translatable((String)"legacy.container.ingredient");
            guiGraphics.drawString(this.font, (Component)ingredient, (b != false ? 57 : 70) - this.font.width((FormattedText)ingredient), b != false ? 19 : 32, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            MutableComponent fuel = Component.translatable((String)"legacy.container.fuel");
            guiGraphics.drawString(this.font, (Component)fuel, (b != false ? 57 : 70) - this.font.width((FormattedText)fuel), b != false ? 53 : 79, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        });
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        boolean sd = LegacyOptions.getUIMode().isSD();
        int guiScale = this.minecraft.getWindow().getGuiScale();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(UIAccessor.of((Screen)this).getResourceLocation("imageSprite", sd ? LegacySprites.PANEL : LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.leftPos + (sd ? 63.0f : (LegacyRenderUtil.hasHorizontalArtifacts() ? 75.4f : 75.5f)), (float)this.topPos + (sd ? 34.0f : 46.4f));
        int flameSize = sd ? 14 : 21;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LIT, 0, 0, flameSize, flameSize);
        if (((AbstractFurnaceMenu)this.menu).isLit()) {
            guiGraphics.pose().scale(1.0f / (float)guiScale, 1.0f / (float)guiScale);
            int scaledSize = flameSize * guiScale;
            int n = Mth.ceil((float)(((AbstractFurnaceMenu)this.menu).getLitProgress() * (float)(scaledSize - guiScale))) + guiScale;
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LIT_PROGRESS, scaledSize, scaledSize, 0, scaledSize - n, 0, scaledSize - n, scaledSize, n);
        }
        guiGraphics.pose().popMatrix();
        boolean fhd = LegacyOptions.getUIMode().isFHD();
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)(this.leftPos + (sd ? 82 : (fhd ? 109 : 114))), (float)(this.topPos + (sd ? 33 : 47)));
        int arrowWidth = sd ? 16 : 33;
        int arrowHeight = sd ? 14 : 24;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(sd ? LegacySprites.SMALL_ARROW : LegacySprites.ARROW, 0, 0, arrowWidth, arrowHeight);
        guiGraphics.pose().scale(1.0f / (float)guiScale, 1.0f / (float)guiScale);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(sd ? LegacySprites.FULL_SMALL_ARROW : (fhd ? LegacySprites.FULL_ARROW_1080 : LegacySprites.FULL_ARROW), arrowWidth * guiScale, arrowHeight * guiScale, 0, 0, 0, 0, (int)Math.ceil(((AbstractFurnaceMenu)this.menu).getBurnProgress() * (float)arrowWidth * (float)guiScale), arrowHeight * guiScale);
        guiGraphics.pose().popMatrix();
    }
}

