/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.config.FactoryMixinToggle;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.base.network.CommonRecipeManager;
import wily.legacy.Legacy4JClient;
import wily.legacy.block.LegacyBlockBehaviors;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.config.LegacyMixinToggles;
import wily.legacy.config.LegacyWorldOptions;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyGameRules;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.network.ClientAdvancementsPayload;
import wily.legacy.network.ClientAnimalInLoveSyncPayload;
import wily.legacy.network.ClientEffectActivationPayload;
import wily.legacy.network.ClientMerchantTradingPayload;
import wily.legacy.network.PlayerInfoSync;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.network.ServerOpenClientMenuPayload;
import wily.legacy.network.ServerPlayerMissHitPayload;
import wily.legacy.network.TipCommand;
import wily.legacy.network.TopMessage;
import wily.legacy.util.ArmorStandPose;

@Mod(value="legacy")
public class Legacy4J {
    public static final String MOD_ID = "legacy";
    public static final Supplier<String> VERSION = () -> FactoryAPIPlatform.getModInfo((String)MOD_ID).getVersion();
    public static final Logger LOGGER = LogManager.getLogger((String)"legacy");
    public static final FactoryConfig.StorageHandler MIXIN_CONFIGS_STORAGE = FactoryConfig.StorageHandler.fromMixin((FactoryMixinToggle.Storage)LegacyMixinToggles.COMMON_STORAGE, (boolean)true);
    private static Collection<CommonNetwork.Payload> playerInitialPayloads = Collections.emptySet();

    public Legacy4J() {
        Legacy4J.init();
        if (FactoryAPI.isClient()) {
            Legacy4JClient.init();
        }
    }

    public static List<Integer> getParsedVersion(String version) {
        String[] versions;
        ArrayList<Integer> parsedVersion = new ArrayList<Integer>();
        for (String s : versions = version.split("[.\\-]")) {
            int value;
            try {
                value = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            parsedVersion.add(value);
        }
        return parsedVersion;
    }

    public static boolean isNewerVersion(String actualVersion, String previous) {
        return Legacy4J.isNewerVersion(actualVersion, previous, 2);
    }

    public static boolean isNewerVersion(String actualVersion, String previous, int limitCount) {
        List<Integer> v = Legacy4J.getParsedVersion(actualVersion);
        List<Integer> v1 = Legacy4J.getParsedVersion(previous);
        int size = limitCount <= 0 ? v.size() : Math.min(limitCount, v.size());
        for (int i = 0; i < size; ++i) {
            if (v.get(i) <= (v1.size() <= i ? 0 : v1.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void init() {
        FactoryConfig.registerCommonStorage((ResourceLocation)Legacy4J.createModLocation("common"), (FactoryConfig.StorageHandler)LegacyCommonOptions.COMMON_STORAGE);
        FactoryConfig.registerCommonStorage((ResourceLocation)Legacy4J.createModLocation("mixin_common"), (FactoryConfig.StorageHandler)MIXIN_CONFIGS_STORAGE);
        LegacyRegistries.register();
        LegacyGameRules.init();
        FactoryEvent.registerPayload(r -> {
            r.register(false, ClientAdvancementsPayload.ID);
            r.register(false, ClientAnimalInLoveSyncPayload.ID);
            r.register(false, ClientEffectActivationPayload.ID);
            r.register(true, ClientMerchantTradingPayload.ID_C2S);
            r.register(false, ClientMerchantTradingPayload.ID_S2C);
            r.register(true, PlayerInfoSync.ID);
            r.register(true, PlayerInfoSync.All.ID_C2S);
            r.register(false, PlayerInfoSync.All.ID_S2C);
            r.register(true, ServerMenuCraftPayload.ID);
            r.register(true, ServerOpenClientMenuPayload.ID);
            r.register(true, ServerPlayerMissHitPayload.ID);
            r.register(false, TipCommand.Payload.ID);
            r.register(false, TipCommand.EntityPayload.ID);
            r.register(false, TopMessage.Payload.ID);
        });
        ArmorStandPose.init();
        FactoryEvent.setItemComponent((Item)Items.CAKE, (DataComponentType)DataComponents.MAX_STACK_SIZE, (Object)64);
        FactoryEvent.registerCommands(TipCommand::register);
        FactoryEvent.setup(Legacy4J::setup);
        FactoryEvent.tagsLoaded(Legacy4J::tagsLoaded);
        FactoryEvent.serverStarted(Legacy4J::onServerStart);
        FactoryEvent.PlayerEvent.JOIN_EVENT.register(Legacy4J::onServerPlayerJoin);
        FactoryEvent.PlayerEvent.RELOAD_RESOURCES_EVENT.register(Legacy4J::onResourcesReload);
    }

    public static ResourceLocation createModLocation(String path) {
        return FactoryAPI.createLocation((String)MOD_ID, (String)path);
    }

    public static void setup() {
        LegacyCommonOptions.COMMON_STORAGE.load();
        CommonRecipeManager.addRecipeTypeToSync((RecipeType)RecipeType.CRAFTING);
        CommonRecipeManager.addRecipeTypeToSync((RecipeType)RecipeType.STONECUTTING);
        LegacyBlockBehaviors.setup();
    }

    public static boolean isChunkPosVisibleInSquare(int centerX, int centerZ, int viewDistance, int x, int z, boolean offset) {
        int n = Math.max(0, Math.abs(x - centerX) - 1);
        int o = Math.max(0, Math.abs(z - centerZ) - 1);
        long p = Math.max(0, Math.max(n, o) - (offset ? 1 : 0));
        long q = Math.min(n, o);
        return Math.max(p, q) < (long)viewDistance;
    }

    public static void tagsLoaded() {
        LegacyBlockBehaviors.registerDyedWaterCauldronInteraction(CauldronInteraction.WATER.map());
    }

    public static Vec3 getRelativeMovement(LivingEntity entity, float f, Vec3 vec3, int relRot) {
        double d = (vec3 = Legacy4J.getNormal(vec3, Math.toRadians(relRot))).lengthSqr();
        if (d < 1.0E-7) {
            return Vec3.ZERO;
        }
        Vec3 vec32 = (d > 1.0 ? vec3.normalize() : vec3).scale((double)f);
        double angle = Math.toRadians(relRot == 0 ? (double)entity.getYRot() : (double)(Math.round(entity.getYRot() / (float)relRot) * relRot));
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        return new Vec3(vec32.x * cos - vec32.z * sin, vec32.y, vec32.z * cos + vec32.x * sin);
    }

    public static Vec3 getNormal(Vec3 vec3, double relRot) {
        if (relRot == 0.0) {
            return vec3;
        }
        double angleRad = Math.atan2(vec3.z, vec3.x);
        double quantizedAngle = (double)Math.round(angleRad / relRot) * relRot;
        double length = vec3.length();
        return new Vec3(length * Math.cos(quantizedAngle), vec3.y, length * Math.sin(quantizedAngle));
    }

    public static void onServerPlayerJoin(ServerPlayer p) {
        MinecraftServer server = FactoryAPIPlatform.getEntityServer((Entity)p);
        if (server == null) {
            return;
        }
        int pos = 0;
        boolean b = true;
        block0: while (b) {
            b = false;
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                if (player == p || ((LegacyPlayerInfo)player).getIdentifierIndex() != pos) continue;
                ++pos;
                b = true;
                continue block0;
            }
        }
        ((LegacyPlayerInfo)p).setIdentifierIndex(pos);
        CommonNetwork.sendToPlayers((Collection)server.getPlayerList().getPlayers().stream().filter(sp -> sp != p).collect(Collectors.toSet()), (CommonNetwork.Payload)new PlayerInfoSync.All(Map.of(p.getUUID(), (LegacyPlayerInfo)p), Collections.emptyMap(), server.getDefaultGameType(), PlayerInfoSync.All.ID_S2C));
        CommonNetwork.sendToPlayer((ServerPlayer)p, (CommonNetwork.Payload)PlayerInfoSync.All.fromPlayerList(server), (boolean)true);
        playerInitialPayloads.forEach(payload -> CommonNetwork.sendToPlayer((ServerPlayer)p, (CommonNetwork.Payload)payload, (boolean)true));
        if (!FactoryAPIPlatform.getEntityServer((Entity)p).isDedicatedServer()) {
            Legacy4JClient.serverPlayerJoin(p);
        }
    }

    public static void onServerStart(MinecraftServer server) {
        playerInitialPayloads = Legacy4J.createPlayerInitialPayloads(server);
        LegacyWorldOptions.WORLD_STORAGE.withServerFile(server, "legacy_data.json").resetAndLoad();
    }

    public static void onResourcesReload(PlayerList playerList) {
        Legacy4J.onServerStart(playerList.getServer());
        playerInitialPayloads.forEach(payload -> CommonNetwork.sendToPlayers((Collection)playerList.getPlayers(), (CommonNetwork.Payload)payload));
    }

    public static Collection<CommonNetwork.Payload> createPlayerInitialPayloads(MinecraftServer server) {
        HashSet<CommonNetwork.Payload> payloads = new HashSet<CommonNetwork.Payload>();
        payloads.add(new ClientAdvancementsPayload(List.copyOf(server.getAdvancements().getAllAdvancements())));
        return payloads;
    }

    public static void copySaveToDirectory(InputStream stream, File directory) {
        if (directory.exists()) {
            FileUtils.deleteQuietly((File)directory);
        }
        try (ZipInputStream inputStream = new ZipInputStream(stream);){
            ZipEntry zipEntry;
            byte[] buffer = new byte[1024];
            while ((zipEntry = inputStream.getNextEntry()) != null) {
                int len;
                File newFile = new File(directory, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (newFile.isDirectory() || newFile.mkdirs()) continue;
                    throw new IOException("Failed to create directory " + String.valueOf(newFile));
                }
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + String.valueOf(parent));
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = inputStream.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

