/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.sounds.SoundEvent;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.controller.Controller;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.client.LegacySoundUtil;

public interface NavigationElement {
    public static final NavigationElement DEFAULT = new NavigationElement(){};

    public static NavigationElement of(GuiEventListener listener) {
        NavigationElement element;
        return listener instanceof NavigationElement ? (element = (NavigationElement)listener) : DEFAULT;
    }

    default public void playFocusSound(ComponentPath.Path path) {
        if (Legacy4JClient.controllerManager.isCursorDisabled || Controller.Event.of(path.component()).disableCursorOnWidgets()) {
            LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
        }
    }

    default public void applyFocus(ComponentPath.Path path, boolean apply) {
        boolean disableCursor = Controller.Event.of(path.component()).disableCursorOnWidgets();
        if (Legacy4JClient.controllerManager.isCursorDisabled || disableCursor) {
            if (!apply) {
                path.component().setFocused(null);
            } else {
                path.component().setFocused(path.childPath().component());
            }
            path.childPath().applyFocus(apply);
            if (disableCursor && apply) {
                Legacy4JClient.controllerManager.disableCursor();
            }
        } else if (apply) {
            path.component().setFocused(null);
            ScreenRectangle rect = path.childPath().component().getRectangle();
            Legacy4JClient.controllerManager.setPointerPos(rect.getCenterInAxis(ScreenAxis.HORIZONTAL), rect.getCenterInAxis(ScreenAxis.VERTICAL));
        }
    }
}

