/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.StackIngredient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.base.network.CommonRecipeManager;
import wily.factoryapi.util.FactoryItemUtil;
import wily.legacy.client.LegacyGuiItemRenderer;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public abstract class CustomRecipeIconHolder
extends LegacyIconHolder
implements ControlTooltip.ActionHolder {
    final ItemStack defaultItem;
    private final Minecraft minecraft;
    ItemStack nextItem = ItemStack.EMPTY;
    ItemStack previousItem = ItemStack.EMPTY;
    List<ItemStack> addedIngredientsItems = null;
    Predicate<CustomRecipeIconHolder> canAddIngredient = h -> true;

    public CustomRecipeIconHolder(ItemStack defaultItem) {
        super(27, 27);
        this.minecraft = Minecraft.getInstance();
        this.allowItemDecorations = false;
        this.defaultItem = this.itemIcon = defaultItem;
    }

    public CustomRecipeIconHolder() {
        this(ItemStack.EMPTY);
    }

    public void init() {
        this.itemIcon = this.defaultItem;
    }

    public void applyAddedIngredients() {
        if (this.addedIngredientsItems == null || this.addedIngredientsItems.isEmpty()) {
            return;
        }
        int index = 0;
        for (int i1 = 0; i1 < this.getIngredientsGrid().size() && index < this.addedIngredientsItems.size(); ++i1) {
            Optional<Ingredient> ing = this.getIngredientsGrid().get(i1);
            if (ing.isPresent()) continue;
            this.getIngredientsGrid().set(i1, Optional.of(StackIngredient.of((boolean)false, (ItemStack)this.addedIngredientsItems.get(index))));
            ++index;
        }
    }

    public boolean applyNextItemIfAbsent() {
        return false;
    }

    public CustomRecipeIconHolder enableAddIngredients() {
        this.addedIngredientsItems = new ArrayList<ItemStack>();
        return this;
    }

    public CustomRecipeIconHolder enableAddIngredients(Predicate<CustomRecipeIconHolder> canAddIngredient) {
        this.canAddIngredient = canAddIngredient;
        return this.enableAddIngredients();
    }

    public ItemStack nextItem(Inventory inventory, Predicate<ItemStack> isValid) {
        int i;
        NonNullList items = inventory.getNonEquipmentItems();
        for (i = Math.max(0, items.indexOf(this.itemIcon)); i < items.size(); ++i) {
            if (this.itemIcon == items.get(i) || !isValid.test((ItemStack)items.get(i))) continue;
            return (ItemStack)items.get(i);
        }
        for (i = 0; i < Math.max(0, items.indexOf(this.itemIcon)); ++i) {
            if (this.itemIcon == items.get(i) || !isValid.test((ItemStack)items.get(i))) continue;
            return (ItemStack)items.get(i);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack previousItem(Inventory inventory, Predicate<ItemStack> isValid) {
        int i;
        NonNullList items = inventory.getNonEquipmentItems();
        for (i = Math.max(0, items.indexOf(this.itemIcon)); i >= 0; --i) {
            if (this.itemIcon == items.get(i) || !isValid.test((ItemStack)items.get(i))) continue;
            return (ItemStack)items.get(i);
        }
        for (i = items.size() - 1; i >= Math.max(0, items.indexOf(this.itemIcon)); --i) {
            if (this.itemIcon == items.get(i) || !isValid.test((ItemStack)items.get(i))) continue;
            return (ItemStack)items.get(i);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack nextItem(List<ItemStack> itemStacks) {
        return itemStacks.get(Stocker.cyclic((int)0, (int)(itemStacks.indexOf(this.itemIcon) + 1), (int)itemStacks.size()));
    }

    public ItemStack previousItem(List<ItemStack> itemStacks) {
        return itemStacks.get(Stocker.cyclic((int)0, (int)(itemStacks.indexOf(this.itemIcon) - 1), (int)itemStacks.size()));
    }

    @Override
    public void setFocused(boolean bl) {
        if (bl) {
            this.updateRecipe();
        }
        super.setFocused(bl);
    }

    public abstract Component getDisplayName();

    abstract ItemStack nextItem();

    abstract ItemStack previousItem();

    abstract int findInventoryMatchSlot();

    abstract void updateRecipe();

    abstract LegacyScrollRenderer getScrollRenderer();

    public abstract boolean canCraft();

    public abstract List<Optional<Ingredient>> getIngredientsGrid();

    public ItemStack assembleCraftingResult(Level level, CraftingContainer container) {
        container.clearContent();
        for (int i = 0; i < this.getIngredientsGrid().size(); ++i) {
            if (!this.getIngredientsGrid().get(i).isPresent()) continue;
            container.setItem(i, FactoryIngredient.of((Ingredient)this.getIngredientsGrid().get(i).get()).getStacks()[0]);
        }
        CraftingInput input = container.asCraftInput();
        return CommonRecipeManager.getResultFor((RecipeType)RecipeType.CRAFTING, (RecipeInput)input, (Level)level).orElse(ItemStack.EMPTY);
    }

    @Override
    public void onPress(InputWithModifiers input) {
        if (this.isFocused()) {
            if (this.canCraft()) {
                this.craft(input);
                this.updateRecipe();
            } else {
                LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.CRAFT_FAIL.get(), 1.0f);
            }
        }
    }

    public void craft(InputWithModifiers input) {
        CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload(this.getRecipeId(), List.copyOf(this.getIngredientsGrid()), -1, input.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed));
    }

    public Optional<ResourceLocation> getRecipeId() {
        return Optional.empty();
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        int i = (int)Math.signum(g);
        if (this.isFocused() && !this.nextItem.isEmpty() && i > 0 || !this.previousItem.isEmpty() && i < 0) {
            LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
            this.itemIcon = i > 0 ? this.nextItem : this.previousItem;
            this.updateRecipe();
            return true;
        }
        return false;
    }

    @Override
    public void render(GuiGraphics graphics, int i, int j, float f) {
        if (this.itemIcon.isEmpty() || this.applyNextItemIfAbsent() && !this.hasItem(this.itemIcon) || this.isFocused()) {
            this.nextItem = this.nextItem();
            this.previousItem = this.previousItem();
        }
        if ((this.itemIcon.isEmpty() || this.applyNextItemIfAbsent() && !this.hasItem(this.itemIcon)) && !this.nextItem.isEmpty()) {
            this.itemIcon = this.nextItem;
            if (this.isFocused()) {
                this.updateRecipe();
            }
        }
        super.render(graphics, i, j, f);
    }

    protected boolean hasItem() {
        return this.hasItem(this.itemIcon);
    }

    protected boolean hasItem(ItemStack stack) {
        return !stack.isEmpty() && this.minecraft.player.getInventory().getNonEquipmentItems().stream().filter(s -> FactoryItemUtil.equalItems((ItemStack)s, (ItemStack)stack)).mapToInt(ItemStack::getCount).sum() >= stack.getCount();
    }

    @Override
    public void renderItem(GuiGraphics graphics, int i, int j, float f) {
        LegacyGuiItemRenderer.secureTranslucentRender(!this.itemIcon.isEmpty() && !this.hasItem(this.itemIcon), 0.5f, u -> this.renderItem(graphics, this.itemIcon, this.getX(), this.getY(), false));
    }

    public boolean canAddIngredient() {
        return this.hasItem(this.itemIcon) && this.addedIngredientsItems != null && this.canAddIngredient.test(this) && this.getIngredientsGrid().stream().anyMatch(Optional::isEmpty);
    }

    @Override
    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.key() == 79 && this.canAddIngredient()) {
            this.addedIngredientsItems.add(this.itemIcon.copyWithCount(1));
            this.updateRecipe();
            return true;
        }
        if (keyEvent.key() == 88 && this.addedIngredientsItems != null && !this.addedIngredientsItems.isEmpty()) {
            this.addedIngredientsItems.remove(this.addedIngredientsItems.size() - 1);
            this.updateRecipe();
            return true;
        }
        if (!this.nextItem.isEmpty() && keyEvent.isUp() || !this.previousItem.isEmpty() && keyEvent.isDown()) {
            LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
            this.itemIcon = keyEvent.isUp() ? this.nextItem : this.previousItem;
            this.updateRecipe();
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    @Override
    public void renderSelection(GuiGraphics graphics, int i, int j, float f) {
        Screen screen;
        super.renderSelection(graphics, i, j, f);
        if (!this.itemIcon.isEmpty() && this.hasItem(this.itemIcon) && (screen = this.minecraft.screen) instanceof LegacyMenuAccess) {
            LegacyMenuAccess a = (LegacyMenuAccess)screen;
            int matchSlot = this.findInventoryMatchSlot();
            if (matchSlot > 0) {
                Slot s = a.getMenu().getSlot(matchSlot);
                LegacyIconHolder h = LegacyRenderUtil.iconHolderRenderer.slotBounds(a.getMenuRectangle().left(), a.getMenuRectangle().top(), s);
                h.render(graphics, i, j, f);
                h.itemIcon = s.getItem();
                h.renderHighlight(graphics);
                h.renderItem(graphics, i, j, f);
            }
        }
        if (!this.previousItem.isEmpty() && this.previousItem != this.itemIcon || !this.nextItem.isEmpty() && this.nextItem != this.itemIcon) {
            this.renderScroll(graphics, this.getScrollRenderer());
        }
    }

    @Override
    @Nullable
    public Component getAction(ControlTooltip.ActionHolder.Context context) {
        return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 && this.isFocused() && this.canCraft() ? LegacyComponents.CREATE : (c.key() == 79 && this.isFocused() && this.canAddIngredient() ? LegacyComponents.ADD : null));
    }
}

