/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyLoading;
import wily.legacy.network.TopMessage;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public class LegacyLoadingScreen
extends Screen
implements LegacyLoading,
ControlTooltip.Event {
    private float progress;
    private Component loadingHeader;
    private Component loadingStage;
    private boolean genericLoading;
    private UIAccessor accessor = UIAccessor.of((Screen)this);

    public LegacyLoadingScreen() {
        super(GameNarrator.NO_TITLE);
    }

    public LegacyLoadingScreen(Component loadingHeader, Component loadingStage) {
        this();
        this.setLoadingHeader(loadingHeader);
        this.setLoadingStage(loadingStage);
    }

    public static LegacyLoadingScreen getDimensionChangeScreen(final BooleanSupplier levelReady, ResourceKey<Level> lastLevel, ResourceKey<Level> newLevel) {
        final long createdTime = Util.getMillis();
        boolean lastOd = LegacyLoadingScreen.isOtherDimension(lastLevel);
        boolean od = LegacyLoadingScreen.isOtherDimension(newLevel);
        LegacyLoadingScreen screen = new LegacyLoadingScreen((Component)(od || lastOd ? Component.translatable((String)("legacy.menu." + (lastOd ? "leaving" : "entering")), (Object[])new Object[]{LegacyComponents.getDimensionName(lastOd ? lastLevel : newLevel)}) : Component.empty()), (Component)Component.empty()){

            public void tick() {
                if (levelReady.getAsBoolean() || Util.getMillis() - createdTime >= 30000L) {
                    this.minecraft.setScreen(null);
                }
            }

            public boolean isPauseScreen() {
                return false;
            }
        };
        if (od || lastOd) {
            screen.setGenericLoading(true);
        }
        return screen;
    }

    public static boolean isOtherDimension(ResourceKey<Level> level) {
        return level != null && level != Level.OVERWORLD;
    }

    public static LegacyLoadingScreen getRespawningScreen(final BooleanSupplier levelReady) {
        final long createdTime = Util.getMillis();
        LegacyLoadingScreen screen = new LegacyLoadingScreen(LegacyComponents.RESPAWNING, (Component)Component.empty()){

            public void tick() {
                if (levelReady.getAsBoolean() || Util.getMillis() - createdTime >= 30000L) {
                    this.minecraft.setScreen(null);
                }
            }

            public boolean isPauseScreen() {
                return false;
            }
        };
        screen.setGenericLoading(true);
        return screen;
    }

    public static void startFakeAutoSave() {
        if (!((Boolean)LegacyOptions.fakeAutosaveScreen.get()).booleanValue()) {
            return;
        }
        Minecraft.getInstance().gui.autosaveIndicatorValue = 0.0f;
        TopMessage.setMedium(null);
        Minecraft.getInstance().setScreen((Screen)LegacyLoadingScreen.getFakeAutoSaveScreen());
    }

    public static LegacyLoadingScreen getFakeAutoSaveScreen() {
        return new LegacyLoadingScreen(LegacyComponents.PREPARING_AUTOSAVE, LegacyComponents.PREPARING_CHUNKS){
            int finalizingTicks = -1;

            public void tick() {
                this.minecraft.gui.autosaveIndicatorValue = 0.0f;
                super.tick();
                if (this.finalizingTicks < 0) {
                    this.setProgress(this.getProgress() + 0.02f);
                    if ((double)this.getProgress() >= 1.0) {
                        this.finalizingTicks = 80;
                        this.setProgress(0.0f);
                        this.setLoadingStage(LegacyComponents.FINALIZING);
                    }
                } else if (this.finalizingTicks > 0) {
                    --this.finalizingTicks;
                } else {
                    this.onClose();
                    LegacySoundUtil.playBackSound();
                    this.minecraft.gui.autosaveIndicatorValue = 1.0f;
                }
            }
        };
    }

    public static LegacyLoadingScreen createWithExecutor(Component header, final Runnable onClose, final ExecutorService executor) {
        return new LegacyLoadingScreen(header, (Component)Component.empty()){

            public void onClose() {
                onClose.run();
                4.closeExecutor(executor);
            }

            @Override
            public boolean shouldCloseOnEsc() {
                return true;
            }
        };
    }

    public static void closeExecutor(ExecutorService executor) {
        boolean bl;
        executor.shutdown();
        try {
            bl = executor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException var3) {
            bl = false;
        }
        if (!bl) {
            executor.shutdownNow();
        }
    }

    public void prepareRender(Minecraft minecraft, int width, int height, Component loadingHeader, Component loadingStage, float progress, boolean genericLoading) {
        this.resize(minecraft, width, height);
        this.minecraft = minecraft;
        this.accessor = UIAccessor.of((Screen)minecraft.screen);
        this.setLoadingHeader((Component)this.accessor.getElementValue("loadingHeader.component", (Object)loadingHeader, Component.class));
        this.setLoadingStage((Component)this.accessor.getElementValue("loadingStage.component", (Object)loadingStage, Component.class));
        this.setProgress(this.accessor.getFloat("progress", progress));
        this.setGenericLoading(this.accessor.getBoolean("genericLoading", Boolean.valueOf(genericLoading)));
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, true, true, false);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        FactoryScreenUtil.disableDepthTest();
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, true, true, false);
        super.render(guiGraphics, i, j, f);
        ArbitrarySupplier fontOverride = this.accessor.getElement("fontOverride", ResourceLocation.class);
        if (!this.isGenericLoading()) {
            if (this.getProgress() != -1.0f) {
                LegacyTip tip;
                int loadingBarX = this.accessor.getInteger("loadingBar.x", this.width / 2 - 160);
                int loadingBarY = this.accessor.getInteger("loadingBar.y", this.height / 2 + 15);
                if (this.getLoadingStage() != null) {
                    LegacyFontUtil.applySmallerFont((FontDescription)fontOverride.map(FontDescription.Resource::new).orElse((Object)FontDescription.DEFAULT), b -> guiGraphics.drawString(this.minecraft.font, this.getLoadingStage(), this.accessor.getInteger("loadingStage.x", loadingBarX + 1), this.accessor.getInteger("loadingStage.y", this.height / 2 + 5), ((Integer)CommonColor.STAGE_TEXT.get()).intValue()));
                }
                try (SpriteContents contents = FactoryGuiGraphics.getSprites().getSprite(LegacySprites.LOADING_BACKGROUND).contents();){
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LOADING_BACKGROUND, loadingBarX, loadingBarY, 320, 320 * contents.height() / contents.width());
                }
                if (this.getProgress() >= 0.0f) {
                    contents = FactoryGuiGraphics.getSprites().getSprite(LegacySprites.LOADING_BAR).contents();
                    try {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LOADING_BAR, 318, 318 * contents.height() / contents.width(), 0, 0, loadingBarX + 1, loadingBarY + 1, 0, (int)(318.0f * Math.max(0.0f, Math.min(this.getProgress(), 1.0f))), 318 * contents.height() / contents.width());
                    }
                    finally {
                        if (contents != null) {
                            contents.close();
                        }
                    }
                }
                if ((tip = Legacy4JClient.legacyTipManager.getLoadingTip()) != null) {
                    tip.setX(this.accessor.getInteger("loadingTip.x", (this.width - tip.width) / 2));
                    tip.setY(this.accessor.getInteger("loadingTip.y", loadingBarY + 10 + (this.height - (loadingBarY + 10) - tip.height) / 2));
                    tip.render(guiGraphics, i, j, f);
                }
            }
        } else {
            LegacyRenderUtil.drawGenericLoading(guiGraphics, (this.width - 75) / 2, this.height / 2);
        }
        if (this.getLoadingHeader() != null) {
            LegacyFontUtil.applySmallerFont((FontDescription)fontOverride.map(FontDescription.Resource::new).orElse((Object)FontDescription.DEFAULT), b -> {
                guiGraphics.pose().pushMatrix();
                float scaleX = this.accessor.getFloat("loadingHeader.scaleX", 2.0f);
                guiGraphics.pose().translate(this.accessor.getFloat("loadingHeader.x", ((float)this.width - (float)this.minecraft.font.width((FormattedText)this.getLoadingHeader()) * scaleX) / 2.0f), this.accessor.getFloat("loadingHeader.y", (float)(this.height / 2 - 23)));
                guiGraphics.pose().scale(scaleX, this.accessor.getFloat("loadingHeader.scaleY", 2.0f));
                LegacyRenderUtil.drawOutlinedString(guiGraphics, this.minecraft.font, this.getLoadingHeader(), 0, 0, (int)((Integer)CommonColor.TITLE_TEXT.get()), (int)((Integer)CommonColor.TITLE_TEXT_OUTLINE.get()), this.accessor.getFloat("loadingHeader.outline", 0.5f));
                guiGraphics.pose().popMatrix();
            });
        }
        FactoryScreenUtil.enableDepthTest();
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(float progress) {
        this.progress = progress;
    }

    @Override
    public Component getLoadingHeader() {
        return this.loadingHeader;
    }

    @Override
    public void setLoadingHeader(Component loadingHeader) {
        this.loadingHeader = loadingHeader;
    }

    @Override
    public Component getLoadingStage() {
        return this.loadingStage;
    }

    @Override
    public void setLoadingStage(Component loadingStage) {
        this.loadingStage = loadingStage;
    }

    @Override
    public boolean isGenericLoading() {
        return this.genericLoading;
    }

    @Override
    public void setGenericLoading(boolean genericLoading) {
        this.genericLoading = genericLoading;
    }
}

