/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.resources.ResourceLocation;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.util.LegacySprites;

public class LegacyScrollRenderer {
    public static final ResourceLocation[] SCROLLS = new ResourceLocation[]{LegacySprites.SCROLL_UP, LegacySprites.SCROLL_DOWN, LegacySprites.SCROLL_LEFT, LegacySprites.SCROLL_RIGHT};
    public final long[] lastScrolled = new long[4];
    public long lastScroll = 0L;
    public ScreenDirection lastDirection;

    public void updateScroll(ScreenDirection direction) {
        this.lastDirection = direction;
        long l = Util.getMillis();
        this.lastScrolled[direction.ordinal()] = l;
        this.lastScroll = l;
    }

    public void renderSmallScroll(GuiGraphics graphics, boolean up, int x, int y) {
        this.renderScroll(graphics, up ? ScreenDirection.UP : ScreenDirection.DOWN, x, y, up ? LegacySprites.SCROLL_UP_SMALL : LegacySprites.SCROLL_DOWN_SMALL, 7, 4);
    }

    public void renderScroll(GuiGraphics graphics, ScreenDirection direction, int x, int y) {
        if (direction.getAxis() == ScreenAxis.HORIZONTAL) {
            this.renderScroll(graphics, direction, x, y, SCROLLS[direction.ordinal()], 6, 11);
        } else {
            this.renderScroll(graphics, direction, x, y, SCROLLS[direction.ordinal()], 13, 7);
        }
    }

    public float getAlpha(long last) {
        float f = (float)(Util.getMillis() - last) / 320.0f;
        return Math.min(1.0f, f < 0.5f ? 1.0f - f * 2.0f : (f - 0.5f) * 2.0f);
    }

    public void renderScroll(GuiGraphics graphics, ScreenDirection direction, int x, int y, ResourceLocation sprite, int width, int height) {
        long l = this.lastScrolled[direction.ordinal()];
        if (l > 0L) {
            FactoryGuiGraphics.of((GuiGraphics)graphics).setBlitColor(1.0f, 1.0f, 1.0f, this.getAlpha(l));
        }
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(sprite, x, y, width, height);
        if (l > 0L) {
            FactoryGuiGraphics.of((GuiGraphics)graphics).clearBlitColor();
        }
    }
}

