/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.ListMap;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.SizeableAsset;
import wily.legacy.client.screen.ModsScreen;
import wily.legacy.util.IOUtil;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class LegacyTabButton
extends AbstractButton {
    public static final Vec2 DEFAULT_INACTIVE_OFFSET = new Vec2(0.0f, 22.0f);
    public static final Vec2 DEFAULT_UNSELECTED_OFFSET = new Vec2(0.0f, 4.0f);
    public static final ResourceLocation DEFAULT_ICON_TYPE_ID = FactoryAPI.createVanillaLocation((String)"sprite");
    public static final IconType<ResourceLocation> DEFAULT_ICON_TYPE = new IconType<ResourceLocation>(ResourceLocation.CODEC, LegacyTabButton::iconOf);
    public static final Codec<IconHolder<ResourceLocation>> DEFAULT_ICON_CODEC = ResourceLocation.CODEC.xmap(r -> new IconHolder<ResourceLocation>(DEFAULT_ICON_TYPE_ID, DEFAULT_ICON_TYPE, (ResourceLocation)r), IconHolder::content);
    public final Render icon;
    private final Consumer<LegacyTabButton> onPress;
    public Render spriteRender = ToggleableTabSprites.DEFAULT;
    public boolean selected;
    public Type type;
    public Offset offset = StateOffset.DEFAULT;
    public static final Codec<IconHolder<?>> ICON_HOLDER_CODEC = IOUtil.createFallbackCodec(LegacyTabButton.createIconHolderCodec("type", "value"), DEFAULT_ICON_CODEC.xmap(Function.identity(), h -> h));
    public static final Codec<SizeableAsset<IconHolder<?>>> ICON_SIZEABLE_CODEC = SizeableAsset.create(ICON_HOLDER_CODEC);
    public static final ListMap<ResourceLocation, IconType<?>> ICON_TYPES = new ListMap.Builder().put((Object)DEFAULT_ICON_TYPE_ID, DEFAULT_ICON_TYPE).put((Object)FactoryAPI.createVanillaLocation((String)"item"), new IconType<ArbitrarySupplier>(DynamicUtil.ITEM_SUPPLIER_CODEC, LegacyTabButton::iconOf)).put((Object)FactoryAPI.createVanillaLocation((String)"sizeable"), new IconType<SizeableAsset>(ICON_SIZEABLE_CODEC, LegacyTabButton::sizeableIconOf)).build();

    public LegacyTabButton(int i, int j, int width, int height, Type type, Render icon, Component text, Tooltip tooltip, Consumer<LegacyTabButton> onPress) {
        super(i, j, width, height, text);
        this.setTooltip(tooltip);
        this.onPress = onPress;
        this.type = type;
        this.icon = icon;
    }

    public static Render iconOf(Item item) {
        return (t, guiGraphics, i, j, f) -> t.renderItemIcon(item.getDefaultInstance(), guiGraphics);
    }

    public static Render iconOf(ItemStack stack) {
        return (t, guiGraphics, i, j, f) -> t.renderItemIcon(stack, guiGraphics);
    }

    public static Render iconOf(Supplier<ItemStack> stack) {
        return (t, guiGraphics, i, j, f) -> t.renderItemIcon((ItemStack)stack.get(), guiGraphics);
    }

    public static Render iconOf(ResourceLocation sprite) {
        return (t, guiGraphics, i, j, f) -> t.renderIconSprite(sprite, guiGraphics);
    }

    public static Render iconOf(ModsScreen.SizedLocation sized) {
        return (t, guiGraphics, i, j, f) -> FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(sized.location(), t.getX() + t.getWidth() / 2 - 12, t.getY() + t.getHeight() / 2 - 12, 0.0f, 0.0f, 24, sized.getScaledHeight(24), 24, sized.getScaledHeight(24));
    }

    public static Render sizeableIconOf(SizeableAsset<IconHolder<?>> sizeable) {
        return (t, guiGraphics, i, j, f) -> ((IconHolder)sizeable.get()).icon().render(t, guiGraphics, i, j, f);
    }

    public void onPress(InputWithModifiers input) {
        this.selected = !this.selected;
        this.onPress.accept(this);
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int i, boolean shadow) {
        this.renderString(guiGraphics, font, this.getX(), this.getY(), i, shadow);
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int x, int y, int i, boolean shadow) {
        LegacyFontUtil.applySDFont(b -> LegacyRenderUtil.renderScrollingString(guiGraphics, font, this.getMessage(), x + Math.max(6, (this.getWidth() - font.width((FormattedText)this.getMessage())) / 2), y - 2, x + this.getWidth() - 6, y + this.getHeight() - 1, i, shadow));
    }

    public void renderIconSprite(ResourceLocation icon, GuiGraphics guiGraphics) {
        if (LegacyOptions.getUIMode().isSD()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(icon, this.getX() + this.width / 2 - 8, this.getY() + this.height / 2 - 8, 16, 16);
        } else {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(icon, this.getX() + this.width / 2 - 12, this.getY() + this.height / 2 - 12, 24, 24);
        }
    }

    public void renderItemIcon(ItemStack itemIcon, GuiGraphics guiGraphics) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.getX() + (float)this.width / 2.0f, (float)this.getY() + (float)this.height / 2.0f);
        if (LegacyOptions.getUIMode().isSD()) {
            guiGraphics.pose().scale(0.75f, 0.75f);
        } else {
            guiGraphics.pose().scale(1.5f, 1.5f);
        }
        guiGraphics.renderItem(itemIcon, -8, -8);
        guiGraphics.pose().popMatrix();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        Minecraft minecraft = Minecraft.getInstance();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, this.alpha);
        FactoryScreenUtil.enableBlend();
        FactoryScreenUtil.enableDepthTest();
        guiGraphics.pose().pushMatrix();
        Vec2 translate = this.offset.apply(this);
        if (!translate.equals(Vec2.ZERO)) {
            guiGraphics.pose().translate(translate.x, translate.y);
            this.isHovered = this.isMouseOver(i, j);
        }
        this.spriteRender.render(this, guiGraphics, i, j, f);
        if (!this.selected) {
            guiGraphics.pose().translate(0.0f, -1.0f);
        }
        if (this.active) {
            if (this.icon == null) {
                this.renderString(guiGraphics, minecraft.font, (Integer)CommonColor.INVENTORY_GRAY_TEXT.get() | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
            } else {
                this.icon.render(this, guiGraphics, i, j, f);
            }
        }
        guiGraphics.pose().popMatrix();
    }

    public boolean isMouseOver(double d, double e) {
        Vec2 translate = this.offset.apply(this);
        double x = (float)this.getX() + (translate.equals(Vec2.ZERO) ? 0.0f : translate.x);
        double y = (float)this.getY() + (translate.equals(Vec2.ZERO) ? 0.0f : translate.y);
        return this.active && this.visible && d >= x && e >= y && d < x + (double)this.width && e < y + (double)this.height;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"gui.narrate.tab", (Object[])new Object[]{this.getMessage().getString()}));
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int i) {
        this.renderString(guiGraphics, font, i, false);
    }

    public static Codec<IconHolder<?>> createIconHolderCodec(String typeField, final String valueField) {
        final Codec typeCodec = ResourceLocation.CODEC.fieldOf(typeField).codec();
        return new Codec<IconHolder<?>>(){

            public <T> DataResult<Pair<IconHolder<?>, T>> decode(DynamicOps<T> ops, T input) {
                Dynamic dynamic = new Dynamic(ops, input);
                DataResult idResult = typeCodec.parse(dynamic);
                if (idResult.result().isEmpty()) {
                    idResult = DataResult.success((Object)DEFAULT_ICON_TYPE_ID);
                }
                return idResult.flatMap(f -> dynamic.get(valueField).flatMap(d -> ((IconType)ICON_TYPES.get(f)).parse((ResourceLocation)f, (Dynamic<?>)d).map(c -> Pair.of((Object)c, (Object)input))));
            }

            public <T> DataResult<T> encode(IconHolder<?> input, DynamicOps<T> ops, T prefix) {
                return typeCodec.encode((Object)((ResourceLocation)ICON_TYPES.getKey(input.type)), ops, prefix).flatMap(r -> input.encodeContent(ops, ops.empty()).map(value -> ops.set(r, valueField, value)));
            }
        };
    }

    public record ToggleableTabSprites(TabSprites high, TabSprite down) implements SpriteRender
    {
        public static final ToggleableTabSprites DEFAULT = new ToggleableTabSprites(new TabSprites(LegacySprites.HIGH_TAB_LEFT, LegacySprites.HIGH_TAB_MIDDLE, LegacySprites.HIGH_TAB_RIGHT), new TabSprite(LegacySprites.LOW_TAB));
        public static final ToggleableTabSprites VERTICAL = new ToggleableTabSprites(new TabSprites(LegacySprites.HIGH_VERT_TAB_DOWN, LegacySprites.HIGH_VERT_TAB_MIDDLE, LegacySprites.HIGH_VERT_TAB_UP), new TabSprite(LegacySprites.LOW_VERT_TAB));
        public static final Codec<ToggleableTabSprites> CODEC = RecordCodecBuilder.create(i -> i.group((App)TabSprites.CODEC.fieldOf("high").forGetter(ToggleableTabSprites::high), (App)TabSprite.CODEC.fieldOf("down").forGetter(ToggleableTabSprites::down)).apply((Applicative)i, ToggleableTabSprites::new));

        @Override
        public ResourceLocation getSprite(LegacyTabButton button) {
            return button.selected ? this.high.getSprite(button) : this.down.getSprite(button);
        }
    }

    public static interface Render {
        public void render(LegacyTabButton var1, GuiGraphics var2, int var3, int var4, float var5);
    }

    public record StateOffset(Vec2 selected, Vec2 unselected, Vec2 inactive) implements Offset
    {
        public static final StateOffset DEFAULT = new StateOffset(Vec2.ZERO, DEFAULT_UNSELECTED_OFFSET, DEFAULT_INACTIVE_OFFSET);
        public static final Codec<StateOffset> CODEC = RecordCodecBuilder.create(i -> i.group((App)Vec2.CODEC.fieldOf("selected").orElse((Object)Vec2.ZERO).forGetter(StateOffset::selected), (App)Vec2.CODEC.fieldOf("unselected").orElse((Object)DEFAULT_UNSELECTED_OFFSET).forGetter(StateOffset::unselected), (App)Vec2.CODEC.fieldOf("inactive").orElse((Object)DEFAULT_INACTIVE_OFFSET).forGetter(StateOffset::inactive)).apply((Applicative)i, StateOffset::new));

        @Override
        public Vec2 apply(LegacyTabButton t) {
            if (!t.isActive()) {
                return this.inactive;
            }
            if (!t.selected) {
                return this.unselected;
            }
            return this.selected;
        }
    }

    public static interface Offset
    extends Function<LegacyTabButton, Vec2> {
        @Override
        public Vec2 apply(LegacyTabButton var1);
    }

    public static enum Type {
        LEFT,
        MIDDLE,
        RIGHT;


        public static Type bySize(int actual, int size) {
            return actual == 0 ? LEFT : (actual + 1 >= size ? RIGHT : MIDDLE);
        }
    }

    public record IconHolder<T>(ResourceLocation typeId, IconType<T> type, T content, Render icon) {
        public IconHolder(ResourceLocation typeId, IconType<T> type, T content) {
            this(typeId, type, content, type.createIcon.apply(content));
        }

        public <C> DataResult<C> encodeContent(DynamicOps<C> ops, C prefix) {
            return this.type.contentCodec.encode(this.content, ops, prefix);
        }
    }

    public record IconType<T>(Codec<T> contentCodec, Function<T, Render> createIcon) {
        public DataResult<IconHolder<T>> parse(ResourceLocation typeId, Dynamic<?> dynamic) {
            return this.contentCodec.parse(dynamic).map(c -> new IconHolder<Object>(typeId, this, c));
        }
    }

    public record TabSprites(ResourceLocation left, ResourceLocation middle, ResourceLocation right) implements SpriteRender
    {
        public static final Codec<TabSprites> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("left").forGetter(TabSprites::left), (App)ResourceLocation.CODEC.fieldOf("middle").forGetter(TabSprites::middle), (App)ResourceLocation.CODEC.fieldOf("right").forGetter(TabSprites::right)).apply((Applicative)i, TabSprites::new));

        public ResourceLocation byType(Type type) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.left;
                case 1 -> this.middle;
                case 2 -> this.right;
            };
        }

        @Override
        public ResourceLocation getSprite(LegacyTabButton button) {
            return this.byType(button.type);
        }
    }

    public record TabSprite(ResourceLocation sprite) implements SpriteRender
    {
        public static final Codec<TabSprite> CODEC = ResourceLocation.CODEC.xmap(TabSprite::new, TabSprite::sprite);

        @Override
        public ResourceLocation getSprite(LegacyTabButton button) {
            return this.sprite();
        }
    }

    public static interface SpriteRender
    extends Render {
        public ResourceLocation getSprite(LegacyTabButton var1);

        @Override
        default public void render(LegacyTabButton button, GuiGraphics guiGraphics, int i, int j, float f) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.getSprite(button), button.getX(), button.getY(), button.getWidth(), button.getHeight());
        }
    }
}

