/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.OptionsPreset;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.util.LegacyComponents;

public class OptionsPresetScreen
extends ConfirmationScreen {
    public final OptionsPreset preset;
    public final OptionsPreset originalPreset;
    protected final List<RenderableVList> renderableVLists = new ArrayList<RenderableVList>();
    protected final RenderableVList showOptionsList = new RenderableVList(this.accessor);

    public OptionsPresetScreen(Screen parent, OptionsPreset preset) {
        super(parent, ConfirmationScreen::getPanelWidth, () -> LegacyOptions.getUIMode().isSD() ? 130 : 175, (Component)Component.translatable((String)"legacy.menu.options_preset", (Object[])new Object[]{preset.nameOrEmpty()}), LegacyComponents.OPTIONS_PRESET_MESSAGE, screen -> {
            screen.onClose();
            ((OptionsPresetScreen)screen).preset.applyAndSave();
        });
        this.renderableVLists.add(this.renderableVList);
        this.renderableVLists.add(this.showOptionsList);
        this.originalPreset = preset;
        this.preset = new OptionsPreset(preset.id(), preset.name(), new HashMap<String, Object>(preset.legacyOptions()), new HashMap<String, Object>(preset.vanillaOptions()));
        preset.legacyOptions().forEach((key, value) -> this.addSelectableOption((FactoryConfig)LegacyOptions.CLIENT_STORAGE.configMap.get(key), this.preset.legacyOptions(), value));
        preset.vanillaOptions().forEach((key, value) -> this.addSelectableOption(LegacyOptions.of(OptionsPreset.VANILLA_OPTIONS_MAP.get(key)), this.preset.vanillaOptions(), value));
    }

    public <T> void addSelectableOption(FactoryConfig<T> config, Map<String, Object> map, Object presetValue) {
        if (config.getDisplay() == null) {
            return;
        }
        this.showOptionsList.addRenderable((Renderable)new TickBox(0, 0, true, b -> config.getDisplay().getMessage(presetValue), b -> null, b -> {
            if (b.selected) {
                map.put(config.getKey(), presetValue);
            } else {
                map.remove(config.getKey());
            }
        }));
    }

    @Override
    protected void init() {
        super.init();
        this.setInitialFocus((GuiEventListener)this.okButton);
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        this.showOptionsList.mouseScrolled(g);
        return false;
    }

    @Override
    public boolean keyPressed(KeyEvent keyEvent) {
        return this.showOptionsList.keyPressed(keyEvent.key()) || super.keyPressed(keyEvent);
    }

    @Override
    public void renderableVListInit() {
        boolean sd = LegacyOptions.getUIMode().isSD();
        super.renderableVListInit();
        this.showOptionsList.init(this.renderableVList.leftPos, this.panel.y + (Integer)this.messageYOffset.get() + this.messageLabel.height + 8, this.renderableVList.listWidth, sd ? 56 : 72);
    }
}

