/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.server.LanServer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.commons.compress.utils.FileNameUtils;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.PatchNotesScreen;
import wily.legacy.client.screen.PublishScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.SaveRenderableList;
import wily.legacy.client.screen.ServerRenderableList;
import wily.legacy.client.screen.TabList;
import wily.legacy.client.screen.compat.FriendsServerRenderableList;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;

public class PlayGameScreen
extends PanelVListScreen
implements ControlTooltip.Event,
TabList.Access {
    public static final Component DIRECT_CONNECTION = Component.translatable((String)"selectServer.direct");
    private static final Component SAFETY_TITLE = Component.translatable((String)"multiplayerWarning.header").withStyle(ChatFormatting.BOLD);
    private static final Component SAFETY_CONTENT = Component.translatable((String)"multiplayerWarning.message");
    private static final Component SAFETY_CHECK = Component.translatable((String)"multiplayerWarning.check");
    public final SaveRenderableList saveRenderableList;
    public final CreationList creationList;
    protected final Panel panelRecess;
    protected final ServerRenderableList serverRenderableList;
    protected final TabList tabList;
    private final ServerStatusPinger pinger;
    public boolean isLoading;

    public PlayGameScreen(Screen parent, int initialTab) {
        super((Screen s) -> Panel.createPanel(s, p -> p.appearance(300, Math.min(256, s.height - 52)), p -> p.pos(p.centeredLeftPos((Screen)s), p.centeredTopPos((Screen)s) + (UIAccessor.of((Screen)s).getBoolean("hasTabList", Boolean.valueOf(true)) != false ? 12 : 0))), (Component)Component.translatable((String)"legacy.menu.play_game"));
        this.saveRenderableList = new SaveRenderableList(this.accessor);
        this.creationList = new CreationList(this.accessor);
        this.serverRenderableList = PublishScreen.hasWorldHost() ? new FriendsServerRenderableList(this.accessor) : new ServerRenderableList(this.accessor);
        this.tabList = new TabList(this.accessor).add(LegacyTabButton.Type.LEFT, (Component)Component.translatable((String)"legacy.menu.load"), b -> this.repositionElements()).add(LegacyTabButton.Type.MIDDLE, (Component)Component.translatable((String)"legacy.menu.create"), b -> this.repositionElements()).add(LegacyTabButton.Type.RIGHT, (t, guiGraphics, i, j, f) -> t.renderString(guiGraphics, this.font, this.canNotifyOnlineFriends() ? -1 : (Integer)CommonColor.INVENTORY_GRAY_TEXT.get(), this.canNotifyOnlineFriends()), (Component)Component.translatable((String)"legacy.menu.join"), b -> {
            if (this.minecraft.options.skipMultiplayerWarning) {
                this.repositionElements();
            } else {
                this.minecraft.setScreen((Screen)new ConfirmationScreen(this, this, SAFETY_TITLE, (Component)Component.translatable((String)"legacy.menu.multiplayer_warning").append("\n").append(SAFETY_CONTENT)){

                    @Override
                    protected void addButtons() {
                        this.renderableVList.addRenderable((Renderable)Button.builder((Component)SAFETY_CHECK, b -> {
                            this.minecraft.options.skipMultiplayerWarning = true;
                            this.minecraft.options.save();
                            this.onClose();
                        }).bounds(this.panel.x + (this.panel.width - 200) / 2, this.panel.y + this.panel.height - 52, 200, 20).build());
                        this.okButton = Button.builder((Component)Component.translatable((String)"gui.ok"), b -> this.okAction.accept(this)).bounds(this.panel.x + (this.panel.width - 200) / 2, this.panel.y + this.panel.height - 30, 200, 20).build();
                        this.renderableVList.addRenderable((Renderable)this.okButton);
                    }
                });
            }
        });
        this.pinger = new ServerStatusPinger();
        this.isLoading = false;
        this.panelRecess = Panel.createPanel(this, p -> p.appearance(LegacySprites.PANEL_RECESS, this.panel.width - 18, this.panel.height - 18 - (this.hasStorageBar() ? 21 : 0)), p -> p.pos(this.panel.x + 9, this.panel.y + 9));
        this.parent = parent;
        this.renderableVLists.clear();
        this.renderableVLists.add(this.saveRenderableList);
        this.renderableVLists.add(this.creationList);
        this.renderableVLists.add(this.serverRenderableList);
        this.tabList.setSelected(initialTab);
    }

    public PlayGameScreen(Screen parent) {
        this(parent, 0);
    }

    public static Screen createAndCheckNewerVersions(Screen parent) {
        PlayGameScreen screen = new PlayGameScreen(parent);
        if (Legacy4JClient.isNewerVersion) {
            Legacy4JClient.isNewerVersion = false;
            return PatchNotesScreen.createNewerVersion(PlayGameScreen.createAndCheckNewerVersions(parent));
        }
        if (Legacy4JClient.isNewerMinecraftVersion) {
            Legacy4JClient.isNewerMinecraftVersion = false;
            return PatchNotesScreen.createNewerMinecraftVersion(PlayGameScreen.createAndCheckNewerVersions(parent));
        }
        return screen;
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon(), () -> ControlTooltip.getKeyMessage(79, this));
        renderer.add(() -> this.tabList.getIndex() != 2 ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon()), () -> DIRECT_CONNECTION);
    }

    public boolean hasTabList() {
        return this.accessor.getBoolean("hasTabList", Boolean.valueOf(true));
    }

    protected boolean canNotifyOnlineFriends() {
        return this.serverRenderableList.hasOnlineFriends() && Util.getMillis() % 1000L < 500L;
    }

    @Override
    public TabList getTabList() {
        return this.tabList;
    }

    public void added() {
        super.added();
        this.serverRenderableList.added();
    }

    @Override
    protected void init() {
        if (this.hasTabList()) {
            this.addWidget(this.tabList);
        }
        this.panel.init();
        this.panelRecess.init("panelRecess");
        this.renderableVListInit();
        if (this.hasTabList()) {
            this.tabList.init(this.panel.x, this.panel.y - 25, this.panel.width, 31);
        }
    }

    @Override
    public void renderableVListInit() {
        this.initRenderableVListHeight(30);
        this.getRenderableVList().init(this.panel.x + 15, this.panel.y + 15, this.panel.width - 30, this.panel.height - 30 - (this.hasStorageBar() ? 21 : 0));
        if (!this.hasTabList()) {
            this.serverRenderableList.init("serverRenderableVList", this.panel.x + 15, this.panel.y + 15, this.panel.width - 30, this.panel.height - 30 - (this.hasStorageBar() ? 21 : 0));
        }
    }

    public boolean hasStorageBar() {
        return this.tabList.getIndex() == 0 && this.accessor.getBoolean("storageBar.isVisible", Boolean.valueOf(LegacyOptions.getUIMode().isFHD())) != false;
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
        if (this.hasTabList()) {
            this.tabList.render(guiGraphics, i, j, f);
        }
        this.panel.render(guiGraphics, i, j, f);
        this.tabList.renderSelected(guiGraphics, i, j, f);
        this.panelRecess.render(guiGraphics, i, j, f);
        if (this.hasStorageBar()) {
            if (this.saveRenderableList.currentlyDisplayedLevels != null) {
                guiGraphics.pose().pushMatrix();
                guiGraphics.pose().translate((float)this.panel.x + 11.25f, (float)(this.panel.y + this.panel.height) - 22.75f);
                long storage = new File("/").getTotalSpace();
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).enableScissor(0, 0, this.panel.width - 24, this.panel.height - 10);
                for (LevelSummary level : this.saveRenderableList.currentlyDisplayedLevels) {
                    AbstractButton b;
                    Long size = (Long)SaveRenderableList.sizeCache.getIfPresent((Object)level);
                    if (size == null) continue;
                    float scaledSize = Math.max(1.0f, (float)size.longValue() * ((float)this.panel.width - 21.0f) / (float)storage);
                    guiGraphics.pose().pushMatrix();
                    guiGraphics.pose().scale(scaledSize, 1.0f);
                    GuiEventListener guiEventListener = this.getFocused();
                    guiGraphics.fill(0, 0, 1, 11, (guiEventListener instanceof AbstractButton && this.saveRenderableList.renderables.contains(b = (AbstractButton)guiEventListener) && this.saveRenderableList.renderables.indexOf(b) == this.saveRenderableList.currentlyDisplayedLevels.indexOf(level) ? (Integer)CommonColor.SELECTED_STORAGE_SAVE.get() : (Integer)CommonColor.STORAGE_SAVE.get()).intValue());
                    guiGraphics.pose().popMatrix();
                    guiGraphics.pose().translate(scaledSize, 0.0f);
                }
                guiGraphics.pose().popMatrix();
                guiGraphics.disableScissor();
            }
            LegacyRenderUtil.renderPanelTranslucentRecess(guiGraphics, this.panel.x + 9, this.panel.y + this.panel.height - 25, this.panel.width - 18, 16);
        }
        if (this.isLoading) {
            LegacyRenderUtil.drawGenericLoading(guiGraphics, this.panelRecess.x + (this.panelRecess.width - 75) / 2, this.panelRecess.y + (this.panelRecess.height - 75) / 2);
        }
    }

    @Override
    public RenderableVList getRenderableVList() {
        return this.getRenderableVLists().get(this.hasTabList() ? this.tabList.getIndex() : 0);
    }

    public void removed() {
        if (this.saveRenderableList != null) {
            SaveRenderableList.resetIconCache();
        }
        this.serverRenderableList.removed();
        this.pinger.removeAll();
    }

    public void tick() {
        List list;
        super.tick();
        List<LevelSummary> summaries = this.saveRenderableList.pollLevelsIgnoreErrors();
        if (summaries != this.saveRenderableList.currentlyDisplayedLevels) {
            this.saveRenderableList.fillLevels("", summaries);
            this.repositionElements();
        }
        if (!((list = this.serverRenderableList.lanServerList.takeDirtyServers()) == null || this.serverRenderableList.lanServers != null && new HashSet<LanServer>(this.serverRenderableList.lanServers).containsAll(list))) {
            this.serverRenderableList.lanServers = list;
            this.serverRenderableList.updateServers();
            this.rebuildWidgets();
        }
        this.pinger.tick();
    }

    @Override
    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.hasTabList() && (this.tabList.controlTab(keyEvent.key()) || this.tabList.directionalControlTab(keyEvent.key()))) {
            return true;
        }
        if (super.keyPressed(keyEvent)) {
            return true;
        }
        if (keyEvent.key() == 294) {
            if (this.tabList.getIndex() == 0) {
                this.saveRenderableList.reloadSaveList();
            } else if (this.tabList.getIndex() == 2) {
                this.serverRenderableList.servers.load();
                this.serverRenderableList.updateServers();
            }
            this.rebuildWidgets();
            return true;
        }
        if (keyEvent.key() == 88 && this.tabList.getIndex() == 2) {
            final EditBox serverBox = new EditBox(Minecraft.getInstance().font, 0, 0, 200, 20, DIRECT_CONNECTION);
            this.minecraft.setScreen((Screen)new ConfirmationScreen(this, this, ConfirmationScreen::getPanelWidth, () -> LegacyOptions.getUIMode().isSD() ? 92 : 120, serverBox.getMessage(), LegacyComponents.ENTER_IP, b1 -> ConnectScreen.startConnecting((Screen)this, (Minecraft)this.minecraft, (ServerAddress)ServerAddress.parseString((String)serverBox.getValue()), (ServerData)new ServerData("", "", ServerData.Type.OTHER), (boolean)false, null)){

                @Override
                protected void addButtons() {
                    super.addButtons();
                    this.okButton.active = false;
                }

                @Override
                protected void init() {
                    super.init();
                    serverBox.setWidth(this.renderableVList.listWidth);
                    serverBox.setHeight(LegacyOptions.getUIMode().isSD() ? 16 : 20);
                    serverBox.setPosition(this.panel.getX() + (this.panel.getWidth() - serverBox.getWidth()) / 2, this.panel.getY() + (LegacyOptions.getUIMode().isSD() ? 32 : 45));
                    serverBox.setResponder(s -> {
                        this.okButton.active = ServerAddress.isValidAddress((String)s);
                    });
                    this.addRenderableWidget((GuiEventListener)serverBox);
                }
            });
            return true;
        }
        return false;
    }

    public ServerStatusPinger getPinger() {
        return this.pinger;
    }

    public ServerList getServers() {
        return this.serverRenderableList.servers;
    }

    public void onFilesDrop(List<Path> list) {
        if (this.tabList.getIndex() == 0) {
            for (Path path : list) {
                if (path.getFileName().toString().endsWith(".mcsave") || path.getFileName().toString().endsWith(".zip")) continue;
                return;
            }
            String string = list.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
            this.minecraft.setScreen((Screen)new ConfirmationScreen((Screen)this, (Component)Component.translatable((String)"legacy.menu.import_save"), (Component)Component.translatable((String)"legacy.menu.import_save_message", (Object[])new Object[]{string}), b -> {
                list.forEach(p -> {
                    try {
                        LegacySaveCache.importSaveFile(new FileInputStream(p.toFile()), this.minecraft.getLevelSource(), FileNameUtils.getBaseName((String)p.getFileName().toString()));
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                });
                this.minecraft.setScreen((Screen)this);
                this.saveRenderableList.reloadSaveList();
            }));
        }
    }
}

