/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class TickBox
extends AbstractButton {
    protected final Function<Boolean, Component> message;
    private final Consumer<TickBox> onPress;
    public boolean selected;
    protected Function<Boolean, Tooltip> tooltip;
    protected final BooleanSupplier selectedGetter;

    public TickBox(int i, int j, int width, int height, boolean initialState, Function<Boolean, Component> message, Function<Boolean, Tooltip> tooltip, Consumer<TickBox> onPress, BooleanSupplier selectedGetter) {
        super(i, j, width, height, message.apply(false));
        this.selected = initialState;
        this.message = message;
        this.tooltip = tooltip;
        this.onPress = onPress;
        this.selectedGetter = selectedGetter;
        this.setTooltip(tooltip.apply(this.selected));
    }

    public TickBox(int i, int j, int width, boolean initialState, Function<Boolean, Component> message, Function<Boolean, Tooltip> tooltip, Consumer<TickBox> onPress, BooleanSupplier selectedGetter) {
        this(i, j, width, TickBox.getDefaultHeight(), initialState, message, tooltip, onPress, selectedGetter);
    }

    public TickBox(int i, int j, int width, boolean initialState, Function<Boolean, Component> message, Function<Boolean, Tooltip> tooltip, Consumer<TickBox> onPress) {
        this(i, j, width, initialState, message, tooltip, onPress, null);
    }

    public TickBox(int i, int j, boolean initialState, Function<Boolean, Component> message, Function<Boolean, Tooltip> tooltip, Consumer<TickBox> onPress) {
        this(i, j, 200, initialState, message, tooltip, onPress);
    }

    public static int getDefaultHeight() {
        return LegacyOptions.getUIMode().isSD() ? 9 : 12;
    }

    public void onPress(InputWithModifiers input) {
        this.selected = !this.selected;
        this.onPress.accept(this);
        this.updateMessage();
    }

    public void updateMessage() {
        this.setTooltip(this.tooltip.apply(this.selected));
    }

    public void updateHeight() {
        this.setHeight(TickBox.getDefaultHeight());
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        this.setAlpha(this.active ? 1.0f : 0.5f);
        Minecraft minecraft = Minecraft.getInstance();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, this.alpha);
        FactoryScreenUtil.enableBlend();
        FactoryScreenUtil.enableDepthTest();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.isHoveredOrFocused() ? LegacySprites.TICKBOX_HOVERED : LegacySprites.TICKBOX, this.getX(), this.getY(), this.getHeight(), this.getHeight());
        if (this.selected) {
            if (LegacyOptions.getUIMode().isSD()) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMALL_TICK, this.getX(), this.getY(), 11, 9);
            } else {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.TICK, this.getX(), this.getY(), 14, 12);
            }
        }
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.pose().pushMatrix();
        if (!this.isHoveredOrFocused()) {
            guiGraphics.pose().translate(0.4f, 0.4f);
        }
        this.renderString(guiGraphics, minecraft.font, this.isHoveredOrFocused() ? LegacyRenderUtil.getDefaultTextColor() : (Integer)CommonColor.INVENTORY_GRAY_TEXT.get());
        guiGraphics.pose().popMatrix();
    }

    public Component getMessage() {
        return this.message.apply(this.selected);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            MutableComponent component = this.createNarrationMessage();
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{component}));
            } else {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{component}));
            }
        }
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int i) {
        LegacyFontUtil.applySDFont(b -> LegacyRenderUtil.renderScrollingString(guiGraphics, font, this.getMessage(), this.getX() + this.getHeight() + (LegacyOptions.getUIMode().isSD() ? 0 : 1), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), i, this.isHoveredOrFocused()));
    }

    public boolean updateValue() {
        if (this.selectedGetter != null) {
            boolean oldValue = this.selected;
            this.selected = this.selectedGetter.getAsBoolean();
            if (this.selected != oldValue) {
                this.updateMessage();
                return true;
            }
        }
        return false;
    }
}

