/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.init;

import java.util.function.BiConsumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;
import wily.factoryapi.FactoryAPIPlatform;
import wily.legacy.Legacy4JClient;
import wily.legacy.network.PlayerInfoSync;

public class LegacyGameRules {
    public static final GameRules.Key<GameRules.BooleanValue> GLOBAL_MAP_PLAYER_ICON = GameRules.register((String)"globalMapPlayerIcon", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)true));
    public static final GameRules.Key<GameRules.BooleanValue> DEFAULT_SHOW_ARMOR_STANDS_ARMS = GameRules.register((String)"defaultShowArmorStandArms", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.create((boolean)true, (server, booleanValue) -> PlayerInfoSync.All.syncGamerule(DEFAULT_SHOW_ARMOR_STANDS_ARMS, booleanValue, server)));
    public static final GameRules.Key<GameRules.IntegerValue> TNT_LIMIT = GameRules.register((String)"tntLimit", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.create((int)20));
    public static final GameRules.Key<GameRules.BooleanValue> PLAYER_STARTING_MAP = GameRules.register((String)"playerStartingMap", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)true));
    public static final GameRules.Key<GameRules.IntegerValue> DEFAULT_MAP_SIZE = GameRules.register((String)"defaultMapSize", (GameRules.Category)GameRules.Category.MISC, LegacyGameRules.createInteger(3, 0, 4, (server, integerValue) -> {}));
    public static final GameRules.Key<GameRules.BooleanValue> PLAYER_STARTING_BUNDLE = GameRules.register((String)"playerStartingBundle", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)false));
    public static final GameRules.Key<GameRules.BooleanValue> LEGACY_MAP_GRID = GameRules.register((String)"legacyMapGrid", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)true));
    public static final GameRules.Key<GameRules.BooleanValue> LEGACY_SWIMMING = GameRules.register((String)"legacySwimming", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)true, (server, booleanValue) -> PlayerInfoSync.All.syncGamerule(LEGACY_SWIMMING, booleanValue, server)));
    public static final GameRules.Key<GameRules.BooleanValue> LEGACY_FLIGHT = GameRules.register((String)"legacyFlight", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.create((boolean)true, (server, booleanValue) -> PlayerInfoSync.All.syncGamerule(LEGACY_FLIGHT, booleanValue, server)));

    public static GameRules.Key<GameRules.BooleanValue> getTntExplodes() {
        return GameRules.RULE_TNT_EXPLODES;
    }

    public static GameRules.Key<GameRules.BooleanValue> getPvp() {
        return GameRules.RULE_PVP;
    }

    public static boolean getSidedBooleanGamerule(Entity entity, GameRules.Key<GameRules.BooleanValue> key) {
        return entity.level().isClientSide() && Legacy4JClient.hasModOnServer() && Legacy4JClient.gameRules.getBoolean(key) || !entity.level().isClientSide() && FactoryAPIPlatform.getEntityServer((Entity)entity).getGameRules().getBoolean(key);
    }

    public static GameRules.Type<GameRules.IntegerValue> createInteger(int defaultValue, int min, int max, BiConsumer<MinecraftServer, GameRules.IntegerValue> biConsumer) {
        return GameRules.IntegerValue.create((int)defaultValue, (int)min, (int)max, (FeatureFlagSet)FeatureFlagSet.of(), biConsumer);
    }

    public static void init() {
    }
}

