/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerExplosion.class})
public abstract class ServerExplosionMixin
implements Explosion {
    @Shadow
    @Final
    private ServerLevel level;
    @Shadow
    @Final
    private Vec3 center;
    @Shadow
    @Final
    private float radius;

    @Inject(method={"interactWithBlocks"}, at={@At(value="RETURN")})
    private void explode(List<BlockPos> list, CallbackInfo ci) {
        for (ServerPlayer player : this.level.players()) {
            double d = Math.sqrt(player.distanceToSqr(this.center));
            if (d >= 21.0) {
                return;
            }
            for (BlockPos blockPos : list) {
                if (this.level.random.nextInt(d >= 15.0 ? 40 : 10) != 0) continue;
                double d0 = (float)blockPos.getX() + this.level.random.nextFloat();
                double d1 = (float)blockPos.getY() + this.level.random.nextFloat();
                double d2 = (float)blockPos.getZ() + this.level.random.nextFloat();
                double d3 = d0 - this.center.x;
                double d4 = d1 - this.center.y;
                double d5 = d2 - this.center.z;
                double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)this.radius + 0.1);
                d3 *= (d7 *= (double)(this.level.random.nextFloat() * this.level.random.nextFloat() + 0.3f));
                d4 *= d7;
                d5 *= d7;
                if (d <= 18.0) {
                    this.level.sendParticles(player, (ParticleOptions)ParticleTypes.POOF, false, false, (d0 + this.center.x) / 2.0, (d1 + this.center.y) / 2.0, (d2 + this.center.z) / 2.0, 0, d3, d4, d5, 1.0);
                }
                this.level.sendParticles(player, (ParticleOptions)ParticleTypes.SMOKE, false, false, d0, d1, d2, 0, d3, d4, d5, 1.0);
            }
        }
    }
}

