/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.GuiItemRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPIClient;
import wily.legacy.client.LegacyGuiItemRenderer;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.MutablePIPRenderState;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.util.LegacyItemUtil;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow(remap=false)
    private ItemStack tooltipStack;

    @Unique
    GuiGraphics self() {
        return (GuiGraphics)this;
    }

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")})
    private void renderItemDecorationsHead(Font font, ItemStack itemStack, int i, int j, String string, CallbackInfo ci) {
        LegacyFontUtil.legacyFont = false;
    }

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="RETURN")})
    private void renderItemDecorationsTail(Font font, ItemStack itemStack, int i, int j, String string, CallbackInfo ci) {
        LegacyFontUtil.legacyFont = true;
    }

    @Inject(method={"renderTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTooltipInternal(Font font, List<ClientTooltipComponent> list, int i, int j, ClientTooltipPositioner clientTooltipPositioner, ResourceLocation location, CallbackInfo ci) {
        if (!((Boolean)LegacyOptions.legacyItemTooltips.get()).booleanValue()) {
            return;
        }
        ci.cancel();
        LegacyFontUtil.applySDFont(b -> LegacyRenderUtil.renderTooltipInternal(this.self(), font, list, i, j, clientTooltipPositioner, this.tooltipStack));
    }

    @WrapOperation(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;III)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/render/state/GuiRenderState;submitItem(Lnet/minecraft/client/gui/render/state/GuiItemRenderState;)V")})
    private void renderItem(GuiRenderState instance, GuiItemRenderState arg, Operation<Void> original, @Nullable LivingEntity livingEntity, @Nullable Level level, ItemStack itemStack, int i, int j) {
        LegacyMenuAccess m;
        Screen screen;
        float g = (float)itemStack.getPopTime() - FactoryAPIClient.getGamePartialTick((boolean)true);
        if (g > 0.0f && (this.minecraft.screen == null || (screen = this.minecraft.screen) instanceof LegacyMenuAccess && (m = (LegacyMenuAccess)screen).allowItemPopping())) {
            float h = 1.0f + g / 5.0f;
            this.self().pose().pushMatrix();
            this.self().pose().translate((float)(i + 8), (float)(j + 12));
            this.self().pose().scale(1.0f / h, (h + 1.0f) / 2.0f);
            this.self().pose().translate((float)(-(i + 8)), (float)(-(j + 12)));
            original.call(new Object[]{instance, arg});
            this.self().pose().popMatrix();
            if (this.minecraft.player != null && !this.minecraft.player.getInventory().getNonEquipmentItems().contains((Object)itemStack)) {
                itemStack.setPopTime(itemStack.getPopTime() - 1);
            }
        } else {
            original.call(new Object[]{instance, arg});
        }
    }

    @Redirect(method={"renderItemCount"}, at=@At(value="INVOKE", target="Ljava/lang/String;valueOf(I)Ljava/lang/String;"))
    private String renderItemDecorationsTail(int i, Font font, ItemStack itemStack) {
        return i > itemStack.getMaxStackSize() && (Boolean)LegacyOptions.legacyOverstackedItems.get() != false ? I18n.get((String)"legacy.container.overstack", (Object[])new Object[]{itemStack.getMaxStackSize()}) : String.valueOf(i);
    }

    @ModifyReceiver(method={"submitEntityRenderState", "submitBookModelRenderState", "submitBannerPatternRenderState"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/render/state/GuiRenderState;submitPicturesInPictureState(Lnet/minecraft/client/gui/render/state/pip/PictureInPictureRenderState;)V")})
    private GuiRenderState submitEntityRenderState(GuiRenderState instance, PictureInPictureRenderState pictureInPictureRenderState) {
        MutablePIPRenderState.of(pictureInPictureRenderState).setPose((Matrix3x2f)this.self().pose());
        return instance;
    }

    @WrapOperation(method={"renderItemBar", "renderItemCooldown"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(Lcom/mojang/blaze3d/pipeline/RenderPipeline;IIIII)V")})
    private void fill(GuiGraphics instance, RenderPipeline j, int i, int renderPipeline, int k, int l, int m, Operation<Void> original) {
        float opacity = LegacyGuiItemRenderer.OPACITY;
        if (opacity != 1.0f) {
            m = ARGB.color((int)((int)((float)ARGB.alpha((int)m) * opacity)), (int)ARGB.transparent((int)m));
        }
        original.call(new Object[]{instance, j, i, renderPipeline, k, l, m});
    }

    @WrapOperation(method={"renderItemCount"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)V")})
    private void drawString(GuiGraphics instance, Font arg, String string, int i, int j, int k, boolean bl, Operation<Void> original) {
        float opacity = LegacyGuiItemRenderer.OPACITY;
        if (opacity != 1.0f) {
            k = ARGB.color((int)((int)((float)ARGB.alpha((int)k) * opacity)), (int)ARGB.transparent((int)k));
        }
        original.call(new Object[]{instance, arg, string, i, j, k, bl});
    }

    @Inject(method={"renderItemBar"}, at={@At(value="RETURN")})
    private void drawString(ItemStack itemStack, int i, int j, CallbackInfo ci) {
        if (!((Boolean)LegacyOptions.legacyPotionsBar.get()).booleanValue()) {
            return;
        }
        int potionLevel = LegacyItemUtil.getPotionLevel(itemStack);
        if (potionLevel > 0) {
            int x = i + 3;
            int y = j + 13;
            this.self().fill(RenderPipelines.GUI, x, y, x + 11, y + 2, -16777216);
            for (int k = 0; k < potionLevel; ++k) {
                this.self().fill(RenderPipelines.GUI, x + k * 3, y, x + k * 3 + 2, y + 2, -16720411);
            }
        }
    }
}

