/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryRenderStateExtension;
import wily.factoryapi.util.ColorUtil;
import wily.legacy.client.LegacyLivingEntityRenderState;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyVillagerRenderState;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin
extends EntityRenderer<LivingEntity, LivingEntityRenderState> {
    @Shadow
    @Final
    protected ItemModelResolver itemModelResolver;
    @Unique
    ItemStack emerald = Items.EMERALD.getDefaultInstance();

    protected LivingEntityRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(method={"getOverlayCoords"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getOverlayCoords(LivingEntityRenderState livingEntityRenderState, float f, CallbackInfoReturnable<Integer> cir) {
        if (((Boolean)LegacyOptions.legacyEntityFireTint.get()).booleanValue() && livingEntityRenderState.displayFireAnimation && !((LegacyLivingEntityRenderState)FactoryRenderStateExtension.Accessor.of((EntityRenderState)livingEntityRenderState).getExtension(LegacyLivingEntityRenderState.class)).fireImmune) {
            cir.setReturnValue((Object)OverlayTexture.pack((int)0, (int)OverlayTexture.v((boolean)true)));
        }
    }

    @Shadow
    public abstract EntityModel<LivingEntityRenderState> getModel();

    @Redirect(method={"extractRenderState(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isAlive()Z"))
    public boolean render(LivingEntity instance) {
        return true;
    }

    @Inject(method={"submit(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="HEAD")})
    public void render(LivingEntityRenderState livingEntityRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, CallbackInfo ci) {
        if (FactoryRenderStateExtension.Accessor.of((EntityRenderState)livingEntityRenderState).getExtension(LegacyVillagerRenderState.class) != null && ((LegacyVillagerRenderState)FactoryRenderStateExtension.Accessor.of((EntityRenderState)livingEntityRenderState).getExtension(LegacyVillagerRenderState.class)).isTrading && ((Boolean)LegacyOptions.merchantTradingIndicator.get()).booleanValue()) {
            poseStack.pushPose();
            poseStack.translate(0.0f, livingEntityRenderState.boundingBoxHeight + 0.5f, 0.0f);
            poseStack.mulPose((Quaternionfc)cameraRenderState.orientation);
            poseStack.scale(1.0f, 1.0f, 1.0E-4f);
            ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemStackRenderState, this.emerald, ItemDisplayContext.GROUND, (Level)Minecraft.getInstance().level, null, 0);
            itemStackRenderState.submit(poseStack, submitNodeCollector, livingEntityRenderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }

    @ModifyReturnValue(method={"getModelTint"}, at={@At(value="RETURN")})
    public int getModelTint(int color, LivingEntityRenderState livingEntityRenderState) {
        return (Boolean)LegacyOptions.legacyEntityFireTint.get() != false && livingEntityRenderState.displayFireAnimation && !((LegacyLivingEntityRenderState)FactoryRenderStateExtension.Accessor.of((EntityRenderState)livingEntityRenderState).getExtension(LegacyLivingEntityRenderState.class)).fireImmune ? ColorUtil.colorFromFloat((float)ColorUtil.getRed((int)color), (float)(ColorUtil.getGreen((int)color) * this.getGreenFireOverlayDiff(livingEntityRenderState.ageInTicks)), (float)(ColorUtil.getBlue((int)color) / 6.0f), (float)ColorUtil.getAlpha((int)color)) : color;
    }

    @Unique
    private float getGreenFireOverlayDiff(float age) {
        float range = age / 10.0f % 1.0f;
        return 0.6f + (range > 0.5f ? 1.0f - range : range) / 1.5f;
    }

    @ModifyExpressionValue(method={"extractRenderState(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;F)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;rotLerp(FFF)F", ordinal=0)})
    private float modifyHeadRotation(float original, LivingEntity entity, LivingEntityRenderState renderState, float f) {
        return (Boolean)LegacyOptions.headFollowsTheCamera.get() != false ? entity.getViewYRot(f) : original;
    }
}

