/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.NavigationElement;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyLoading;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

@Mixin(value={Screen.class})
public abstract class ScreenMixin
extends AbstractContainerEventHandler {
    @Shadow
    public int width;
    @Shadow
    public int height;
    @Shadow
    protected Minecraft minecraft;

    public Screen self() {
        return (Screen)this;
    }

    @Inject(method={"renderWithTooltipAndSubtitles"}, at={@At(value="HEAD")})
    private void renderWithTooltip(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        LegacyTipManager.tipDiffPercentage = Math.max(-0.5f, Math.min(LegacyTipManager.tipDiffPercentage + (LegacyTipManager.getActualTip() == null ? -0.1f : 0.08f) * f, 1.5f));
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(LegacyTipManager.getTipXDiff(), 0.0f);
    }

    @Inject(method={"renderWithTooltipAndSubtitles"}, at={@At(value="RETURN")})
    private void renderWithTooltipReturn(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        guiGraphics.pose().translate(-LegacyTipManager.getTipXDiff(), 0.0f);
        ControlTooltip.Renderer.of((Object)this).render(guiGraphics, i, j, f);
        guiGraphics.pose().popMatrix();
    }

    @Inject(method={"changeFocus"}, at={@At(value="HEAD")})
    private void changeFocus(ComponentPath componentPath, CallbackInfo ci) {
        if (componentPath instanceof ComponentPath.Path) {
            ComponentPath.Path path = (ComponentPath.Path)componentPath;
            NavigationElement.of(path.childPath().component()).playFocusSound(path);
        }
    }

    @Inject(method={"onClose"}, at={@At(value="HEAD")})
    private void onClose(CallbackInfo ci) {
        if (!(this.self() instanceof LegacyLoading)) {
            LegacySoundUtil.playBackSound();
        }
    }

    @Inject(method={"renderTransparentBackground"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderTransparentBackground(GuiGraphics graphics, CallbackInfo ci) {
        ci.cancel();
        if (this.self() instanceof AbstractContainerScreen && !((Boolean)LegacyOptions.menusWithBackground.get()).booleanValue()) {
            return;
        }
        LegacyRenderUtil.renderTransparentBackground(graphics);
    }

    @Inject(method={"renderBackground"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        if (UIAccessor.of((Screen)this.self()).getBoolean("hasBackground", Boolean.valueOf(true)).booleanValue() && (!(this.self() instanceof AbstractContainerScreen) || ((Boolean)LegacyOptions.menusWithBackground.get()).booleanValue())) {
            LegacyRenderUtil.renderDefaultBackground(UIAccessor.of((Screen)this.self()), guiGraphics, false);
        }
    }

    @Inject(method={"renderPanorama"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderPanorama(GuiGraphics guiGraphics, float f, CallbackInfo ci) {
        ci.cancel();
        LegacyRenderUtil.renderDefaultBackground(UIAccessor.of((Screen)this.self()), guiGraphics, true, false, !(this.self() instanceof TitleScreen));
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")})
    private void keyPressed(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (Legacy4JClient.keyToggleCursor.matches(keyEvent)) {
            Legacy4JClient.controllerManager.toggleCursor();
        }
    }

    @Redirect(method={"rebuildWidgets"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;clearFocus()V"))
    public void rebuildWidgets(Screen instance) {
    }

    @Inject(method={"setInitialFocus(Lnet/minecraft/client/gui/components/events/GuiEventListener;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void setInitialFocus(GuiEventListener guiEventListener, CallbackInfo ci) {
        if (this.getFocused() == null) {
            this.setFocused(guiEventListener);
        }
        ci.cancel();
    }

    @Inject(method={"rebuildWidgets"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;setInitialFocus()V", shift=At.Shift.AFTER)})
    public void rebuildWidgetsInitialFocus(CallbackInfo ci) {
        Legacy4JClient.postScreenInit((Screen)this);
    }

    @Inject(method={"setInitialFocus()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void setInitialFocus(CallbackInfo ci) {
        ci.cancel();
        Legacy4JClient.postScreenInit((Screen)this);
    }

    @Inject(method={"init(Lnet/minecraft/client/Minecraft;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;setInitialFocus()V", shift=At.Shift.AFTER)})
    public void init(Minecraft minecraft, int i, int j, CallbackInfo ci) {
        Legacy4JClient.postScreenInit((Screen)this);
    }
}

