/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.WaterFogEnvironment;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.client.LegacyBiomeOverride;

@Mixin(value={WaterFogEnvironment.class})
public abstract class WaterFogEnvironmentMixin {
    @Inject(method={"setupFog"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/fog/FogData;environmentalEnd:F", opcode=181, shift=At.Shift.AFTER)})
    private void setupWaterFogEnd(FogData fogData, Entity entity, BlockPos blockPos, ClientLevel clientLevel, float f, DeltaTracker deltaTracker, CallbackInfo ci) {
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            LegacyBiomeOverride o = LegacyBiomeOverride.getOrDefault(localPlayer.level().getBiome(entity.getOnPos()).unwrapKey());
            o.waterFogDistance().ifPresent(fogDistance -> {
                fogData.environmentalEnd = fogDistance.floatValue();
            });
        }
    }
}

