/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.chat;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Style;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.OverlayPanelScreen;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

@Mixin(value={ChatComponent.class})
public abstract class ChatComponentMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"getWidth(D)I"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getWidth(double d, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)Mth.floor((double)(d * (double)((float)Minecraft.getInstance().getWindow().getGuiScaledWidth() - (4.0f + LegacyRenderUtil.getChatSafeZone()) * 2.0f))));
    }

    @Shadow
    public abstract double getScale();

    @Shadow
    protected abstract int getLineHeight();

    @Shadow
    public abstract boolean isChatFocused();

    @Shadow
    protected abstract void drawTagIcon(GuiGraphics var1, int var2, int var3, GuiMessageTag.Icon var4);

    @Shadow
    protected abstract int getTagIconLeft(GuiMessage.Line var1);

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;forEachLine(IIZILnet/minecraft/client/gui/components/ChatComponent$LineConsumer;)I", ordinal=0), index=4)
    private ChatComponent.LineConsumer changeChatX(ChatComponent.LineConsumer lineConsumer, @Local(argsOnly=true) GuiGraphics guiGraphics, @Local(ordinal=5) int n, @Local(ordinal=8) int q, @Local(ordinal=9) int r, @Local(ordinal=1) float g, @Local(ordinal=2) float h) {
        return (lx, mx, nx, line, ox, hx) -> {
            int safeZone = Math.round(LegacyRenderUtil.getChatSafeZone());
            guiGraphics.fill(lx - 4 - safeZone, mx, lx + n + 4 + 4 + safeZone, nx, ARGB.color((float)(hx * h), (int)((Integer)CommonColor.CHAT_BACKGROUND.get())));
            GuiMessageTag guiMessageTag = line.tag();
            if (guiMessageTag != null) {
                int p = ARGB.color((float)(hx * g), (int)guiMessageTag.indicatorColor());
                guiGraphics.fill(lx - 4 - safeZone, mx, lx - 2 - safeZone, nx, p);
                if (ox == q && guiMessageTag.icon() != null) {
                    this.drawTagIcon(guiGraphics, this.getTagIconLeft(line), nx + r + 9, guiMessageTag.icon());
                }
            }
        };
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;forEachLine(IIZILnet/minecraft/client/gui/components/ChatComponent$LineConsumer;)I", ordinal=1)})
    private void changeChatFont(GuiGraphics guiGraphics, int i, int j, int k, boolean bl, CallbackInfo ci) {
        if (LegacyOptions.getUIMode().isSD()) {
            LegacyFontUtil.defaultFontOverride = LegacyFontUtil.MOJANGLES_11_FONT;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;forEachLine(IIZILnet/minecraft/client/gui/components/ChatComponent$LineConsumer;)I", ordinal=1, shift=At.Shift.AFTER)})
    private void changeChatFontAfter(GuiGraphics guiGraphics, int i, int j, int k, boolean bl, CallbackInfo ci) {
        LegacyFontUtil.defaultFontOverride = null;
    }

    @Inject(method={"getClickedComponentStyleAt"}, at={@At(value="HEAD")})
    private void changeClickedChatFont(double d, double e, CallbackInfoReturnable<Style> cir) {
        if (LegacyOptions.getUIMode().isSD()) {
            LegacyFontUtil.defaultFontOverride = LegacyFontUtil.MOJANGLES_11_FONT;
        }
    }

    @Inject(method={"getClickedComponentStyleAt"}, at={@At(value="RETURN")})
    private void changeClickedChatFontAfter(double d, double e, CallbackInfoReturnable<Style> cir) {
        LegacyFontUtil.defaultFontOverride = null;
    }

    @Inject(method={"addMessageToDisplayQueue"}, at={@At(value="HEAD")})
    private void changeClickedChatFontWidth(GuiMessage guiMessage, CallbackInfo ci) {
        if (LegacyOptions.getUIMode().isSD()) {
            LegacyFontUtil.defaultFontOverride = LegacyFontUtil.MOJANGLES_11_FONT;
        }
    }

    @Inject(method={"addMessageToDisplayQueue"}, at={@At(value="RETURN")})
    private void changeClickedChatFontWidthAfter(GuiMessage guiMessage, CallbackInfo ci) {
        LegacyFontUtil.defaultFontOverride = null;
    }

    @ModifyExpressionValue(method={"getMessageTagAt"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;screenToChatX(D)D")})
    private double changeMessageTagXPos(double original) {
        return original + (double)Math.round(LegacyRenderUtil.getChatSafeZone());
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void stopRender(GuiGraphics guiGraphics, int i, int j, int k, boolean bl, CallbackInfo ci) {
        if (this.minecraft.screen != null && !this.isChatFocused()) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lorg/joml/Matrix3x2fStack;pushMatrix()Lorg/joml/Matrix3x2fStack;", shift=At.Shift.AFTER, ordinal=0, remap=false)})
    private void changeRenderTranslation(GuiGraphics guiGraphics, int i, int j, int k, boolean bl, CallbackInfo ci) {
        guiGraphics.pose().translate(LegacyRenderUtil.getChatSafeZone(), LegacyRenderUtil.getHUDDistance() - 42.0f);
    }

    @Inject(method={"screenToChatX"}, at={@At(value="RETURN")}, cancellable=true)
    private void screenToChatX(double d, CallbackInfoReturnable<Double> cir) {
        cir.setReturnValue((Object)((Double)cir.getReturnValue() - (double)LegacyRenderUtil.getChatSafeZone()));
    }

    @Inject(method={"screenToChatY"}, at={@At(value="HEAD")}, cancellable=true)
    private void screenToChatY(double d, CallbackInfoReturnable<Double> cir) {
        double e = (double)this.minecraft.getWindow().getGuiScaledHeight() - d - 40.0 + (double)LegacyRenderUtil.getHUDDistance() - 42.0;
        cir.setReturnValue((Object)(e / (this.getScale() * (double)this.getLineHeight())));
    }

    @Inject(method={"isChatFocused"}, at={@At(value="HEAD")}, cancellable=true)
    private void isChatFocused(CallbackInfoReturnable<Boolean> cir) {
        Screen screen = this.minecraft.screen;
        if (screen instanceof OverlayPanelScreen) {
            OverlayPanelScreen s = (OverlayPanelScreen)screen;
            if (s.parent instanceof ChatScreen) {
                cir.setReturnValue((Object)true);
            }
        }
    }
}

