/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.container;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.DispenserScreen;
import net.minecraft.client.gui.screens.inventory.HopperScreen;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;

@Mixin(value={ContainerScreen.class, ShulkerBoxScreen.class, HopperScreen.class, DispenserScreen.class})
public abstract class ContainerScreenMixin
extends AbstractContainerScreen {
    public ContainerScreenMixin(AbstractContainerMenu abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        LegacyFontUtil.applySDFont(b -> super.renderLabels(guiGraphics, i, j));
    }

    public void init() {
        int rows;
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof ChestMenu) {
            ChestMenu m = (ChestMenu)abstractContainerMenu;
            v0 = m.getRowCount();
        } else {
            v0 = rows = this.menu instanceof HopperMenu ? 1 : 3;
        }
        int columns = this.menu instanceof HopperMenu ? 5 : (this.menu instanceof DispenserMenu ? 3 : 9);
        boolean sd = LegacyOptions.getUIMode().isSD();
        final int slowWidth = sd ? 13 : 21;
        int yDiff = (rows - 3) * slowWidth;
        boolean centeredTitle = this.menu instanceof HopperMenu || this.menu instanceof DispenserMenu;
        this.imageWidth = sd ? 130 : 215;
        this.imageHeight = (sd ? 128 : 207) + yDiff;
        this.titleLabelX = centeredTitle ? (this.imageWidth - this.font.width((FormattedText)this.title)) / 2 : (sd ? 7 : 14);
        this.titleLabelY = sd ? 5 : 11;
        this.inventoryLabelX = sd ? 7 : 14;
        this.inventoryLabelY = (sd ? 56 : 94) + yDiff;
        LegacySlotDisplay display = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return slowWidth;
            }
        };
        int slotsAmount = rows * columns;
        for (int i = 0; i < this.menu.slots.size(); ++i) {
            Slot s = (Slot)this.menu.slots.get(i);
            if (i < slotsAmount) {
                LegacySlotDisplay.override(s, (centeredTitle ? (this.imageWidth - columns * slowWidth) / 2 : this.inventoryLabelX) + s.getContainerSlot() % columns * slowWidth, (sd ? 15 : 26) + s.getContainerSlot() / columns * slowWidth, display);
                continue;
            }
            if (i < this.menu.slots.size() - 9) {
                LegacySlotDisplay.override(s, this.inventoryLabelX + (s.getContainerSlot() - 9) % 9 * slowWidth, (sd ? 66 : 107) + (s.getContainerSlot() - 9) / 9 * slowWidth + yDiff, display);
                continue;
            }
            LegacySlotDisplay.override(s, this.inventoryLabelX + s.getContainerSlot() * slowWidth, (sd ? 111 : 177) + yDiff, display);
        }
        super.init();
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(UIAccessor.of((Screen)this).getResourceLocation("imageSprite", LegacyOptions.getUIMode().isSD() ? LegacySprites.PANEL : LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
    }
}

